/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.usecase;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.usecase.Snapshot4Test;
import org.junit.jupiter.api.Assertions;

public class Snapshot5Test {
    public void testVerifyPreviousSession() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("MyProject");
        Assertions.assertTrue((boolean)project.exists());
        Assertions.assertTrue((boolean)project.isOpen());
        IResource[] resources = ResourceTestUtil.buildResources((IContainer)project, Snapshot4Test.defineHierarchy1());
        ResourceTestUtil.assertExistsInFileSystem(resources);
        ResourceTestUtil.assertExistsInWorkspace(resources);
        IFile file = project.getFile("added file");
        ResourceTestUtil.assertDoesNotExistInFileSystem((IResource)file);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
        file = project.getFile("yet another file");
        ResourceTestUtil.assertDoesNotExistInFileSystem((IResource)file);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)file);
        IFolder folder = project.getFolder("a folder");
        ResourceTestUtil.assertDoesNotExistInFileSystem((IResource)folder);
        ResourceTestUtil.assertDoesNotExistInWorkspace((IResource)folder);
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("Project2");
        Assertions.assertFalse((boolean)project.exists());
    }
}

