/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.util;

import java.io.File;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.FreezeMonitor;
import org.eclipse.core.tests.resources.ResourceTestUtil;
import org.eclipse.core.tests.resources.TestUtil;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class WorkspaceResetExtension
implements AfterEachCallback,
BeforeEachCallback {
    public void beforeEach(ExtensionContext context) throws Exception {
        ResourceTestUtil.waitForRefresh();
        TestUtil.log(1, context.getDisplayName(), "setUp", new Throwable[0]);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)ResourcesPlugin.getWorkspace(), (String)"Workspace was not set up");
        FreezeMonitor.expectCompletionInAMinute();
        ResourceTestUtil.waitForRefresh();
    }

    public void afterEach(ExtensionContext context) throws Exception {
        TestUtil.log(1, context.getDisplayName(), "tearDown", new Throwable[0]);
        try {
            this.restoreCleanWorkspace();
        }
        finally {
            FreezeMonitor.done();
            this.assertWorkspaceFolderEmpty();
        }
    }

    private void restoreCleanWorkspace() {
        ArrayList<CoreException> exceptions = new ArrayList<CoreException>();
        try {
            this.restoreWorkspaceDescription();
        }
        catch (CoreException e) {
            exceptions.add(e);
        }
        ResourceTestUtil.waitForBuild();
        try {
            ResourcesPlugin.getWorkspace().run(monitor -> ResourcesPlugin.getWorkspace().getRoot().delete(true, true, ResourceTestUtil.createTestMonitor()), null);
        }
        catch (CoreException e) {
            exceptions.add(e);
        }
        try {
            ResourcesPlugin.getWorkspace().save(true, null);
        }
        catch (CoreException e) {
            exceptions.add(e);
        }
        ResourceTestUtil.waitForBuild();
        if (!exceptions.isEmpty()) {
            IllegalStateException composedException = new IllegalStateException("Failures when cleaning up workspace");
            exceptions.forEach(exception -> composedException.addSuppressed((Throwable)exception));
            throw composedException;
        }
    }

    private void restoreWorkspaceDescription() throws CoreException {
        ResourcesPlugin.getWorkspace().setDescription((IWorkspaceDescription)Workspace.defaultWorkspaceDescription());
    }

    private void assertWorkspaceFolderEmpty() {
        String metadataDirectoryName = ".metadata";
        File workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
        Object[] remainingFilesInWorkspace = workspaceLocation.listFiles(file -> !file.getName().equals(".metadata"));
        ((ObjectArrayAssert)Assertions.assertThat((Object[])remainingFilesInWorkspace).as("check workspace folder is empty", new Object[0])).isEmpty();
    }
}

