/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions.tests;

import java.util.ArrayList;
import org.eclipse.core.expressions.CountExpression;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CountExpressionTest {
    private static EvaluationContext evaluationContext(int size) {
        ArrayList<Integer> variable = new ArrayList<Integer>(size + 1);
        int i = 0;
        while (i < size) {
            variable.add(i);
            ++i;
        }
        return new EvaluationContext(null, variable);
    }

    @Test
    public void testNoneExpression() throws CoreException {
        CountExpression e = new CountExpression("!");
        Assertions.assertEquals((Object)EvaluationResult.TRUE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(0)));
        Assertions.assertEquals((Object)EvaluationResult.FALSE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(1)));
    }

    @Test
    public void testNoneOrOneExpression() throws CoreException {
        CountExpression e = new CountExpression("?");
        Assertions.assertEquals((Object)EvaluationResult.TRUE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(0)));
        Assertions.assertEquals((Object)EvaluationResult.TRUE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(1)));
        Assertions.assertEquals((Object)EvaluationResult.FALSE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(2)));
    }

    @Test
    public void testExactExpression() throws CoreException {
        CountExpression e = new CountExpression("5");
        Assertions.assertEquals((Object)EvaluationResult.TRUE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(5)));
        Assertions.assertEquals((Object)EvaluationResult.FALSE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(7)));
    }

    @Test
    public void testAnyNumberExpression() throws CoreException {
        CountExpression e = new CountExpression("*");
        Assertions.assertEquals((Object)EvaluationResult.TRUE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(5)));
    }

    @Test
    public void testLessThanOrEqualToExpression() throws CoreException {
        CountExpression e = new CountExpression("-3]");
        Assertions.assertEquals((Object)EvaluationResult.TRUE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(1)));
        Assertions.assertEquals((Object)EvaluationResult.TRUE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(3)));
        Assertions.assertEquals((Object)EvaluationResult.FALSE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(4)));
    }

    @Test
    public void testLessThanExpression() throws CoreException {
        CountExpression e = new CountExpression("-3)");
        Assertions.assertEquals((Object)EvaluationResult.TRUE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(1)));
        Assertions.assertEquals((Object)EvaluationResult.FALSE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(3)));
        Assertions.assertEquals((Object)EvaluationResult.FALSE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(4)));
    }

    @Test
    public void testGreaterThanOrEqualToExpression() throws CoreException {
        CountExpression e = new CountExpression("[3-");
        Assertions.assertEquals((Object)EvaluationResult.TRUE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(5)));
        Assertions.assertEquals((Object)EvaluationResult.TRUE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(3)));
        Assertions.assertEquals((Object)EvaluationResult.FALSE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(2)));
    }

    @Test
    public void testGreaterThanExpression() throws CoreException {
        CountExpression e = new CountExpression("(3-");
        Assertions.assertEquals((Object)EvaluationResult.TRUE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(5)));
        Assertions.assertEquals((Object)EvaluationResult.FALSE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(3)));
        Assertions.assertEquals((Object)EvaluationResult.FALSE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(2)));
    }
}

