/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions.tests;

import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.core.expressions.AndExpression;
import org.eclipse.core.expressions.CountExpression;
import org.eclipse.core.expressions.EqualsExpression;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.TestExpression;
import org.eclipse.core.expressions.WithExpression;
import org.eclipse.core.internal.expressions.AdaptExpression;
import org.eclipse.core.internal.expressions.InstanceofExpression;
import org.eclipse.core.internal.expressions.IterateExpression;
import org.eclipse.core.internal.expressions.NotExpression;
import org.eclipse.core.internal.expressions.ResolveExpression;
import org.eclipse.core.internal.expressions.SystemTestExpression;
import org.junit.jupiter.api.Test;

public class ExpressionInfoTests {
    @Test
    public void testMergeEmpty() {
        ExpressionInfo info = new ExpressionInfo();
        info.merge(new ExpressionInfo());
        this.assertNoAccess(info);
    }

    @Test
    public void testMergeDefaultVariable() {
        ExpressionInfo info = new ExpressionInfo();
        info.markDefaultVariableAccessed();
        info.merge(new ExpressionInfo());
        this.assertDefaultAccessOnly(info);
        info = new ExpressionInfo();
        ExpressionInfo other = new ExpressionInfo();
        other.markDefaultVariableAccessed();
        info.merge(other);
        this.assertDefaultAccessOnly(info);
        info = new ExpressionInfo();
        other = new ExpressionInfo();
        info.markDefaultVariableAccessed();
        other.markDefaultVariableAccessed();
        info.merge(other);
        this.assertDefaultAccessOnly(info);
    }

    @Test
    public void testMergeSystemProperty() {
        ExpressionInfo info = new ExpressionInfo();
        info.markSystemPropertyAccessed();
        info.merge(new ExpressionInfo());
        this.assertSystemPropertyOnly(info);
        info = new ExpressionInfo();
        ExpressionInfo other = new ExpressionInfo();
        other.markSystemPropertyAccessed();
        info.merge(other);
        this.assertSystemPropertyOnly(info);
        info = new ExpressionInfo();
        other = new ExpressionInfo();
        info.markSystemPropertyAccessed();
        other.markSystemPropertyAccessed();
        info.merge(other);
        this.assertSystemPropertyOnly(info);
    }

    @Test
    public void testMergeVariableNames() {
        ExpressionInfo info = new ExpressionInfo();
        info.addVariableNameAccess("variable");
        info.merge(new ExpressionInfo());
        this.assertVariableAccess(info, "variable");
        info = new ExpressionInfo();
        ExpressionInfo other = new ExpressionInfo();
        other.addVariableNameAccess("variable");
        info.merge(other);
        this.assertVariableAccess(info, "variable");
        info = new ExpressionInfo();
        info.addVariableNameAccess("variable");
        other = new ExpressionInfo();
        other.addVariableNameAccess("variable");
        info.merge(other);
        this.assertVariableAccess(info, "variable");
        info = new ExpressionInfo();
        info.addVariableNameAccess("variable_one");
        other = new ExpressionInfo();
        other.addVariableNameAccess("variable_two");
        info.merge(other);
        this.assertVariableAccess(info, new String[]{"variable_one", "variable_two"});
    }

    @Test
    public void testMergePropertyNames() {
        ExpressionInfo info = new ExpressionInfo();
        info.addAccessedPropertyName("property");
        info.merge(new ExpressionInfo());
        this.assertPropertyAccess(info, "property", false);
        info = new ExpressionInfo();
        ExpressionInfo other = new ExpressionInfo();
        other.addAccessedPropertyName("property");
        info.merge(other);
        this.assertPropertyAccess(info, "property", false);
        info = new ExpressionInfo();
        other = new ExpressionInfo();
        info.addAccessedPropertyName("property");
        other.addAccessedPropertyName("property");
        info.merge(other);
        this.assertPropertyAccess(info, "property", false);
        info = new ExpressionInfo();
        other = new ExpressionInfo();
        info.addAccessedPropertyName("prop1");
        other.addAccessedPropertyName("prop2");
        info.merge(other);
        this.assertPropertyAccess(info, new String[]{"prop1", "prop2"});
    }

    @Test
    public void testMergeMisbehavingExpressionTypes() {
        ExpressionInfo info = new ExpressionInfo();
        info.addMisBehavingExpressionType(WithExpression.class);
        info.merge(new ExpressionInfo());
        this.assertMisbehavedExpressionTypes(info, new Class[]{WithExpression.class});
        info = new ExpressionInfo();
        ExpressionInfo other = new ExpressionInfo();
        other.addMisBehavingExpressionType(WithExpression.class);
        info.merge(other);
        this.assertMisbehavedExpressionTypes(info, new Class[]{WithExpression.class});
        info = new ExpressionInfo();
        info.addMisBehavingExpressionType(WithExpression.class);
        other = new ExpressionInfo();
        other.addMisBehavingExpressionType(WithExpression.class);
        info.merge(other);
        this.assertMisbehavedExpressionTypes(info, new Class[]{WithExpression.class});
        info = new ExpressionInfo();
        info.addMisBehavingExpressionType(WithExpression.class);
        other = new ExpressionInfo();
        other.addMisBehavingExpressionType(ResolveExpression.class);
        info.merge(other);
        this.assertMisbehavedExpressionTypes(info, new Class[]{WithExpression.class, ResolveExpression.class});
    }

    @Test
    public void testCountExpression() {
        this.assertDefaultAccessOnly(new CountExpression("10").computeExpressionInfo());
    }

    @Test
    public void testEqualsExpression() {
        this.assertDefaultAccessOnly(new EqualsExpression(new Object()).computeExpressionInfo());
    }

    @Test
    public void testInstanceofExpression() {
        this.assertDefaultAccessOnly(new InstanceofExpression("java.lang.Object").computeExpressionInfo());
    }

    @Test
    public void testNotExpression() {
        this.assertDefaultAccessOnly(new NotExpression((Expression)new CountExpression("10")).computeExpressionInfo());
    }

    @Test
    public void testSystemExpression() {
        this.assertSystemPropertyOnly(new SystemTestExpression("property", "value").computeExpressionInfo());
    }

    @Test
    public void testTestExpression() {
        this.assertPropertyAccess(new TestExpression("namespace", "property", null, new Object()).computeExpressionInfo(), "namespace.property", true);
    }

    @Test
    public void testAdaptExpression() throws Exception {
        this.assertDefaultAccessOnly(new AdaptExpression("java.lang.Object").computeExpressionInfo());
    }

    @Test
    public void testAndExpression() throws Exception {
        AndExpression and = new AndExpression();
        this.assertNoAccess(and.computeExpressionInfo());
        and.add((Expression)new CountExpression("10"));
        this.assertDefaultAccessOnly(and.computeExpressionInfo());
    }

    @Test
    public void testIterateExpression() throws Exception {
        this.assertDefaultAccessOnly(new IterateExpression("or").computeExpressionInfo());
    }

    @Test
    public void testResolveExpression() {
        ResolveExpression resolve = new ResolveExpression("variable", null);
        this.assertNoAccess(resolve.computeExpressionInfo());
        resolve.add((Expression)new CountExpression("10"));
        this.assertVariableAccess(resolve.computeExpressionInfo(), "variable");
    }

    @Test
    public void testWithExpression() {
        WithExpression with = new WithExpression("variable");
        this.assertNoAccess(with.computeExpressionInfo());
        with.add((Expression)new CountExpression("10"));
        this.assertVariableAccess(with.computeExpressionInfo(), "variable");
    }

    private void assertDefaultAccessOnly(ExpressionInfo info) {
        Assertions.assertThat((Object)info).matches(ExpressionInfo::hasDefaultVariableAccess, "accesses default variable");
        Assertions.assertThat((Object)info).matches(Predicate.not(ExpressionInfo::hasSystemPropertyAccess), "doesn't access system property");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])info.getAccessedVariableNames()).as("no variable accessed", new Object[0])).isEmpty();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])info.getMisbehavingExpressionTypes()).as("no misbehaving expression types", new Object[0])).isNull();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])info.getAccessedPropertyNames()).as("no properties accessed", new Object[0])).isEmpty();
    }

    private void assertSystemPropertyOnly(ExpressionInfo info) {
        Assertions.assertThat((Object)info).matches(Predicate.not(ExpressionInfo::hasDefaultVariableAccess), "doesn't access default variable");
        Assertions.assertThat((Object)info).matches(ExpressionInfo::hasSystemPropertyAccess, "accesses system property");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])info.getAccessedVariableNames()).as("no variable accessed", new Object[0])).isEmpty();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])info.getMisbehavingExpressionTypes()).as("no misbehaving expression types", new Object[0])).isNull();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])info.getAccessedPropertyNames()).as("no properties accessed", new Object[0])).isEmpty();
    }

    private void assertNoAccess(ExpressionInfo info) {
        Assertions.assertThat((Object)info).matches(Predicate.not(ExpressionInfo::hasDefaultVariableAccess), "doesn't access default variable");
        Assertions.assertThat((Object)info).matches(Predicate.not(ExpressionInfo::hasSystemPropertyAccess), "doesn't access system property");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])info.getAccessedVariableNames()).as("no variable accessed", new Object[0])).isEmpty();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])info.getMisbehavingExpressionTypes()).as("no misbehaving expression types", new Object[0])).isNull();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])info.getAccessedPropertyNames()).as("no properties accessed", new Object[0])).isEmpty();
    }

    private void assertVariableAccess(ExpressionInfo info, String variable) {
        Assertions.assertThat((Object)info).matches(Predicate.not(ExpressionInfo::hasDefaultVariableAccess), "doesn't access default variable");
        Assertions.assertThat((Object)info).matches(Predicate.not(ExpressionInfo::hasSystemPropertyAccess), "doesn't access system property");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])info.getAccessedVariableNames()).as("one variable accessed", new Object[0])).containsExactly((Object[])new String[]{variable});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])info.getMisbehavingExpressionTypes()).as("no misbehaving expression types", new Object[0])).isNull();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])info.getAccessedPropertyNames()).as("no properties accessed", new Object[0])).isEmpty();
    }

    private void assertVariableAccess(ExpressionInfo info, String[] variables) {
        Assertions.assertThat((Object)info).matches(Predicate.not(ExpressionInfo::hasDefaultVariableAccess), "doesn't access default variable");
        Assertions.assertThat((Object)info).matches(Predicate.not(ExpressionInfo::hasSystemPropertyAccess), "doesn't access system property");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])info.getAccessedVariableNames()).as("all variables accessed", new Object[0])).containsExactlyInAnyOrder((Object[])variables);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])info.getMisbehavingExpressionTypes()).as("no misbehaving expression types", new Object[0])).isNull();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])info.getAccessedPropertyNames()).as("no properties accessed", new Object[0])).isEmpty();
    }

    private void assertPropertyAccess(ExpressionInfo info, String property, boolean defaultVariable) {
        if (defaultVariable) {
            Assertions.assertThat((Object)info).matches(ExpressionInfo::hasDefaultVariableAccess, "accesses default variable");
        } else {
            Assertions.assertThat((Object)info).matches(Predicate.not(ExpressionInfo::hasDefaultVariableAccess), "doesn't access default variable");
        }
        Assertions.assertThat((Object)info).matches(Predicate.not(ExpressionInfo::hasSystemPropertyAccess), "doesn't access system property");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])info.getAccessedPropertyNames()).as("one property accessed", new Object[0])).containsExactly((Object[])new String[]{property});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])info.getMisbehavingExpressionTypes()).as("no misbehaving expression types", new Object[0])).isNull();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])info.getAccessedVariableNames()).as("no variable accessed", new Object[0])).isEmpty();
    }

    private void assertPropertyAccess(ExpressionInfo info, String[] properties) {
        Assertions.assertThat((Object)info).matches(Predicate.not(ExpressionInfo::hasDefaultVariableAccess), "doesn't access default variable");
        Assertions.assertThat((Object)info).matches(Predicate.not(ExpressionInfo::hasSystemPropertyAccess), "doesn't access system property");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])info.getAccessedPropertyNames()).as("all properties accessed", new Object[0])).containsExactlyInAnyOrder((Object[])properties);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])info.getMisbehavingExpressionTypes()).as("no misbehaving expression types", new Object[0])).isNull();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])info.getAccessedVariableNames()).as("one variable accessed", new Object[0])).isEmpty();
    }

    private void assertMisbehavedExpressionTypes(ExpressionInfo info, Class<?>[] types) {
        Assertions.assertThat((Object)info).matches(Predicate.not(ExpressionInfo::hasDefaultVariableAccess), "doesn't access default variable");
        Assertions.assertThat((Object)info).matches(Predicate.not(ExpressionInfo::hasSystemPropertyAccess), "doesn't access system property");
        ((ObjectArrayAssert)Assertions.assertThat((Object[])info.getAccessedVariableNames()).as("no variable accessed", new Object[0])).isEmpty();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])info.getAccessedPropertyNames()).as("no properties accessed", new Object[0])).isEmpty();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])info.getMisbehavingExpressionTypes()).as("all types accessed", new Object[0])).containsExactlyInAnyOrder((Object[])types);
    }
}

