/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions.tests;

import java.io.InputStream;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.core.expressions.AndExpression;
import org.eclipse.core.expressions.CountExpression;
import org.eclipse.core.expressions.EqualsExpression;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.expressions.IVariableResolver;
import org.eclipse.core.expressions.OrExpression;
import org.eclipse.core.expressions.TestExpression;
import org.eclipse.core.expressions.WithExpression;
import org.eclipse.core.internal.expressions.AdaptExpression;
import org.eclipse.core.internal.expressions.EnablementExpression;
import org.eclipse.core.internal.expressions.Expressions;
import org.eclipse.core.internal.expressions.InstanceofExpression;
import org.eclipse.core.internal.expressions.IterateExpression;
import org.eclipse.core.internal.expressions.NotExpression;
import org.eclipse.core.internal.expressions.ResolveExpression;
import org.eclipse.core.internal.expressions.SystemTestExpression;
import org.eclipse.core.internal.expressions.tests.A;
import org.eclipse.core.internal.expressions.tests.AdaptableAdaptee;
import org.eclipse.core.internal.expressions.tests.Adaptee;
import org.eclipse.core.internal.expressions.tests.B;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.osgi.framework.FrameworkUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ExpressionTests {
    private static final int TYPE_ITERATIONS = 100000;

    @Test
    public void testEscape() throws Exception {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Str'ing", (Object)Expressions.unEscapeString((String)"Str''ing"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"'", (Object)Expressions.unEscapeString((String)"''"));
        org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> {
            String string = Expressions.unEscapeString((String)"'");
        });
    }

    @Test
    public void testArgumentConversion() throws Exception {
        Assertions.assertThat((Object)Expressions.convertArgument(null)).isNull();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)Expressions.convertArgument((String)""));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)Expressions.convertArgument((String)"''"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"eclipse", (Object)Expressions.convertArgument((String)"eclipse"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"e'clips'e", (Object)Expressions.convertArgument((String)"e'clips'e"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"eclipse", (Object)Expressions.convertArgument((String)"'eclipse'"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"'ecl'ipse'", (Object)Expressions.convertArgument((String)"'''ecl''ipse'''"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"true", (Object)Expressions.convertArgument((String)"'true'"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1.7", (Object)Expressions.convertArgument((String)"'1.7'"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"007", (Object)Expressions.convertArgument((String)"'007'"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Boolean.TRUE, (Object)Expressions.convertArgument((String)"true"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Boolean.FALSE, (Object)Expressions.convertArgument((String)"false"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)100, (Object)Expressions.convertArgument((String)"100"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Float.valueOf(1.7f), (Object)Expressions.convertArgument((String)"1.7"));
    }

    @Test
    public void testArgumentParsing() throws Exception {
        Object[] result = null;
        result = Expressions.parseArguments((String)"");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)result[0]);
        result = Expressions.parseArguments((String)"s1");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"s1", (Object)result[0]);
        result = Expressions.parseArguments((String)" s1 ");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"s1", (Object)result[0]);
        result = Expressions.parseArguments((String)"s1,s2");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"s1", (Object)result[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"s2", (Object)result[1]);
        result = Expressions.parseArguments((String)" s1 , s2 ");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"s1", (Object)result[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"s2", (Object)result[1]);
        result = Expressions.parseArguments((String)"' s1 ',' s2 '");
        org.junit.jupiter.api.Assertions.assertEquals((Object)" s1 ", (Object)result[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)" s2 ", (Object)result[1]);
        result = Expressions.parseArguments((String)" s1 , ' s2 '");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"s1", (Object)result[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)" s2 ", (Object)result[1]);
        result = Expressions.parseArguments((String)"' s1 ', s2 ");
        org.junit.jupiter.api.Assertions.assertEquals((Object)" s1 ", (Object)result[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"s2", (Object)result[1]);
        result = Expressions.parseArguments((String)"''''");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"'", (Object)result[0]);
        result = Expressions.parseArguments((String)"''',''',','");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"','", (Object)result[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)",", (Object)result[1]);
        result = Expressions.parseArguments((String)"' s1 ', true ");
        org.junit.jupiter.api.Assertions.assertEquals((Object)" s1 ", (Object)result[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Boolean.TRUE, (Object)result[1]);
        org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> {
            Object[] objectArray = Expressions.parseArguments((String)"' s1");
        });
        org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> {
            Object[] objectArray = Expressions.parseArguments((String)"'''s1");
        });
    }

    @Test
    public void testSystemProperty() throws Exception {
        SystemTestExpression expression = new SystemTestExpression("os.name", System.getProperty("os.name"));
        EvaluationResult result = expression.evaluate((IEvaluationContext)new EvaluationContext(null, new Object()));
        Assertions.assertThat((Object)result).isEqualTo((Object)EvaluationResult.TRUE);
    }

    @Test
    public void testAdaptExpression() throws Exception {
        AdaptExpression expression = new AdaptExpression("org.eclipse.core.internal.expressions.tests.Adapter");
        expression.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        EvaluationResult result = expression.evaluate((IEvaluationContext)new EvaluationContext(null, (Object)new Adaptee()));
        Assertions.assertThat((Object)result).isEqualTo((Object)EvaluationResult.TRUE);
    }

    @Test
    public void testAdaptExpressionAdaptable() throws Exception {
        AdaptExpression expression = new AdaptExpression("org.eclipse.core.internal.expressions.tests.Adapter");
        expression.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        EvaluationResult result = expression.evaluate((IEvaluationContext)new EvaluationContext(null, (Object)new AdaptableAdaptee()));
        Assertions.assertThat((Object)result).isEqualTo((Object)EvaluationResult.TRUE);
    }

    @Test
    public void testAdaptExpressionNotEqual() throws Exception {
        AdaptExpression expression1 = new AdaptExpression("org.eclipse.core.internal.expressions.tests.Adapter");
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter1"));
        AdaptExpression expression2 = new AdaptExpression("org.eclipse.core.internal.expressions.tests.Adapter");
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter2"));
        Assertions.assertThat((Object)expression1).isNotEqualTo((Object)expression2);
    }

    @Test
    public void testAdaptExpressionHashCode() throws Exception {
        AdaptExpression expression1 = new AdaptExpression("org.eclipse.core.internal.expressions.tests.Adapter");
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        AdaptExpression expression2 = new AdaptExpression("org.eclipse.core.internal.expressions.tests.Adapter");
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        ((AbstractIntegerAssert)Assertions.assertThat((int)expression1.hashCode()).as("Equal expressions should have the same hash code", new Object[0])).isEqualTo(expression2.hashCode());
    }

    @Test
    public void testAdaptExpressionFail() throws Exception {
        AdaptExpression expression = new AdaptExpression("org.eclipse.core.internal.expressions.tests.NotExisting");
        EvaluationResult result = expression.evaluate((IEvaluationContext)new EvaluationContext(null, (Object)new Adaptee()));
        Assertions.assertThat((Object)result).isEqualTo((Object)EvaluationResult.FALSE);
    }

    @Test
    public void testAdaptExpressionFail2() throws Exception {
        AdaptExpression expression = new AdaptExpression("org.eclipse.core.internal.expressions.tests.Adapter");
        expression.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.NotExisting"));
        EvaluationResult result = expression.evaluate((IEvaluationContext)new EvaluationContext(null, (Object)new Adaptee()));
        Assertions.assertThat((Object)result).isEqualTo((Object)EvaluationResult.FALSE);
    }

    @Test
    public void testAdaptExpressionWithNull() throws Exception {
        EvaluationContext testContext = new EvaluationContext(null, (Object)new Adaptee());
        testContext.addVariable("nullCarrier", Arrays.asList(null, null, null));
        WithExpression withExpression = new WithExpression("nullCarrier");
        IterateExpression iterateExpression = new IterateExpression("and");
        iterateExpression.add((Expression)new AdaptExpression("org.eclipse.core.internal.expressions.tests.NotExisting"));
        withExpression.add((Expression)iterateExpression);
        EvaluationResult result = withExpression.evaluate((IEvaluationContext)testContext);
        Assertions.assertThat((Object)result).isEqualTo((Object)EvaluationResult.FALSE);
    }

    @Test
    public void testAndExpressionNotEqual() throws Exception {
        AndExpression expression1 = new AndExpression();
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter1"));
        AndExpression expression2 = new AndExpression();
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter2"));
        Assertions.assertThat((Object)expression1).isNotEqualTo((Object)expression2);
    }

    @Test
    public void testAndExpressionHashCode() throws Exception {
        AndExpression expression1 = new AndExpression();
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        AndExpression expression2 = new AndExpression();
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        ((AbstractIntegerAssert)Assertions.assertThat((int)expression1.hashCode()).as("Equal expressions should have the same hash code", new Object[0])).isEqualTo(expression2.hashCode());
    }

    @Test
    public void testCountExpressionNotEqual() throws Exception {
        CountExpression expression1 = new CountExpression("+");
        CountExpression expression2 = new CountExpression("!");
        Assertions.assertThat((Object)expression1).isNotEqualTo((Object)expression2);
    }

    @Test
    public void testCountExpressionHashCode() throws Exception {
        CountExpression expression1 = new CountExpression("*");
        CountExpression expression2 = new CountExpression("*");
        ((AbstractIntegerAssert)Assertions.assertThat((int)expression1.hashCode()).as("Equal expressions should have the same hash code", new Object[0])).isEqualTo(expression2.hashCode());
    }

    @Test
    public void testEnablementExpressionNotEqual() throws Exception {
        EnablementExpression expression1 = new EnablementExpression(null);
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter1"));
        EnablementExpression expression2 = new EnablementExpression(null);
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter2"));
        Assertions.assertThat((Object)expression1).isNotEqualTo((Object)expression2);
    }

    @Test
    public void testEnablementExpressionHashCode() throws Exception {
        EnablementExpression expression1 = new EnablementExpression(null);
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        EnablementExpression expression2 = new EnablementExpression(null);
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        ((AbstractIntegerAssert)Assertions.assertThat((int)expression1.hashCode()).as("Equal expressions should have the same hash code", new Object[0])).isEqualTo(expression2.hashCode());
    }

    @Test
    public void testEqualsExpressionNotEqual() throws Exception {
        EqualsExpression expression1 = new EqualsExpression((Object)"+");
        EqualsExpression expression2 = new EqualsExpression((Object)"!");
        Assertions.assertThat((Object)expression1).isNotEqualTo((Object)expression2);
    }

    @Test
    public void testEqualsExpressionHashCode() throws Exception {
        EqualsExpression expression1 = new EqualsExpression((Object)"*");
        EqualsExpression expression2 = new EqualsExpression((Object)"*");
        ((AbstractIntegerAssert)Assertions.assertThat((int)expression1.hashCode()).as("Equal expressions should have the same hash code", new Object[0])).isEqualTo(expression2.hashCode());
    }

    @Test
    public void testInstanceOfExpressionNotEqual() throws Exception {
        InstanceofExpression expression1 = new InstanceofExpression("+");
        InstanceofExpression expression2 = new InstanceofExpression("!");
        Assertions.assertThat((Object)expression1).isNotEqualTo((Object)expression2);
    }

    @Test
    public void testInstanceOfExpressionHashCode() throws Exception {
        InstanceofExpression expression1 = new InstanceofExpression("*");
        InstanceofExpression expression2 = new InstanceofExpression("*");
        ((AbstractIntegerAssert)Assertions.assertThat((int)expression1.hashCode()).as("Equal expressions should have the same hash code", new Object[0])).isEqualTo(expression2.hashCode());
    }

    @Test
    public void testIterateExpressionNotEqual() throws Exception {
        IterateExpression expression1 = new IterateExpression("or");
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        IterateExpression expression2 = new IterateExpression("and");
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        Assertions.assertThat((Object)expression1).isNotEqualTo((Object)expression2);
    }

    @Test
    public void testIterateExpressionHashCode() throws Exception {
        IterateExpression expression1 = new IterateExpression("and");
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        IterateExpression expression2 = new IterateExpression("and");
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        ((AbstractIntegerAssert)Assertions.assertThat((int)expression1.hashCode()).as("Equal expressions should have the same hash code", new Object[0])).isEqualTo(expression2.hashCode());
    }

    @Test
    public void testNotExpressionNotEqual() throws Exception {
        NotExpression expression1 = new NotExpression((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter1"));
        NotExpression expression2 = new NotExpression((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter2"));
        Assertions.assertThat((Object)expression1).isNotEqualTo((Object)expression2);
    }

    @Test
    public void testNotExpressionHashCode() throws Exception {
        NotExpression expression1 = new NotExpression((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        NotExpression expression2 = new NotExpression((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        ((AbstractIntegerAssert)Assertions.assertThat((int)expression1.hashCode()).as("Equal expressions should have the same hash code", new Object[0])).isEqualTo(expression2.hashCode());
    }

    @Test
    public void testOrExpressionNotEqual() throws Exception {
        OrExpression expression1 = new OrExpression();
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter1"));
        OrExpression expression2 = new OrExpression();
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter2"));
        Assertions.assertThat((Object)expression1).isNotEqualTo((Object)expression2);
    }

    @Test
    public void testOrExpressionHashCode() throws Exception {
        OrExpression expression1 = new OrExpression();
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        OrExpression expression2 = new OrExpression();
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        ((AbstractIntegerAssert)Assertions.assertThat((int)expression1.hashCode()).as("Equal expressions should have the same hash code", new Object[0])).isEqualTo(expression2.hashCode());
    }

    @Test
    public void testResolveExpressionNotEqual() throws Exception {
        ResolveExpression expression1 = new ResolveExpression("variable1", new Object[0]);
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter1"));
        ResolveExpression expression2 = new ResolveExpression("variable2", new Object[0]);
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter2"));
        Assertions.assertThat((Object)expression1).isNotEqualTo((Object)expression2);
    }

    @Test
    public void testResolveExpressionHashCode() throws Exception {
        ResolveExpression expression1 = new ResolveExpression("variable", new Object[0]);
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        ResolveExpression expression2 = new ResolveExpression("variable", new Object[0]);
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        ((AbstractIntegerAssert)Assertions.assertThat((int)expression1.hashCode()).as("Equal expressions should have the same hash code", new Object[0])).isEqualTo(expression2.hashCode());
    }

    @Test
    public void testSystemTestExpressionNotEqual() throws Exception {
        SystemTestExpression expression1 = new SystemTestExpression("prop", "value1");
        SystemTestExpression expression2 = new SystemTestExpression("prop", "value2");
        Assertions.assertThat((Object)expression1).isNotEqualTo((Object)expression2);
    }

    @Test
    public void testSystemTestExpressionHashCode() throws Exception {
        SystemTestExpression expression1 = new SystemTestExpression("prop", "value");
        SystemTestExpression expression2 = new SystemTestExpression("prop", "value");
        ((AbstractIntegerAssert)Assertions.assertThat((int)expression1.hashCode()).as("Equal expressions should have the same hash code", new Object[0])).isEqualTo(expression2.hashCode());
    }

    @Test
    public void testTestExpressionNotEqual() throws Exception {
        TestExpression expression1 = new TestExpression("namespace", "prop", new Object[0], (Object)"value1");
        TestExpression expression2 = new TestExpression("namespace", "prop", new Object[0], (Object)"value2");
        Assertions.assertThat((Object)expression1).isNotEqualTo((Object)expression2);
    }

    @Test
    public void testTestExpressionHashCode() throws Exception {
        TestExpression expression1 = new TestExpression("namespace", "prop", new Object[0], (Object)"value");
        TestExpression expression2 = new TestExpression("namespace", "prop", new Object[0], (Object)"value");
        ((AbstractIntegerAssert)Assertions.assertThat((int)expression1.hashCode()).as("Equal expressions should have the same hash code", new Object[0])).isEqualTo(expression2.hashCode());
    }

    @Test
    public void testWithExpressionNotEqual() throws Exception {
        WithExpression expression1 = new WithExpression("variable1");
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter1"));
        WithExpression expression2 = new WithExpression("variable2");
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter2"));
        Assertions.assertThat((Object)expression1).isNotEqualTo((Object)expression2);
    }

    @Test
    public void testWithExpressionHashCode() throws Exception {
        WithExpression expression1 = new WithExpression("variable");
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        WithExpression expression2 = new WithExpression("variable");
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        ((AbstractIntegerAssert)Assertions.assertThat((int)expression1.hashCode()).as("Equal expressions should have the same hash code", new Object[0])).isEqualTo(expression2.hashCode());
    }

    @Test
    public void testWithExpressionNoVariable() throws Exception {
        WithExpression expr = new WithExpression("variable");
        expr.add((Expression)new EqualsExpression(new Object()));
        EvaluationContext context = new EvaluationContext(null, new Object());
        org.junit.jupiter.api.Assertions.assertThrows(CoreException.class, () -> {
            EvaluationResult evaluationResult = expr.evaluate((IEvaluationContext)context);
        });
    }

    @Test
    public void testWithExpressionUndefinedVariable() throws Exception {
        WithExpression expr = new WithExpression("variable");
        expr.add((Expression)new EqualsExpression(new Object()));
        EvaluationContext context = new EvaluationContext(null, new Object());
        context.addVariable("variable", IEvaluationContext.UNDEFINED_VARIABLE);
        Assertions.assertThat((Object)expr.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.FALSE);
    }

    @Test
    public void testVariableResolver() throws Exception {
        Object result = new Object();
        IVariableResolver resolver = (name, args) -> {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"variable", (Object)name);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"arg1", (Object)args[0]);
            org.junit.jupiter.api.Assertions.assertEquals((Object)Boolean.TRUE, (Object)args[1]);
            return result;
        };
        EvaluationContext context = new EvaluationContext(null, new Object(), new IVariableResolver[]{resolver});
        Assertions.assertThat((Object)result).isEqualTo(context.resolveVariable("variable", new Object[]{"arg1", Boolean.TRUE}));
    }

    @Test
    public void testEqualsExpression() throws Exception {
        EqualsExpression exp = new EqualsExpression((Object)"name");
        EvaluationContext context = new EvaluationContext(null, (Object)"name");
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.TRUE);
        exp = new EqualsExpression((Object)Boolean.TRUE);
        context = new EvaluationContext(null, (Object)Boolean.TRUE);
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.TRUE);
        exp = new EqualsExpression((Object)"name");
        context = new EvaluationContext(null, (Object)Boolean.TRUE);
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.FALSE);
    }

    @Test
    public void testCountExpressionAnyNumber() throws Exception {
        CountExpression exp = new CountExpression("*");
        EvaluationContext context = new EvaluationContext(null, List.of());
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.TRUE);
        context = new EvaluationContext(null, List.of("one"));
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.TRUE);
        context = new EvaluationContext(null, List.of("one", "two", "three"));
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.TRUE);
    }

    @Test
    public void testCountExpressionExact() throws Exception {
        CountExpression exp = new CountExpression("2");
        EvaluationContext context = new EvaluationContext(null, List.of("one"));
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.FALSE);
        context = new EvaluationContext(null, List.of("one", "two"));
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.TRUE);
        context = new EvaluationContext(null, List.of("one", "two", "three"));
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.FALSE);
    }

    @Test
    public void testCountExpressionNoneOrOne() throws Exception {
        CountExpression exp = new CountExpression("?");
        EvaluationContext context = new EvaluationContext(null, List.of());
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.TRUE);
        context = new EvaluationContext(null, List.of("one"));
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.TRUE);
        context = new EvaluationContext(null, List.of("one", "two"));
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.FALSE);
    }

    @Test
    public void testCountExpressionOneOrMore() throws Exception {
        CountExpression exp = new CountExpression("+");
        EvaluationContext context = new EvaluationContext(null, List.of());
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.FALSE);
        context = new EvaluationContext(null, List.of("one"));
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.TRUE);
        context = new EvaluationContext(null, List.of("one", "two"));
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.TRUE);
    }

    @Test
    public void testCountExpressionNone() throws Exception {
        CountExpression exp = new CountExpression("!");
        EvaluationContext context = new EvaluationContext(null, List.of());
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.TRUE);
        context = new EvaluationContext(null, List.of("one"));
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.FALSE);
        context = new EvaluationContext(null, List.of("one", "two"));
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.FALSE);
    }

    @Test
    public void testCountExpressionNoneWithAdapterManager() throws Exception {
        CountExpression exp = new CountExpression("!");
        ArrayList<String> list = new ArrayList<String>();
        CollectionWrapper wrapper = new CollectionWrapper();
        wrapper.collection = list;
        EvaluationContext context = new EvaluationContext(null, (Object)wrapper);
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.TRUE);
        list.clear();
        list.add("one");
        context = new EvaluationContext(null, (Object)wrapper);
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.FALSE);
        list.clear();
        list.add("one");
        list.add("two");
        context = new EvaluationContext(null, (Object)wrapper);
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.FALSE);
    }

    @Test
    public void testCountExpressionFailure() throws Exception {
        CountExpression exp = new CountExpression("!");
        EvaluationContext context = new EvaluationContext(null, new Object());
        try {
            EvaluationResult result = exp.evaluate((IEvaluationContext)context);
            Assertions.fail((String)("Count should've failed for non-Collection variable.  Result = " + String.valueOf(result)));
        }
        catch (CoreException e) {
            org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)e.getStatus().getCode());
        }
    }

    @Test
    public void testInstanceofTrue() throws Exception {
        B b = new B();
        EvaluationContext context = new EvaluationContext(null, (Object)b);
        InstanceofExpression exp = new InstanceofExpression("org.eclipse.core.internal.expressions.tests.B");
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.TRUE);
        exp = new InstanceofExpression("org.eclipse.core.internal.expressions.tests.A");
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.TRUE);
        exp = new InstanceofExpression("org.eclipse.core.internal.expressions.tests.I");
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.TRUE);
    }

    @Test
    public void testInstanceofFalse() throws Exception {
        A a = new A();
        EvaluationContext context = new EvaluationContext(null, (Object)a);
        InstanceofExpression exp = new InstanceofExpression("org.eclipse.core.internal.expressions.tests.B");
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.FALSE);
    }

    @Test
    public void testIterateExpressionAndTrue() throws Exception {
        final ArrayList result = new ArrayList();
        Expression myExpression = new Expression(){

            public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
                result.add(context.getDefaultVariable());
                return EvaluationResult.TRUE;
            }
        };
        IterateExpression exp = new IterateExpression("and");
        exp.add(myExpression);
        List<String> input = List.of("one", "two");
        EvaluationContext context = new EvaluationContext(null, input);
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.TRUE);
        Assertions.assertThat(result).isEqualTo(input);
    }

    @Test
    public void testIterateExpressionAndFalse() throws Exception {
        final ArrayList result = new ArrayList();
        Expression myExpression = new Expression(){

            public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
                result.add(context.getDefaultVariable());
                return EvaluationResult.FALSE;
            }
        };
        IterateExpression exp = new IterateExpression("and");
        exp.add(myExpression);
        EvaluationContext context = new EvaluationContext(null, List.of("one", "two"));
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.FALSE);
        ((ObjectAssert)Assertions.assertThat(result).singleElement()).isEqualTo((Object)"one");
    }

    @Test
    public void testIterateExpressionOrTrue() throws Exception {
        final ArrayList result = new ArrayList();
        Expression myExpression = new Expression(){

            public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
                result.add(context.getDefaultVariable());
                return EvaluationResult.TRUE;
            }
        };
        IterateExpression exp = new IterateExpression("or");
        exp.add(myExpression);
        EvaluationContext context = new EvaluationContext(null, List.of("one", "two"));
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.TRUE);
        ((ObjectAssert)Assertions.assertThat(result).singleElement()).isEqualTo((Object)"one");
    }

    @Test
    public void testIterateExpressionOrFalse() throws Exception {
        final ArrayList result = new ArrayList();
        Expression myExpression = new Expression(){

            public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
                result.add(context.getDefaultVariable());
                return EvaluationResult.FALSE;
            }
        };
        IterateExpression exp = new IterateExpression("or");
        exp.add(myExpression);
        List<String> input = List.of("one", "two");
        EvaluationContext context = new EvaluationContext(null, input);
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.FALSE);
        Assertions.assertThat(result).isEqualTo(input);
    }

    @Test
    public void testIterateExpressionOrMultiChildren() throws Exception {
        IterateExpression exp = new IterateExpression("or");
        exp.add(Expression.FALSE);
        exp.add(Expression.TRUE);
        EvaluationContext context = new EvaluationContext(null, List.of("one"));
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.FALSE);
    }

    @Test
    public void testIterateExpressionAndMultiChildren() throws Exception {
        IterateExpression exp = new IterateExpression("and");
        exp.add(Expression.FALSE);
        exp.add(Expression.TRUE);
        EvaluationContext context = new EvaluationContext(null, List.of("one", "two"));
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.FALSE);
    }

    @Test
    public void testIterateExpressionEmptyOr() throws Exception {
        IterateExpression exp = new IterateExpression("or");
        EvaluationContext context = new EvaluationContext(null, List.of());
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.FALSE);
    }

    @Test
    public void testIterateExpressionEmptyAnd() throws Exception {
        IterateExpression exp = new IterateExpression("and");
        EvaluationContext context = new EvaluationContext(null, List.of());
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.TRUE);
    }

    @Test
    public void testIterateExpressionAnd_IfEmptyTrue() throws Exception {
        IterateExpression exp = new IterateExpression("and", "true");
        EvaluationContext context = new EvaluationContext(null, List.of());
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.TRUE);
    }

    @Test
    public void testIterateExpressionAnd_IfEmptyFalse() throws Exception {
        IterateExpression exp = new IterateExpression("and", "false");
        EvaluationContext context = new EvaluationContext(null, List.of());
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.FALSE);
    }

    @Test
    public void testIterateExpressionOr_IfEmptyTrue() throws Exception {
        IterateExpression exp = new IterateExpression("or", "true");
        EvaluationContext context = new EvaluationContext(null, List.of());
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.TRUE);
    }

    @Test
    public void testIterateExpressionOr_IfEmptyFalse() throws Exception {
        IterateExpression exp = new IterateExpression("or", "false");
        EvaluationContext context = new EvaluationContext(null, List.of());
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.FALSE);
    }

    @Test
    public void testIterateExpressionWithAdapterManager() throws Exception {
        final ArrayList result = new ArrayList();
        Expression myExpression = new Expression(){

            public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
                result.add(context.getDefaultVariable());
                return EvaluationResult.FALSE;
            }
        };
        IterateExpression exp = new IterateExpression("or");
        exp.add(myExpression);
        List<String> input = List.of("one", "two");
        CollectionWrapper wrapper = new CollectionWrapper();
        wrapper.collection = input;
        EvaluationContext context = new EvaluationContext(null, (Object)wrapper);
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.FALSE);
        Assertions.assertThat(result).isEqualTo(input);
    }

    @Test
    public void testIterateExpressionWithAdapterManagerEmptyAnd() throws Exception {
        IterateExpression exp = new IterateExpression("and");
        CollectionWrapper wrapper = new CollectionWrapper();
        wrapper.collection = List.of();
        EvaluationContext context = new EvaluationContext(null, (Object)wrapper);
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.TRUE);
    }

    @Test
    public void testIterateExpressionWithAdapterManagerEmptyOr() throws Exception {
        IterateExpression exp = new IterateExpression("or");
        CollectionWrapper wrapper = new CollectionWrapper();
        wrapper.collection = List.of();
        EvaluationContext context = new EvaluationContext(null, (Object)wrapper);
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.FALSE);
    }

    @Test
    public void testIterateExpressionWithAdapterManagerIfEmptyFalse() throws Exception {
        IterateExpression exp = new IterateExpression("or", "false");
        CollectionWrapper wrapper = new CollectionWrapper();
        wrapper.collection = List.of();
        EvaluationContext context = new EvaluationContext(null, (Object)wrapper);
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.FALSE);
    }

    @Test
    public void testIterateExpressionWithAdapterManagerIfEmptyTrue() throws Exception {
        IterateExpression exp = new IterateExpression("or", "true");
        CollectionWrapper wrapper = new CollectionWrapper();
        wrapper.collection = List.of();
        EvaluationContext context = new EvaluationContext(null, (Object)wrapper);
        Assertions.assertThat((Object)exp.evaluate((IEvaluationContext)context)).isEqualTo((Object)EvaluationResult.TRUE);
    }

    @Test
    public void testIterateExpressionFailure() throws Exception {
        IterateExpression exp = new IterateExpression(null);
        EvaluationContext context = new EvaluationContext(null, new Object());
        try {
            EvaluationResult result = exp.evaluate((IEvaluationContext)context);
            Assertions.fail((String)("Count should've failed for non-Collection variable.  Result = " + String.valueOf(result)));
        }
        catch (CoreException e) {
            org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)e.getStatus().getCode());
        }
    }

    @Test
    public void testReadXMLExpression() throws Exception {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] ces = registry.getConfigurationElementsFor("org.eclipse.core.expressions.tests", "testParticipants");
        IConfigurationElement enable = this.findExtension(ces, "test1").getChildren("enablement")[0];
        ExpressionConverter.getDefault().perform(enable);
    }

    @Test
    public void testReadDOMExpression() throws Exception {
        Document document;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] ces = registry.getConfigurationElementsFor("org.eclipse.core.expressions.tests", "testParticipants");
        URL url = FrameworkUtil.getBundle(ExpressionTests.class).getEntry("plugin.xml");
        Throwable throwable = null;
        Object var6_6 = null;
        try (InputStream in = url.openStream();){
            document = XmlProcessorFactory.parseWithErrorOnDOCTYPE((InputStream)in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        NodeList testParticipants = document.getElementsByTagName("testParticipant");
        int i = 0;
        while (i < testParticipants.getLength()) {
            Element elem = (Element)testParticipants.item(i);
            String id = elem.getAttribute("id");
            Element enable1 = (Element)elem.getElementsByTagName("enablement").item(0);
            IConfigurationElement enable2 = this.findExtension(ces, id).getChildren("enablement")[0];
            Expression exp1 = ExpressionConverter.getDefault().perform(enable1);
            Expression exp2 = ExpressionConverter.getDefault().perform(enable2);
            org.junit.jupiter.api.Assertions.assertEquals((Object)exp1, (Object)exp2);
            ++i;
        }
    }

    @Test
    public void testForcePluginActivation() throws Exception {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] ces = registry.getConfigurationElementsFor("org.eclipse.core.expressions.tests", "testParticipants");
        IConfigurationElement enable = this.findExtension(ces, "test2").getChildren("enablement")[0];
        EnablementExpression exp = (EnablementExpression)ExpressionConverter.getDefault().perform(enable);
        Object[] children = exp.getChildren();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])children).hasSize(3)).allSatisfy(child -> {
            AbstractAssert abstractAssert = Assertions.assertThat((Object)child).isInstanceOf(TestExpression.class);
        });
        Assertions.assertThat((Object)((TestExpression)children[0])).matches(TestExpression::testGetForcePluginActivation);
        Assertions.assertThat((Object)((TestExpression)children[1])).matches(Predicate.not(TestExpression::testGetForcePluginActivation));
        Assertions.assertThat((Object)((TestExpression)children[2])).matches(Predicate.not(TestExpression::testGetForcePluginActivation));
    }

    @Test
    public void testPlatformPropertyTester() throws Exception {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] ces = registry.getConfigurationElementsFor("org.eclipse.core.expressions.tests", "testParticipants");
        IConfigurationElement enable = this.findExtension(ces, "test3").getChildren("enablement")[0];
        Expression exp = ExpressionConverter.getDefault().perform(enable);
        EvaluationContext context = new EvaluationContext(null, Platform.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)EvaluationResult.TRUE, (Object)exp.evaluate((IEvaluationContext)context));
    }

    private IConfigurationElement findExtension(IConfigurationElement[] ces, String id) {
        IConfigurationElement[] iConfigurationElementArray = ces;
        int n = ces.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if (id.equals(ce.getAttribute("id"))) {
                return ce;
            }
            ++n2;
        }
        return null;
    }

    @Test
    public void testDefinitionExpression() throws Exception {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] ces = registry.getConfigurationElementsFor("org.eclipse.core.expressions", "definitions");
        IConfigurationElement expr = this.findExtension(ces, "org.eclipse.core.expressions.tests.activeProblemsView");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)expr);
        Expression probExpr = ExpressionConverter.getDefault().perform(expr.getChildren()[0]);
        EvaluationContext context = new EvaluationContext(null, (Object)Collections.EMPTY_LIST);
        Assertions.assertThatThrownBy(() -> {
            EvaluationResult evaluationResult = probExpr.evaluate((IEvaluationContext)context);
        }, (String)"Should report error with no variable", (Object[])new Object[]{CoreException.class});
        context.addVariable("activePartId", (Object)"org.eclipse.ui.views.TasksView");
        org.junit.jupiter.api.Assertions.assertEquals((Object)EvaluationResult.FALSE, (Object)probExpr.evaluate((IEvaluationContext)context));
        context.addVariable("activePartId", (Object)"org.eclipse.ui.views.ProblemsView");
        org.junit.jupiter.api.Assertions.assertEquals((Object)EvaluationResult.TRUE, (Object)probExpr.evaluate((IEvaluationContext)context));
    }

    @Test
    public void testReferenceExpression() throws Exception {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] ces = registry.getConfigurationElementsFor("org.eclipse.core.expressions.tests", "testParticipants");
        IConfigurationElement enable = this.findExtension(ces, "refTest1").getChildren("enablement")[0];
        EnablementExpression probExpr = (EnablementExpression)ExpressionConverter.getDefault().perform(enable);
        EvaluationContext context = new EvaluationContext(null, (Object)Collections.EMPTY_LIST);
        Assertions.assertThatThrownBy(() -> {
            EvaluationResult evaluationResult = probExpr.evaluate((IEvaluationContext)context);
        }, (String)"Should report error with no variable", (Object[])new Object[]{CoreException.class});
        context.addVariable("activePartId", (Object)"org.eclipse.ui.views.TasksView");
        org.junit.jupiter.api.Assertions.assertEquals((Object)EvaluationResult.FALSE, (Object)probExpr.evaluate((IEvaluationContext)context));
        context.addVariable("activePartId", (Object)"org.eclipse.ui.views.ProblemsView");
        org.junit.jupiter.api.Assertions.assertEquals((Object)EvaluationResult.TRUE, (Object)probExpr.evaluate((IEvaluationContext)context));
    }

    @Test
    public void testTwoReferences() throws Exception {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] ces = registry.getConfigurationElementsFor("org.eclipse.core.expressions.tests", "testParticipants");
        IConfigurationElement enable = this.findExtension(ces, "refTest2").getChildren("enablement")[0];
        EnablementExpression probExpr = (EnablementExpression)ExpressionConverter.getDefault().perform(enable);
        EvaluationContext context = new EvaluationContext(null, (Object)Collections.EMPTY_LIST);
        Assertions.assertThatThrownBy(() -> {
            EvaluationResult evaluationResult = probExpr.evaluate((IEvaluationContext)context);
        }, (String)"Should report error with no variable", (Object[])new Object[]{CoreException.class});
        context.addVariable("activePartId", (Object)"org.eclipse.ui.views.TasksView");
        org.junit.jupiter.api.Assertions.assertEquals((Object)EvaluationResult.FALSE, (Object)probExpr.evaluate((IEvaluationContext)context));
        context.addVariable("activePartId", (Object)"org.eclipse.ui.views.ProblemsView");
        org.junit.jupiter.api.Assertions.assertEquals((Object)EvaluationResult.FALSE, (Object)probExpr.evaluate((IEvaluationContext)context));
        EvaluationContext context2 = new EvaluationContext((IEvaluationContext)context, Collections.singletonList(probExpr));
        org.junit.jupiter.api.Assertions.assertEquals((Object)EvaluationResult.TRUE, (Object)probExpr.evaluate((IEvaluationContext)context2));
    }

    @Test
    public void testSubType() throws Exception {
        EvaluationContext context = new EvaluationContext(null, IEvaluationContext.UNDEFINED_VARIABLE);
        ArrayList<AbstractCollection> list = new ArrayList<AbstractCollection>();
        HashSet o1 = new HashSet();
        EvaluationContext c1 = new EvaluationContext(null, o1);
        list.add(o1);
        ArrayList o2 = new ArrayList();
        EvaluationContext c2 = new EvaluationContext(null, o2);
        list.add(o2);
        LinkedList o3 = new LinkedList();
        EvaluationContext c3 = new EvaluationContext(null, o3);
        list.add(o3);
        context.addVariable("selection", list);
        WithExpression with = new WithExpression("selection");
        IterateExpression iterate = new IterateExpression("and", "false");
        with.add((Expression)iterate);
        InstanceofExpression iCollection = new InstanceofExpression("java.util.Collection");
        iterate.add((Expression)iCollection);
        InstanceofExpression iSet = new InstanceofExpression("java.util.Set");
        InstanceofExpression iList = new InstanceofExpression("java.util.List");
        org.junit.jupiter.api.Assertions.assertEquals((Object)EvaluationResult.TRUE, (Object)iSet.evaluate((IEvaluationContext)c1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)EvaluationResult.FALSE, (Object)iList.evaluate((IEvaluationContext)c1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)EvaluationResult.FALSE, (Object)iSet.evaluate((IEvaluationContext)c2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)EvaluationResult.TRUE, (Object)iList.evaluate((IEvaluationContext)c2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)EvaluationResult.FALSE, (Object)iSet.evaluate((IEvaluationContext)c3));
        org.junit.jupiter.api.Assertions.assertEquals((Object)EvaluationResult.TRUE, (Object)iList.evaluate((IEvaluationContext)c3));
        org.junit.jupiter.api.Assertions.assertEquals((Object)EvaluationResult.TRUE, (Object)with.evaluate((IEvaluationContext)context));
    }

    @Test
    @Disabled(value="CI test environment too unstable for performance tests")
    public void testSubTypeTiming() throws Exception {
        HashSet o1 = new HashSet();
        System.gc();
        long cachedStart = System.currentTimeMillis();
        int i = 0;
        while (i < 100000) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)Expressions.isInstanceOf(o1, (String)"java.util.Set"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)Expressions.isInstanceOf(o1, (String)"java.util.List"));
            ++i;
        }
        long cachedDelta = System.currentTimeMillis() - cachedStart;
        System.gc();
        long instanceStart = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < 100000) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)Expressions.uncachedIsSubtype(o1.getClass(), (String)"java.util.Set"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)Expressions.uncachedIsSubtype(o1.getClass(), (String)"java.util.List"));
            ++i2;
        }
        long instanceDelta = System.currentTimeMillis() - instanceStart;
        ((AbstractLongAssert)Assertions.assertThat((long)cachedDelta).as("assert cachedDelta is less than instanceDelta" + instanceDelta, new Object[0])).isLessThan(instanceDelta);
    }

    public static class CollectionWrapper {
        public Collection<String> collection;
    }
}

