/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions.tests;

import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.expressions.Expressions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.TestMethodOrder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@TestMethodOrder(value=MethodOrderer.MethodName.class)
public class ExpressionTestsPluginUnloading {
    private String name;

    @BeforeEach
    public void setupTestName(TestInfo testInfo) {
        this.name = testInfo.getDisplayName();
    }

    @Test
    public void test01PluginStopping() throws Exception {
        Bundle bundle = ExpressionTestsPluginUnloading.getBundle("com.ibm.icu");
        bundle.start();
        int state = bundle.getState();
        ((AbstractIntegerAssert)Assertions.assertThat((int)state).withFailMessage("Unexpected bundle state: " + ExpressionTestsPluginUnloading.stateToString(state) + " for bundle " + String.valueOf(bundle), new Object[0])).isEqualTo(32);
        this.doTestInstanceofICUDecimalFormat(bundle);
        ((AbstractIntegerAssert)Assertions.assertThat((int)bundle.getState()).as("Instanceof with bundle-local class should load extra bundle", new Object[0])).isEqualTo(state);
        bundle.stop();
        ((AbstractIntegerAssert)Assertions.assertThat((int)bundle.getState()).withFailMessage("Unexpected bundle state: " + ExpressionTestsPluginUnloading.stateToString(state) + " for bundle " + String.valueOf(bundle), new Object[0])).isEqualTo(4);
        bundle.start();
        ((AbstractIntegerAssert)Assertions.assertThat((int)bundle.getState()).withFailMessage("Unexpected bundle state: " + ExpressionTestsPluginUnloading.stateToString(state) + " for bundle " + String.valueOf(bundle), new Object[0])).isEqualTo(32);
        this.doTestInstanceofICUDecimalFormat(bundle);
    }

    @Test
    public void test02MultipleClassloaders() throws Exception {
        Bundle expr = ExpressionTestsPluginUnloading.getBundle("org.eclipse.core.expressions.tests");
        Bundle icu = ExpressionTestsPluginUnloading.getBundle("com.ibm.icu");
        Class exprClass = expr.loadClass("com.ibm.icu.text.DecimalFormat");
        Class icuClass = icu.loadClass("com.ibm.icu.text.DecimalFormat");
        Assertions.assertThat((Class)exprClass).isNotSameAs((Object)icuClass);
        Object exprObj = exprClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Object icuObj = icuClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.assertInstanceOf(exprObj, "java.lang.Runnable", "java.lang.String");
        this.assertInstanceOf(exprObj, "java.lang.Object", "java.io.Serializable");
        this.assertInstanceOf(icuObj, "java.io.Serializable", "java.lang.String");
        this.assertInstanceOf(icuObj, "java.text.Format", "java.lang.Runnable");
    }

    static String stateToString(int state) {
        switch (state) {
            case 32: {
                return "ACTIVE";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 1: {
                return "UNINSTALLED";
            }
        }
        throw new IllegalStateException("Unknown state: " + state);
    }

    private void assertInstanceOf(Object obj, String isInstance, String isNotInstance) throws Exception {
        Class<?> clazz = obj.getClass();
        System.out.println("ExpressionTestsPluginUnloading#" + this.name + "() - " + clazz.getName() + ": " + clazz.hashCode());
        System.out.println("ExpressionTestsPluginUnloading#" + this.name + "() - ClassLoader: " + clazz.getClassLoader().hashCode());
        int i = 0;
        while (i < 2) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)Expressions.isInstanceOf((Object)obj, (String)isInstance));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)Expressions.isInstanceOf((Object)obj, (String)isNotInstance));
            ++i;
        }
    }

    private void doTestInstanceofICUDecimalFormat(Bundle bundle) throws Exception {
        Class clazz = bundle.loadClass("com.ibm.icu.text.DecimalFormat");
        Object decimalFormat = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.assertInstanceOf(decimalFormat, "com.ibm.icu.text.DecimalFormat", "java.text.NumberFormat");
    }

    private static Bundle getBundle(String bundleName) {
        Bundle[] bundles;
        BundleContext bundleContext = FrameworkUtil.getBundle(ExpressionTestsPluginUnloading.class).getBundleContext();
        Bundle[] bundleArray = bundles = bundleContext.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundleName.equals(bundle.getSymbolicName())) {
                return bundle;
            }
            ++n2;
        }
        org.junit.jupiter.api.Assertions.fail((String)("Could not find bundle: " + bundleName));
        return null;
    }
}

