/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions.tests;

import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.expressions.TestExpression;
import org.eclipse.core.internal.expressions.Property;
import org.eclipse.core.internal.expressions.TypeExtensionManager;
import org.eclipse.core.internal.expressions.tests.A;
import org.eclipse.core.internal.expressions.tests.B;
import org.eclipse.core.internal.expressions.tests.I;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PropertyTesterTests {
    private A a;
    private B b;
    private I i;
    private static final TypeExtensionManager fgManager = new TypeExtensionManager("propertyTesters");
    private static final boolean TEST_DYNAMIC_AND_ACTIVATION = false;

    @BeforeEach
    public void setUp() throws Exception {
        this.a = new A();
        this.b = new B();
        this.i = this.b;
    }

    @Test
    public void testSimple() throws Exception {
        Assertions.assertTrue((boolean)this.test(this.a, "simple", null, "simple"));
        Assertions.assertTrue((boolean)this.test(this.a, "simple", null, "simple"));
    }

    @Test
    public void testInherited() throws Exception {
        Assertions.assertTrue((boolean)this.test(this.b, "simple", null, "simple"));
        Assertions.assertTrue((boolean)this.test(this.i, "simple", null, "simple"));
        Assertions.assertTrue((boolean)this.test(this.b, "simple", null, "simple"));
        Assertions.assertTrue((boolean)this.test(this.i, "simple", null, "simple"));
    }

    @Test
    public void testUnknown() throws Exception {
        try {
            this.test(this.a, "unknown", null, null);
        }
        catch (CoreException e) {
            return;
        }
        Assertions.assertTrue((boolean)false);
    }

    @Test
    public void testOverridden() throws Exception {
        Assertions.assertTrue((boolean)this.test(this.a, "overridden", null, "A"));
        Assertions.assertTrue((boolean)this.test(this.b, "overridden", null, "B"));
        B b_as_a = this.b;
        Assertions.assertTrue((boolean)this.test(b_as_a, "overridden", null, "B"));
        Assertions.assertTrue((boolean)this.test(this.i, "overridden", null, "B"));
        Assertions.assertTrue((boolean)this.test(this.a, "overridden", null, "A"));
        Assertions.assertTrue((boolean)this.test(this.b, "overridden", null, "B"));
        Assertions.assertTrue((boolean)this.test(b_as_a, "overridden", null, "B"));
        Assertions.assertTrue((boolean)this.test(this.i, "overridden", null, "B"));
    }

    @Test
    public void testOrdering() throws Exception {
        Assertions.assertTrue((boolean)this.test(this.b, "ordering", null, "A"));
        I other = new I(){};
        Assertions.assertTrue((boolean)this.test(other, "ordering", null, "I"));
        Assertions.assertTrue((boolean)this.test(this.b, "ordering", null, "A"));
        Assertions.assertTrue((boolean)this.test(other, "ordering", null, "I"));
    }

    @Test
    public void testChaining() throws Exception {
        Assertions.assertTrue((boolean)this.test(this.a, "chaining", null, "A2"));
        Assertions.assertTrue((boolean)this.test(this.a, "chaining", null, "A2"));
    }

    @Test
    public void testChainOrdering() throws Exception {
        Assertions.assertTrue((boolean)this.test(this.a, "chainOrdering", null, "A"));
        Assertions.assertTrue((boolean)this.test(this.a, "chainOrdering", null, "A"));
    }

    @Test
    public void testWrongNameSpace() throws Exception {
        Assertions.assertThrows(CoreException.class, () -> {
            boolean bl = this.test(this.a, "differentNamespace", null, null);
        });
    }

    @Test
    public void testDynamicPlugin() throws Exception {
    }

    @Test
    public void testPluginActivation() throws Exception {
    }

    @Test
    public void testPlatformTester() throws Exception {
        TestExpression exp = new TestExpression("org.eclipse.core.runtime", "bundleState", new Object[]{"org.eclipse.core.expressions"}, (Object)"ACTIVE", false);
        EvaluationContext context = new EvaluationContext(null, Platform.class);
        EvaluationResult result = exp.evaluate((IEvaluationContext)context);
        Assertions.assertEquals((Object)EvaluationResult.TRUE, (Object)result);
    }

    @Test
    public void testDifferentNameSpace() throws Exception {
        Assertions.assertTrue((boolean)this.test("org.eclipse.core.internal.expressions.tests2", this.a, "differentNamespace", null, "A3"));
    }

    private boolean test(Object receiver, String property, Object[] args, Object expectedValue) throws CoreException {
        Property p = fgManager.getProperty(receiver, "org.eclipse.core.internal.expressions.tests", property);
        Assertions.assertTrue((boolean)p.isInstantiated());
        return p.test(receiver, args, expectedValue);
    }

    private boolean test(String namespace, Object receiver, String property, Object[] args, Object expectedValue) throws CoreException {
        Property p = fgManager.getProperty(receiver, namespace, property);
        Assertions.assertTrue((boolean)p.isInstantiated());
        return p.test(receiver, args, expectedValue);
    }
}

