/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.tips.core.ITipManager;
import org.eclipse.tips.core.Tip;
import org.eclipse.tips.core.TipProvider;
import org.eclipse.tips.core.internal.TipManager;

public class TestTipManager
extends TipManager {
    private final List<Integer> fReadList = new ArrayList<Integer>();
    private int fStartupBehavior = 0;

    public TipManager setStartupBehavior(int pStartupBehavior) {
        this.fStartupBehavior = pStartupBehavior;
        return this;
    }

    public int getStartupBehavior() {
        return this.fStartupBehavior;
    }

    public ITipManager register(TipProvider provider) {
        super.register(provider);
        this.load(provider);
        return this;
    }

    private void load(TipProvider provider) {
        provider.loadNewTips((IProgressMonitor)new NullProgressMonitor());
    }

    public boolean isRead(Tip tip) {
        return this.fReadList.contains(tip.hashCode());
    }

    public TipManager setAsRead(Tip tip) {
        this.fReadList.remove((Object)tip.hashCode());
        this.fReadList.add(tip.hashCode());
        return this;
    }

    public ITipManager log(IStatus status) {
        System.out.println(status.toString());
        return this;
    }

    public TipManager open(boolean startUp) {
        this.setOpen(true);
        return this;
    }

    public int getPriority(TipProvider provider) {
        return 20;
    }
}

