/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.core;

import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.tips.core.TipImage;
import org.junit.jupiter.api.Test;

public class TipImageBas64Test {
    private static final String BASE64 = "data:image/png;base64,thequickbrownfox";
    private static final String BASE64WRONG = "date:image/png;base64,thequickbrownfox";
    private static final String BASE64WRONG2 = "data:image/plip ;base64,thequickbrownfox";

    private TipImage getTipImage() {
        return new TipImage(BASE64);
    }

    @Test
    public void testAssertHeight() {
        org.junit.jupiter.api.Assertions.assertThrows(AssertionFailedException.class, () -> {
            TipImage tipImage = new TipImage(BASE64).setAspectRatio(1000, 0, false);
        });
    }

    @Test
    public void testAssertWidth() {
        org.junit.jupiter.api.Assertions.assertThrows(AssertionFailedException.class, () -> {
            TipImage tipImage = new TipImage(BASE64).setAspectRatio(0, 100, false);
        });
    }

    @Test
    public void testSetExtension() {
        Assertions.assertThat((String)this.getTipImage().getBase64Image()).contains(new CharSequence[]{"png"});
    }

    @Test
    public void testSetExtension2() {
        Assertions.assertThat((String)this.getTipImage().setExtension("bmp").getBase64Image()).contains(new CharSequence[]{"bmp"});
    }

    @Test
    public void testGetIMGAttributes() {
        String result = this.getTipImage().setAspectRatio(1.5).getIMGAttributes(740, 370).trim();
        Assertions.assertThat((String)result).isEqualToIgnoringCase((CharSequence)"width=\"555\" height=\"370\"");
    }

    @Test
    public void testGetBase64() {
        Assertions.assertThat((String)this.getTipImage().getBase64Image()).isEqualTo(BASE64);
    }

    @Test
    public void testSetAspectRatioDouble() {
        String result = this.getTipImage().setAspectRatio(1.5).getIMGAttributes(740, 370).trim();
        Assertions.assertThat((String)result).isEqualToIgnoringCase((CharSequence)"width=\"555\" height=\"370\"");
    }

    @Test
    public void testSetAspectRatioIntIntFalse() {
        String result = this.getTipImage().setAspectRatio(200, 50, false).getIMGAttributes(100, 100).trim();
        Assertions.assertThat((String)result).isEqualToIgnoringCase((CharSequence)"width=\"100\" height=\"25\"");
    }

    @Test
    public void testSetAspectRatioIntIntTrue() {
        String result = this.getTipImage().setAspectRatio(400, 300, true).getIMGAttributes(740, 370).trim();
        Assertions.assertThat((String)result).isEqualToIgnoringCase((CharSequence)"width=\"400\" height=\"300\"");
    }

    @Test
    public void testSetMaxHeight() {
        String imgAttributes = new TipImage(BASE64).setAspectRatio(2.0).setMaxHeight(300).getIMGAttributes(200, 200);
        Assertions.assertThat((String)imgAttributes.trim()).isEqualToIgnoringCase((CharSequence)"width=\"200\" height=\"100\"");
    }

    @Test
    public void testSetMaxWidth() {
        String imgAttributes = new TipImage(BASE64).setAspectRatio(1.6).setMaxWidth(200).getIMGAttributes(400, 300);
        Assertions.assertThat((String)imgAttributes.trim()).isEqualToIgnoringCase((CharSequence)"width=\"200\" height=\"125\"");
    }

    @Test
    public void testTipImage() {
        new TipImage(BASE64);
    }

    @Test
    public void testTipImage2() {
        this.getTipImage();
    }

    @Test
    public void testTipImage3() {
        org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> {
            TipImage tipImage = new TipImage(BASE64WRONG);
        });
    }

    public void testTipImage4() {
        TipImage tipImage = new TipImage(BASE64WRONG2);
        Assertions.assertThat((String)tipImage.getIMGAttributes(1, 1)).contains(new CharSequence[]{"plip"});
    }
}

