/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.core;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.tips.core.TipImage;
import org.junit.jupiter.api.Test;

public class TipImageURLTest {
    private static final String URL = "http://remainsoftware.com/img.png";

    @Test
    public void testTipImage() {
        org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> {
            TipImage tipImage = new TipImage(null);
        });
    }

    @Test
    public void testTipImage3() {
        org.junit.jupiter.api.Assertions.assertThrows(MalformedURLException.class, () -> {
            TipImage tipImage = new TipImage(new URL("0gl kjfslkfjsl dkfjsldkfjl"));
        });
    }

    @Test
    public void testTipImage2() throws IOException {
        this.getTipImage();
    }

    private TipImage getTipImage() throws IOException {
        return new TipImage(new URL(URL));
    }

    @Test
    public void testSetMaxHeight() throws IOException {
        String imgAttributes = new TipImage(new URL(URL)).setAspectRatio(2.0).setMaxHeight(300).getIMGAttributes(200, 200);
        Assertions.assertThat((String)imgAttributes.trim()).isEqualToIgnoringCase((CharSequence)"width=\"200\" height=\"100\"");
    }

    @Test
    public void testSetMaxWidth() throws IOException {
        String imgAttributes = new TipImage(new URL(URL)).setAspectRatio(1.6).setMaxWidth(200).getIMGAttributes(400, 300);
        Assertions.assertThat((String)imgAttributes.trim()).isEqualToIgnoringCase((CharSequence)"width=\"200\" height=\"125\"");
    }

    @Test
    public void testAssertWidth() {
        org.junit.jupiter.api.Assertions.assertThrows(AssertionFailedException.class, () -> {
            TipImage tipImage = new TipImage(new URL(URL)).setAspectRatio(0, 100, false);
        });
    }

    @Test
    public void testAssertHeight() {
        org.junit.jupiter.api.Assertions.assertThrows(AssertionFailedException.class, () -> {
            TipImage tipImage = new TipImage(new URL(URL)).setAspectRatio(1000, 0, false);
        });
    }

    @Test
    public void testSetAspectRatioIntIntFalse() throws IOException {
        String result = this.getTipImage().setAspectRatio(200, 50, false).getIMGAttributes(100, 100).trim();
        Assertions.assertThat((String)result).isEqualToIgnoringCase((CharSequence)"width=\"100\" height=\"25\"");
    }

    @Test
    public void testSetAspectRatioIntIntTrue() throws IOException {
        String result = this.getTipImage().setAspectRatio(400, 300, true).getIMGAttributes(740, 370).trim();
        Assertions.assertThat((String)result).isEqualToIgnoringCase((CharSequence)"width=\"400\" height=\"300\"");
    }

    @Test
    public void testSetAspectRatioDouble() throws IOException {
        String result = this.getTipImage().setAspectRatio(1.5).getIMGAttributes(740, 370).trim();
        Assertions.assertThat((String)result).isEqualToIgnoringCase((CharSequence)"width=\"555\" height=\"370\"");
    }

    @Test
    public void testGetIMGAttributes() throws IOException {
        String result = this.getTipImage().setAspectRatio(1.5).getIMGAttributes(740, 370).trim();
        Assertions.assertThat((String)result).isEqualToIgnoringCase((CharSequence)"width=\"555\" height=\"370\"");
    }

    @Test
    public void testSetExtension() throws IOException {
        Assertions.assertThat((String)this.getTipImage().getBase64Image()).contains(new CharSequence[]{"png"});
    }

    @Test
    public void testSetExtension2() throws IOException {
        Assertions.assertThat((String)this.getTipImage().setExtension("bmp").getBase64Image()).contains(new CharSequence[]{"bmp"});
    }
}

