/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tips.core.TestTip;
import org.eclipse.tips.core.TestTipManager;
import org.eclipse.tips.core.TestTipProvider;
import org.eclipse.tips.core.Tip;
import org.eclipse.tips.core.TipProvider;
import org.eclipse.tips.core.internal.LogUtil;
import org.eclipse.tips.core.internal.TipManager;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TipManagerTest {
    private TestTipManager fManager;
    private TestTipProvider fProvider1;
    private TestTipProvider fProvider2;

    @BeforeEach
    public void testTipManager() {
        this.fManager = new TestTipManager();
        this.fManager.open(false);
        this.fProvider1 = new TestTipProvider();
        this.fProvider2 = new TestTipProvider();
    }

    @Test
    public void testGetProvider() {
        this.fManager.register(this.fProvider1);
        TipProvider provider = this.fManager.getProvider(this.fProvider1.getID());
        org.junit.jupiter.api.Assertions.assertEquals((Object)((Object)this.fProvider1), (Object)provider);
    }

    @Test
    public void testRegister() {
        this.fManager.register(this.fProvider1);
        TipProvider provider = this.fManager.getProvider(this.fProvider1.getID());
        org.junit.jupiter.api.Assertions.assertEquals((Object)provider, (Object)((Object)this.fProvider1));
    }

    @Test
    public void testGetProviders() {
        this.fManager.register(this.fProvider1);
        this.fManager.register(this.fProvider2);
        this.fManager.register(this.fProvider2);
        Assertions.assertThat((List)this.fManager.getProviders()).hasSize(1);
    }

    @Test
    public void testGetStartupBeahvior() {
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.fManager.getStartupBehavior());
        org.junit.jupiter.api.Assertions.assertNotEquals((int)1, (int)this.fManager.getStartupBehavior());
        org.junit.jupiter.api.Assertions.assertNotEquals((int)2, (int)this.fManager.getStartupBehavior());
        this.fManager.setStartupBehavior(1);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.fManager.getStartupBehavior());
        org.junit.jupiter.api.Assertions.assertNotEquals((int)0, (int)this.fManager.getStartupBehavior());
        org.junit.jupiter.api.Assertions.assertNotEquals((int)2, (int)this.fManager.getStartupBehavior());
        this.fManager.setStartupBehavior(2);
        org.junit.jupiter.api.Assertions.assertNotEquals((int)1, (int)this.fManager.getStartupBehavior());
        org.junit.jupiter.api.Assertions.assertNotEquals((int)0, (int)this.fManager.getStartupBehavior());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.fManager.getStartupBehavior());
    }

    @Test
    public void testLoad() {
        final ArrayList test = new ArrayList();
        TestTipProvider testTipProvider = new TestTipProvider(){

            @Override
            public IStatus loadNewTips(IProgressMonitor monitor) {
                test.add("fff");
                return Status.OK_STATUS;
            }
        };
        this.fManager.register(testTipProvider);
        Assertions.assertThat(test).isNotEmpty();
    }

    @Test
    public void testLoad2() {
        final ArrayList test = new ArrayList();
        TestTipProvider testTipProvider = new TestTipProvider(){

            @Override
            public IStatus loadNewTips(IProgressMonitor monitor) {
                test.add("fff");
                return Status.OK_STATUS;
            }
        };
        this.fManager.register(testTipProvider);
        Assertions.assertThat(test).isNotEmpty();
    }

    @Test
    public void testOpen() {
        final ArrayList test = new ArrayList();
        TestTipManager m = new TestTipManager(){

            @Override
            public TipManager open(boolean startUp) {
                if (startUp) {
                    test.add("1");
                } else {
                    test.add("1");
                    test.add("2");
                }
                return this;
            }
        };
        m.open(true);
        Assertions.assertThat(test).hasSize(1);
        test.clear();
        m.open(false);
        Assertions.assertThat(test).hasSize(2);
    }

    @Test
    public void testDispose() {
        this.fManager.dispose();
    }

    @Test
    public void testDispose2() {
        this.fManager.register(this.fProvider1);
        this.fManager.dispose();
    }

    @Test
    public void testLogClassOfQException() {
        Exception e = new Exception("FFF");
        this.fManager.log(LogUtil.error(this.getClass(), (Throwable)e));
    }

    @Test
    public void testIsRead() {
        this.fManager.register(this.fProvider1);
        this.fProvider1.setTips(Arrays.asList(new Tip[]{new TestTip(this.fProvider1.getID(), "<b>bold</b>", "Tip 1"), new TestTip(this.fProvider1.getID(), "<b>bold2</b>", "Tip 2")}));
        this.fManager.setAsRead(this.fProvider1.getCurrentTip());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fManager.isRead(this.fProvider1.getCurrentTip()));
    }

    @Test
    public void testSetRead() {
        this.fManager.register(this.fProvider1);
        this.fProvider1.setTips(Arrays.asList(new Tip[]{new TestTip(this.fProvider1.getID(), "<b>bold</b>", "Tip 1"), new TestTip(this.fProvider1.getID(), "<b>bold2</b>", "Tip 2")}));
        this.fManager.setAsRead(this.fProvider1.getCurrentTip());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fManager.isRead(this.fProvider1.getCurrentTip()));
    }

    @Test
    public void testSetServeUnread() {
        this.fManager.register(this.fProvider1);
        this.fProvider1.setTips(Arrays.asList(new Tip[]{new TestTip(this.fProvider1.getID(), "<b>bold</b>", "Tip 1"), new TestTip(this.fProvider1.getID(), "<b>bold2</b>", "Tip 2")}));
        this.fManager.setAsRead(this.fProvider1.getCurrentTip());
        Assertions.assertThat((List)this.fProvider1.getTips()).hasSize(1);
        this.fManager.setServeReadTips(true);
        Assertions.assertThat((List)this.fProvider1.getTips()).hasSize(2);
    }

    @Test
    public void testIsServeUnread() {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.fManager.mustServeReadTips());
        this.fManager.setServeReadTips(true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fManager.mustServeReadTips());
    }
}

