/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.tips.core.ITipManager;
import org.eclipse.tips.core.TestTip;
import org.eclipse.tips.core.TestTipManager;
import org.eclipse.tips.core.TestTipProvider;
import org.eclipse.tips.core.Tip;
import org.eclipse.tips.core.internal.TipManager;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TipProviderTest {
    private TestTipManager fManager;
    private TestTipProvider fProvider;

    @BeforeEach
    public void testTipProvider() {
        this.fManager = new TestTipManager();
        this.fManager.open(false);
        this.fProvider = (TestTipProvider)new TestTipProvider().setManager((ITipManager)this.fManager);
    }

    @Test
    public void testDispose() {
        this.fProvider.dispose();
    }

    @Test
    public void testGetDescription() {
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.fProvider.getDescription());
    }

    @Test
    public void testGetID() {
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.fProvider.getID());
        org.junit.jupiter.api.Assertions.assertEquals((Object)((Object)((Object)this.fProvider)).getClass().getName(), (Object)this.fProvider.getID());
    }

    @Test
    public void testGetImage() {
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.fProvider.getImage());
    }

    @Test
    public void testGetTips() {
        Assertions.assertThat((List)this.fProvider.getTips(null)).isEmpty();
        this.createTestData();
        this.fManager.setAsRead(this.fProvider.getNextTip());
        Assertions.assertThat((List)this.fProvider.getTips(null)).hasSize(2);
        Assertions.assertThat((List)this.fProvider.getTips(null)).hasSize(2);
        Assertions.assertThat((List)this.fProvider.getTips()).hasSize(1);
        ((TipManager)this.fProvider.getManager()).setServeReadTips(true);
        Assertions.assertThat((List)this.fProvider.getTips(null)).hasSize(2);
    }

    private void createTestData() {
        this.fProvider.setTips(Arrays.asList(new Tip[]{new TestTip(this.fProvider.getID(), "<b>bold</b>", "Tip 1"), new TestTip(this.fProvider.getID(), "<b>bold2</b>", "Tip 2")}));
    }

    @Test
    public void testGetCurrentTip() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.fProvider.getNextTip(), (Object)this.fProvider.getCurrentTip());
    }

    @Test
    public void testGetCurrentTip2() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.fProvider.getPreviousTip(), (Object)this.fProvider.getCurrentTip());
    }

    @Test
    public void testGetNextTip() {
        this.createTestData();
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.fProvider.getCurrentTip(), (Object)this.fProvider.getNextTip());
        this.fManager.setAsRead(this.fProvider.getNextTip());
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)this.fProvider.getCurrentTip(), (Object)this.fProvider.getNextTip());
        Tip nextTip = this.fProvider.getNextTip();
        this.fManager.setAsRead(nextTip);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fManager.isRead(nextTip));
        Tip nextTip2 = this.fProvider.getNextTip();
        this.fManager.setAsRead(nextTip2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fManager.isRead(nextTip2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FinalTip", (Object)this.fProvider.getNextTip().getClass().getSimpleName());
        ((TipManager)this.fProvider.getManager()).setServeReadTips(true);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)"FinalTip", (Object)this.fProvider.getNextTip().getClass().getSimpleName());
    }

    @Test
    public void testGetPreviousTip() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.fProvider.getCurrentTip(), (Object)this.fProvider.getPreviousTip());
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.fProvider.getCurrentTip(), (Object)this.fProvider.getPreviousTip());
    }

    @Test
    public void testGetPreviousTip2() {
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.fProvider.getPreviousTip());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"FinalTip", (Object)this.fProvider.getNextTip().getClass().getSimpleName());
    }

    @Test
    public void testGetPreviousTip3() {
        ((TipManager)this.fProvider.getManager()).setServeReadTips(true);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.fProvider.getCurrentTip(), (Object)this.fProvider.getPreviousTip());
    }

    @Test
    public void testGetPreviousTip4() {
        this.createTestData();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.fProvider.getPreviousTip());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.fProvider.getPreviousTip());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.fProvider.getPreviousTip());
    }

    @Test
    public void testGetTipManager() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)((Object)this.fManager), (Object)this.fProvider.getManager());
    }

    @Test
    public void testIsReady() {
        TestTipProvider p = (TestTipProvider)new TestTipProvider().setManager((ITipManager)this.fManager);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)p.isReady());
        p.setTips(Collections.emptyList());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)p.isReady());
    }

    @Test
    public void testLoad() {
        TestTipProvider p = (TestTipProvider)new TestTipProvider().setManager((ITipManager)this.fManager);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)p.isReady());
        p.loadNewTips((IProgressMonitor)new NullProgressMonitor());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)p.isReady());
    }

    @Test
    public void testSetManager() {
        TestTipProvider p = new TestTipProvider();
        org.junit.jupiter.api.Assertions.assertNull((Object)p.getManager());
        p.setManager((ITipManager)this.fManager);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)p.getManager());
    }

    @Test
    public void testSetTips() {
        TestTipProvider p = new TestTipProvider(){

            @Override
            public IStatus loadNewTips(IProgressMonitor pMonitor) {
                org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.getTips(null).size());
                org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.setTips(Arrays.asList(new Tip[]{new TestTip(this.getID(), "DDD", "XXX")})).getTips(null).size());
                return Status.OK_STATUS;
            }
        };
        Assertions.assertThat((List)p.getTips(null)).isEmpty();
        this.fManager.register(p);
        Assertions.assertThat((List)p.getTips(null)).hasSize(1);
    }

    @Test
    public void testAddTips() {
        TestTipProvider p = new TestTipProvider(){

            @Override
            public IStatus loadNewTips(IProgressMonitor pMonitor) {
                org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.getTips(null).size());
                org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.setTips(Arrays.asList(new Tip[]{new TestTip(this.getID(), "DDD", "XXX")})).getTips(null).size());
                org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.addTips(Arrays.asList(new Tip[]{new TestTip(this.getID(), "DDD", "XXX")})).getTips(null).size());
                return Status.OK_STATUS;
            }
        };
        this.fManager.register(p);
    }
}

