/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.eclipse.tips.core.ITipManager;
import org.eclipse.tips.core.TestTip;
import org.eclipse.tips.core.TestTipManager;
import org.eclipse.tips.core.TestTipProvider;
import org.eclipse.tips.core.Tip;
import org.eclipse.tips.core.TipAction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TipTest {
    private static final String HTML = "<head></head>";
    private static final String SUBJECT_TIP = "Tip Subject";
    private TestTipManager fManager;
    private TestTipProvider fProvider;
    private TestTip fTip;

    @BeforeEach
    public void setup() {
        this.fManager = new TestTipManager();
        this.fProvider = (TestTipProvider)new TestTipProvider().setManager((ITipManager)this.fManager);
        this.createTestDate();
        this.fTip = new TestTip(this.fProvider.getID(), HTML, SUBJECT_TIP){

            public List<TipAction> getActions() {
                ArrayList<TipAction> actions = new ArrayList<TipAction>();
                ArrayList result = new ArrayList();
                Runnable runner = () -> {
                    boolean bl = result.add("entry");
                };
                actions.add(new TipAction("text", "tooltip", runner, null));
                return actions;
            }
        };
    }

    @Test
    public void testHashCode() {
        Assertions.assertNotEquals((int)0, (int)this.fProvider.getNextTip().hashCode());
    }

    @Test
    public void testHashCode2() {
        TestTip testTip = new TestTip(this.fProvider.getID(), HTML, SUBJECT_TIP);
        TestTip testTip2 = new TestTip(this.fProvider.getID(), HTML, SUBJECT_TIP);
        Assertions.assertEquals((int)testTip2.hashCode(), (int)testTip.hashCode());
    }

    @Test
    public void testTip() {
        new TestTip(this.fProvider.getID(), HTML, SUBJECT_TIP);
    }

    @Test
    public void testGetAction() {
        Assertions.assertTrue((this.fTip.getActions().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetCreationDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.fTip.getCreationDate());
        Assertions.assertEquals((int)11, (int)calendar.get(2));
        Assertions.assertEquals((int)1964, (int)calendar.get(1));
        Assertions.assertEquals((int)31, (int)calendar.get(5));
    }

    @Test
    public void testGetHTML() {
        Assertions.assertNotNull((Object)this.fTip.getHTML());
    }

    @Test
    @Disabled(value="Missing getImage() implementation in TestTip")
    public void testGetImage() {
        Assertions.assertNotNull((Object)this.fTip.getImage());
    }

    @Test
    public void testGetSubject() {
        Assertions.assertNotNull((Object)this.fTip.getSubject());
        Assertions.assertEquals((Object)SUBJECT_TIP, (Object)this.fTip.getSubject());
    }

    @Test
    public void testEqualsObject() {
        TestTip testTip = new TestTip(this.fProvider.getID(), HTML, SUBJECT_TIP);
        TestTip testTipx = new TestTip(this.fProvider.getID(), HTML, SUBJECT_TIP);
        Assertions.assertNotEquals((Object)((Object)testTip), (Object)((Object)this.fTip));
        Assertions.assertEquals((Object)((Object)testTip), (Object)((Object)testTipx));
        Assertions.assertNotEquals((Object)((Object)this.fTip), (Object)((Object)testTip));
        Assertions.assertEquals((Object)((Object)testTipx), (Object)((Object)testTip));
        TestTipProvider testTipProvider = new TestTipProvider(){

            @Override
            public String getID() {
                return "sss";
            }
        };
        TestTipProvider testTipProvider2 = new TestTipProvider(){

            @Override
            public String getID() {
                return null;
            }
        };
        TestTipProvider testTipProvider3 = new TestTipProvider(){

            @Override
            public String getID() {
                return "sss";
            }
        };
        Assertions.assertNotEquals((Object)((Object)testTipProvider2), (Object)((Object)testTipProvider));
        Assertions.assertNotEquals((Object)((Object)testTipProvider3), (Object)((Object)testTipProvider));
        TestTip testTip2 = new TestTip(this.fProvider.getID(), HTML, "Tip SubjectDDD");
        Assertions.assertNotEquals((Object)((Object)testTip2), (Object)((Object)testTip));
        Assertions.assertNotEquals((Object)((Object)testTip), (Object)((Object)testTip2));
        TestTip testTip3 = new TestTip(this.fProvider.getID(), HTML, "Tip SubjectDDD");
        Assertions.assertNotEquals((Object)((Object)testTip3), (Object)((Object)testTip));
        Assertions.assertNotEquals((Object)((Object)testTip), (Object)((Object)testTip3));
        TestTip testTip4 = new TestTip(this.fProvider.getID(), HTML, "Tip SubjectDDD");
        Assertions.assertNotEquals((Object)((Object)testTip4), (Object)((Object)testTip));
        Assertions.assertNotEquals((Object)((Object)testTip), (Object)((Object)testTip4));
        TestTip testTip5 = new TestTip(this.fProvider.getID(), HTML, "Tip SubjectDDDWW");
        Assertions.assertNotEquals((Object)((Object)testTip5), (Object)((Object)testTip));
        Assertions.assertNotEquals((Object)((Object)testTip), (Object)((Object)testTip5));
        TestTip testTip6 = new TestTip(this.fProvider.getID(), HTML, null);
        Assertions.assertNotEquals((Object)((Object)testTip6), (Object)((Object)testTip));
        Assertions.assertNotEquals((Object)((Object)testTip), (Object)((Object)testTip6));
    }

    @Test
    public void testIsRead() {
        Assertions.assertFalse((boolean)this.fManager.isRead(this.fTip));
        this.fManager.setAsRead(this.fTip);
        this.fManager.setAsRead(this.fTip);
        Assertions.assertTrue((boolean)this.fManager.isRead(this.fTip));
    }

    private void createTestDate() {
        this.fProvider.setTips(Arrays.asList(new Tip[]{new TestTip(this.fProvider.getID(), "<b>bold</b>", "Tip 1"), new TestTip(this.fProvider.getID(), "<b>bold2</b>", "Tip 2")}));
    }
}

