/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.json.internal;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.eclipse.tips.json.internal.Util;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UtilTest {
    @Test
    public void testGetValueOrDefaultJsonObjectStringString() {
        String jsonString = "{\"first\": \"Wim\", \"last\": \"Jongman\", \"variables\": {\"title\": \"Mr.\", \"age\": 53}}";
        JsonObject jsonObject = (JsonObject)JsonParser.parseString((String)jsonString);
        Assertions.assertEquals((Object)"Wim", (Object)Util.getValueOrDefault((JsonObject)jsonObject, (String)"first", (String)"Mark"));
        Assertions.assertEquals((Object)"Mark", (Object)Util.getValueOrDefault((JsonObject)jsonObject, (String)"fake", (String)"Mark"));
    }

    @Test
    public void testGetValueOrDefaultJsonObjectStringInt() {
        String jsonString = "{\"age\": \"53\", \"last\": \"Jongman\"}";
        JsonObject jsonObject = (JsonObject)JsonParser.parseString((String)jsonString);
        Assertions.assertEquals((int)53, (int)Util.getValueOrDefault((JsonObject)jsonObject, (String)"age", (int)100));
        Assertions.assertEquals((int)101, (int)Util.getValueOrDefault((JsonObject)jsonObject, (String)"fake", (int)101));
    }

    @Test
    public void testGetValueOrDefaultJsonObjectStringDouble() {
        String jsonString = "{\"double\": 5.21, \"last\": \"Jongman\"}";
        JsonObject jsonObject = (JsonObject)JsonParser.parseString((String)jsonString);
        Assertions.assertEquals((double)5.21, (double)Util.getValueOrDefault((JsonObject)jsonObject, (String)"double", (double)10.1), (double)0.0);
        Assertions.assertEquals((double)101.6, (double)Util.getValueOrDefault((JsonObject)jsonObject, (String)"fake", (double)101.6), (double)0.0);
    }

    @Test
    public void testReplace() {
        String input = "${title} ${first} ${last} is ${age} years old.";
        String result = "Mr. Wim Jongman is 53 years old.";
        String jsonString = "{\"first\": \"Wim\", \"last\": \"Jongman\", \"variables\": {\"title\": \"Mr.\", \"age\": 53}}";
        JsonObject jsonObject = (JsonObject)JsonParser.parseString((String)jsonString);
        String replace = Util.replace((JsonObject)jsonObject, (String)input);
        Assertions.assertEquals((Object)replace, (Object)result);
    }

    @Test
    public void testReplace2() {
        String input = "${title} ${first} ${last} ${ddd} is ${age} years old.${title}";
        String result = "Mr. Wim Jongman ${ddd} is 53 years old.Mr.";
        String jsonString = "{\"first\": \"Wim\", \"last\": \"Jongman\", \"variables\": {\"title\": \"Mr.\", \"age\": 53}}";
        JsonObject jsonObject = (JsonObject)JsonParser.parseString((String)jsonString);
        String replace = Util.replace((JsonObject)jsonObject, (String)input);
        Assertions.assertEquals((Object)replace, (Object)result);
    }

    @Test
    public void testReplace3() {
        String input = "${tit${empty}le}";
        String result = "Mr.";
        String jsonString = "{\"first\": \"Wim\", \"empty\": \"\", \"variables\": {\"title\": \"Mr.\", \"age\": 53}}";
        JsonObject jsonObject = (JsonObject)JsonParser.parseString((String)jsonString);
        String replace = Util.replace((JsonObject)jsonObject, (String)input);
        Assertions.assertEquals((Object)replace, (Object)result);
    }
}

