/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.util;

import java.io.IOException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tips.ui.internal.util.ImageUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ImageUtilTest {
    private static String fImageBase64 = "iVBORw0KGgoAAAANSUhEUgAAACIAAAAkCAYAAADsHujfAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAAJOgAACToAYJjBRwAAAEcSURBVFhH7dZBCsIwEIXh3MkbuPJubtwI0kOIKIJuddseo+eIPORBDZM0MyPaRQr/IiRtP9osEoa+j0uoQdKykPVtiLunPKdtcx/i9iHPMRECRDi+82KA4LNKGBHCG5kVM0UgjKV1SITgxdMHIC1Gg0DZPeLBaBEoC0EWjAWBihCkwVgRaBaCajAeBKqCoBLGi0DVECRhVtfPsQWBVBAkYZgVgdQQlPsy0traTJB0TzDuGUtqSA7BrBgVJEVgLP0mC6YaIiE49w1MFaSEYF7MLKQGwTyYIkSDYFZMFmJBMAtGhHgQTIsRIdObLQiWYnAWltYhEYJDrhfBiCkhUHGz/rIGSWuQtAZJC+M4xn93Ol9iiAu49oduKZAuvgC5R8NSTiN3qAAAAABJRU5ErkJggg==";
    private static String fImageBase64HTML = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACIAAAAkCAYAAADsHujfAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAAJOgAACToAYJjBRwAAAEcSURBVFhH7dZBCsIwEIXh3MkbuPJubtwI0kOIKIJuddseo+eIPORBDZM0MyPaRQr/IiRtP9osEoa+j0uoQdKykPVtiLunPKdtcx/i9iHPMRECRDi+82KA4LNKGBHCG5kVM0UgjKV1SITgxdMHIC1Gg0DZPeLBaBEoC0EWjAWBihCkwVgRaBaCajAeBKqCoBLGi0DVECRhVtfPsQWBVBAkYZgVgdQQlPsy0traTJB0TzDuGUtqSA7BrBgVJEVgLP0mC6YaIiE49w1MFaSEYF7MLKQGwTyYIkSDYFZMFmJBMAtGhHgQTIsRIdObLQiWYnAWltYhEYJDrhfBiCkhUHGz/rIGSWuQtAZJC+M4xn93Ol9iiAu49oduKZAuvgC5R8NSTiN3qAAAAABJRU5ErkJggg==";

    @Test
    public void decodeImageToBase64Test() throws IOException {
        Image image = new Image(null, ImageUtil.decodeToImage((String)fImageBase64));
        String base64Image = ImageUtil.decodeFromImage((Image)image, (int)5);
        image.dispose();
        image = new Image(null, ImageUtil.decodeToImage((String)base64Image));
        String base64Image2 = ImageUtil.decodeFromImage((Image)image, (int)5);
        Assertions.assertEquals((Object)base64Image2, (Object)base64Image);
        image.dispose();
        Image image2 = new Image(null, ImageUtil.decodeToImage((String)fImageBase64HTML));
        String base64Image3 = ImageUtil.decodeFromImage((Image)image2, (int)5);
        image2.dispose();
        image2 = new Image(null, ImageUtil.decodeToImage((String)base64Image3));
        String base64Image4 = ImageUtil.decodeFromImage((Image)image2, (int)5);
        Assertions.assertEquals((Object)base64Image4, (Object)base64Image3);
        image2.dispose();
    }

    @Test
    public void testGetWidth() {
        Assertions.assertEquals((int)100, (int)ImageUtil.getWidth((double)1.0, (int)1000, (int)100));
        Assertions.assertEquals((int)100, (int)ImageUtil.getWidth((double)1.0, (int)100, (int)1000));
        Assertions.assertEquals((int)99, (int)ImageUtil.getWidth((double)1.0, (int)100, (int)99));
        Assertions.assertEquals((int)98, (int)ImageUtil.getWidth((double)1.0, (int)100, (int)98));
        Assertions.assertEquals((int)100, (int)ImageUtil.getWidth((double)1.0, (int)100, (int)100));
        Assertions.assertEquals((int)99, (int)ImageUtil.getWidth((double)1.0, (int)99, (int)100));
        Assertions.assertEquals((int)77, (int)ImageUtil.getWidth((double)1.0, (int)77, (int)77));
        Assertions.assertEquals((int)100, (int)ImageUtil.getWidth((double)1.0, (int)101, (int)100));
        Assertions.assertEquals((int)100, (int)ImageUtil.getWidth((double)1.0, (int)149, (int)100));
        Assertions.assertEquals((int)200, (int)ImageUtil.getWidth((double)1.0, (int)200, (int)300));
        Assertions.assertEquals((int)10, (int)ImageUtil.getWidth((double)1.0, (int)11, (int)10));
        Assertions.assertEquals((int)50, (int)ImageUtil.getWidth((double)0.5, (int)1000, (int)100));
        Assertions.assertEquals((int)100, (int)ImageUtil.getWidth((double)0.5, (int)100, (int)1000));
        Assertions.assertEquals((int)49, (int)ImageUtil.getWidth((double)0.5, (int)100, (int)99));
        Assertions.assertEquals((int)49, (int)ImageUtil.getWidth((double)0.5, (int)100, (int)98));
        Assertions.assertEquals((int)50, (int)ImageUtil.getWidth((double)0.5, (int)100, (int)100));
        Assertions.assertEquals((int)50, (int)ImageUtil.getWidth((double)0.5, (int)99, (int)100));
        Assertions.assertEquals((int)38, (int)ImageUtil.getWidth((double)0.5, (int)77, (int)77));
        Assertions.assertEquals((int)50, (int)ImageUtil.getWidth((double)0.5, (int)101, (int)100));
        Assertions.assertEquals((int)50, (int)ImageUtil.getWidth((double)0.5, (int)149, (int)100));
        Assertions.assertEquals((int)150, (int)ImageUtil.getWidth((double)0.5, (int)200, (int)300));
        Assertions.assertEquals((int)5, (int)ImageUtil.getWidth((double)0.5, (int)11, (int)10));
        Assertions.assertEquals((int)200, (int)ImageUtil.getWidth((double)2.0, (int)1000, (int)100));
        Assertions.assertEquals((int)100, (int)ImageUtil.getWidth((double)2.0, (int)100, (int)1000));
        Assertions.assertEquals((int)100, (int)ImageUtil.getWidth((double)2.0, (int)100, (int)99));
        Assertions.assertEquals((int)100, (int)ImageUtil.getWidth((double)2.0, (int)100, (int)50));
        Assertions.assertEquals((int)98, (int)ImageUtil.getWidth((double)2.0, (int)100, (int)49));
        Assertions.assertEquals((int)100, (int)ImageUtil.getWidth((double)2.0, (int)100, (int)98));
        Assertions.assertEquals((int)100, (int)ImageUtil.getWidth((double)2.0, (int)100, (int)100));
        Assertions.assertEquals((int)99, (int)ImageUtil.getWidth((double)2.0, (int)99, (int)100));
        Assertions.assertEquals((int)77, (int)ImageUtil.getWidth((double)2.0, (int)77, (int)77));
        Assertions.assertEquals((int)101, (int)ImageUtil.getWidth((double)2.0, (int)101, (int)100));
        Assertions.assertEquals((int)149, (int)ImageUtil.getWidth((double)2.0, (int)149, (int)100));
        Assertions.assertEquals((int)200, (int)ImageUtil.getWidth((double)2.0, (int)200, (int)300));
        Assertions.assertEquals((int)11, (int)ImageUtil.getWidth((double)2.0, (int)11, (int)10));
    }

    @Test
    public void testGetHeight() {
        Assertions.assertEquals((int)100, (int)ImageUtil.getHeight((double)1.0, (int)1000, (int)100));
        Assertions.assertEquals((int)100, (int)ImageUtil.getHeight((double)1.0, (int)100, (int)1000));
        Assertions.assertEquals((int)99, (int)ImageUtil.getHeight((double)1.0, (int)100, (int)99));
        Assertions.assertEquals((int)98, (int)ImageUtil.getHeight((double)1.0, (int)100, (int)98));
        Assertions.assertEquals((int)100, (int)ImageUtil.getHeight((double)1.0, (int)100, (int)100));
        Assertions.assertEquals((int)99, (int)ImageUtil.getHeight((double)1.0, (int)99, (int)100));
        Assertions.assertEquals((int)77, (int)ImageUtil.getHeight((double)1.0, (int)77, (int)77));
        Assertions.assertEquals((int)100, (int)ImageUtil.getHeight((double)1.0, (int)101, (int)100));
        Assertions.assertEquals((int)100, (int)ImageUtil.getHeight((double)1.0, (int)149, (int)100));
        Assertions.assertEquals((int)200, (int)ImageUtil.getHeight((double)1.0, (int)200, (int)300));
        Assertions.assertEquals((int)10, (int)ImageUtil.getHeight((double)1.0, (int)11, (int)10));
        Assertions.assertEquals((int)100, (int)ImageUtil.getHeight((double)0.5, (int)1000, (int)100));
        Assertions.assertEquals((int)200, (int)ImageUtil.getHeight((double)0.5, (int)100, (int)1000));
        Assertions.assertEquals((int)99, (int)ImageUtil.getHeight((double)0.5, (int)100, (int)99));
        Assertions.assertEquals((int)98, (int)ImageUtil.getHeight((double)0.5, (int)100, (int)98));
        Assertions.assertEquals((int)100, (int)ImageUtil.getHeight((double)0.5, (int)100, (int)100));
        Assertions.assertEquals((int)100, (int)ImageUtil.getHeight((double)0.5, (int)99, (int)100));
        Assertions.assertEquals((int)77, (int)ImageUtil.getHeight((double)0.5, (int)77, (int)77));
        Assertions.assertEquals((int)100, (int)ImageUtil.getHeight((double)0.5, (int)101, (int)100));
        Assertions.assertEquals((int)100, (int)ImageUtil.getHeight((double)0.5, (int)149, (int)100));
        Assertions.assertEquals((int)300, (int)ImageUtil.getHeight((double)0.5, (int)200, (int)300));
        Assertions.assertEquals((int)10, (int)ImageUtil.getHeight((double)0.5, (int)11, (int)10));
        Assertions.assertEquals((int)100, (int)ImageUtil.getHeight((double)2.0, (int)1000, (int)100));
        Assertions.assertEquals((int)50, (int)ImageUtil.getHeight((double)2.0, (int)100, (int)1000));
        Assertions.assertEquals((int)50, (int)ImageUtil.getHeight((double)2.0, (int)100, (int)99));
        Assertions.assertEquals((int)50, (int)ImageUtil.getHeight((double)2.0, (int)100, (int)50));
        Assertions.assertEquals((int)49, (int)ImageUtil.getHeight((double)2.0, (int)100, (int)49));
        Assertions.assertEquals((int)50, (int)ImageUtil.getHeight((double)2.0, (int)100, (int)98));
        Assertions.assertEquals((int)50, (int)ImageUtil.getHeight((double)2.0, (int)100, (int)100));
        Assertions.assertEquals((int)49, (int)ImageUtil.getHeight((double)2.0, (int)99, (int)100));
        Assertions.assertEquals((int)38, (int)ImageUtil.getHeight((double)2.0, (int)77, (int)77));
        Assertions.assertEquals((int)50, (int)ImageUtil.getHeight((double)2.0, (int)101, (int)100));
        Assertions.assertEquals((int)74, (int)ImageUtil.getHeight((double)2.0, (int)149, (int)100));
        Assertions.assertEquals((int)100, (int)ImageUtil.getHeight((double)2.0, (int)200, (int)300));
        Assertions.assertEquals((int)5, (int)ImageUtil.getHeight((double)2.0, (int)11, (int)10));
    }
}

