/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.forms.events;

import java.util.function.Consumer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ExpansionListenerTest {
    private ExpansionEvent firedEvent;
    private ExpansionEvent catchedEvent;
    private Consumer<ExpansionEvent> expansionEventConsumer;
    private static Shell shell;
    private static Section section;

    @BeforeClass
    public static void classSetup() {
        shell = new Shell();
        section = new Section((Composite)shell, 0);
    }

    @Before
    public void setup() {
        this.firedEvent = new ExpansionEvent((Object)section, true);
        this.expansionEventConsumer = event -> {
            ExpansionEvent expansionEvent = this.catchedEvent = event;
        };
    }

    @AfterClass
    public static void classTeardown() {
        shell.dispose();
    }

    @Test
    public void callsExpansionStateChangedConsumer() {
        IExpansionListener.expansionStateChangedAdapter(this.expansionEventConsumer).expansionStateChanged(this.firedEvent);
        Assert.assertEquals((Object)this.firedEvent, (Object)this.catchedEvent);
    }

    @Test
    public void callsExpansionStateChangingConsumer() {
        IExpansionListener.expansionStateChangingAdapter(this.expansionEventConsumer).expansionStateChanging(this.firedEvent);
        Assert.assertEquals((Object)this.firedEvent, (Object)this.catchedEvent);
    }

    @Test(expected=NullPointerException.class)
    public void throwsNullPointerOnNullStateChangedAdapter() {
        IExpansionListener.expansionStateChangedAdapter(null);
    }

    @Test(expected=NullPointerException.class)
    public void throwsNullPointerOnNullStateChangingAdapter() {
        IExpansionListener.expansionStateChangingAdapter(null);
    }
}

