/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.forms.events;

import java.util.function.Consumer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class HyperLinkListenerTest {
    private static Shell shell;
    private HyperlinkEvent firedEvent;
    private HyperlinkEvent catchedEvent;
    private Consumer<HyperlinkEvent> linkEventConsumer;
    private static Link link;

    @BeforeClass
    public static void classSetup() {
        shell = new Shell();
        link = new Link((Composite)shell, 0);
    }

    @Before
    public void setup() {
        this.firedEvent = new HyperlinkEvent((Widget)link, (Object)"uri://test", "link", 0);
        this.linkEventConsumer = event -> {
            HyperlinkEvent hyperlinkEvent = this.catchedEvent = event;
        };
    }

    @AfterClass
    public static void classTeardown() {
        shell.dispose();
    }

    @Test
    public void callsActivatedConsumer() {
        IHyperlinkListener.linkActivatedAdapter(this.linkEventConsumer).linkActivated(this.firedEvent);
        Assert.assertEquals((Object)this.firedEvent, (Object)this.catchedEvent);
    }

    @Test
    public void callsExitedConsumer() {
        IHyperlinkListener.linkExitedAdapter(this.linkEventConsumer).linkExited(this.firedEvent);
        Assert.assertEquals((Object)this.firedEvent, (Object)this.catchedEvent);
    }

    @Test
    public void callsEnteredConsumer() {
        IHyperlinkListener.linkEnteredAdapter(this.linkEventConsumer).linkEntered(this.firedEvent);
        Assert.assertEquals((Object)this.firedEvent, (Object)this.catchedEvent);
    }

    @Test(expected=NullPointerException.class)
    public void throwsNullPointerOnNullActivatedAdapter() {
        IHyperlinkListener.linkActivatedAdapter(null);
    }

    @Test(expected=NullPointerException.class)
    public void throwsNullPointerOnNullExitedAdapter() {
        IHyperlinkListener.linkExitedAdapter(null);
    }

    @Test(expected=NullPointerException.class)
    public void throwsNullPointerOnNullEnteredAdapter() {
        IHyperlinkListener.linkEnteredAdapter(null);
    }
}

