/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.forms.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.ILayoutExtension;

public final class ControlFactory {
    public static TestLayout createLayout(int maxWidth, int heightAtMaxWidth) {
        int area = heightAtMaxWidth * maxWidth;
        return new TestLayout(maxWidth, area);
    }

    public static TestLayout createLayout(int minWidth, int maxWidth, int heightAtMaxWidth) {
        int area = heightAtMaxWidth * maxWidth;
        return new TestLayoutWithExtension(minWidth, maxWidth, area);
    }

    public static Composite create(Composite parent, int minWidth, int maxWidth, int heightAtMaxWidth) {
        Composite newControl = new Composite(parent, 0);
        newControl.setLayout((Layout)ControlFactory.createLayout(minWidth, maxWidth, heightAtMaxWidth));
        return newControl;
    }

    public static Composite create(Composite parent, int maxWidth, int heightAtMaxWidth) {
        Composite newControl = new Composite(parent, 0);
        newControl.setLayout((Layout)ControlFactory.createLayout(maxWidth, heightAtMaxWidth));
        return newControl;
    }

    public static class TestLayout
    extends Layout {
        final int maxWidth;
        final int desiredArea;
        public boolean wasChanged = false;
        public Rectangle bounds = new Rectangle(0, 0, 0, 0);

        public TestLayout(int maxWidth, int desiredArea) {
            this.maxWidth = maxWidth;
            this.desiredArea = desiredArea;
        }

        protected void recordChanged(boolean changed) {
            if (changed) {
                this.wasChanged = changed;
            }
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            this.recordChanged(flushCache);
            if (wHint == -1) {
                wHint = this.maxWidth;
            }
            if (hHint == -1) {
                hHint = wHint <= 0 ? this.desiredArea : this.desiredArea / wHint;
            }
            return new Point(wHint, hHint);
        }

        protected void layout(Composite composite, boolean flushCache) {
            this.recordChanged(flushCache);
            this.bounds = composite.getBounds();
        }
    }

    private static class TestLayoutWithExtension
    extends TestLayout
    implements ILayoutExtension {
        final int minWidth;

        public TestLayoutWithExtension(int minWidth, int maxWidth, int desiredArea) {
            super(maxWidth, desiredArea);
            this.minWidth = minWidth;
        }

        public int computeMinimumWidth(Composite parent, boolean changed) {
            this.recordChanged(changed);
            return this.minWidth;
        }

        public int computeMaximumWidth(Composite parent, boolean changed) {
            this.recordChanged(changed);
            return this.maxWidth;
        }
    }
}

