/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.forms.util;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.junit.Assert;
import org.junit.Test;

public class FormColorsTest {
    private static String[] KEYS_NON_NULL = new String[]{"org.eclipse.ui.forms.BORDER", "org.eclipse.ui.forms.H_BOTTOM_KEYLINE1", "org.eclipse.ui.forms.H_BOTTOM_KEYLINE2", "org.eclipse.ui.forms.H_GRADIENT_END", "org.eclipse.ui.forms.H_GRADIENT_START", "org.eclipse.ui.forms.H_H_HOVER_FULL", "org.eclipse.ui.forms.H_H_HOVER_LIGHT", "org.eclipse.ui.forms.SEPARATOR", "org.eclipse.ui.forms.TB_BG", "org.eclipse.ui.forms.TB_BORDER", "org.eclipse.ui.forms.TB_TOGGLE", "org.eclipse.ui.forms.TB_TOGGLE_HOVER"};
    private static String[] KEYS_NULL = new String[]{"org.eclipse.ui.forms.TB_FG"};
    private static String TEST_KEY_1 = "testKey1";
    private static String TEST_KEY_2 = "testKey2";

    @Test
    public void testStandalone() {
        FormColors fColors = new FormColors(Display.getCurrent());
        Color[] colors = new Color[KEYS_NON_NULL.length];
        int i = 0;
        while (i < KEYS_NON_NULL.length) {
            colors[i] = fColors.getColor(KEYS_NON_NULL[i]);
            ++i;
        }
        Color[] nullColors = new Color[KEYS_NULL.length];
        int i2 = 0;
        while (i2 < KEYS_NULL.length) {
            nullColors[i2] = fColors.getColor(KEYS_NULL[i2]);
            ++i2;
        }
        Color inactiveBg = fColors.getInactiveBackground();
        Color bg = fColors.getBackground();
        Color fg = fColors.getForeground();
        Color bc = fColors.getBorderColor();
        int i3 = 0;
        while (i3 < KEYS_NON_NULL.length) {
            Assert.assertEquals((String)("FormColors did not return the same instance for key: " + KEYS_NON_NULL[i3]), (Object)colors[i3], (Object)fColors.getColor(KEYS_NON_NULL[i3]));
            ++i3;
        }
        i3 = 0;
        while (i3 < KEYS_NULL.length) {
            Assert.assertEquals((String)("FormColors did not return the same instance for key: " + KEYS_NULL[i3]), (Object)nullColors[i3], (Object)fColors.getColor(KEYS_NULL[i3]));
            ++i3;
        }
        Assert.assertEquals((String)"FormColors did not return the same instance for getInactiveBackground()", (Object)inactiveBg, (Object)fColors.getInactiveBackground());
        Assert.assertEquals((String)"FormColors did not return the same instance for getBackground()", (Object)bg, (Object)fColors.getBackground());
        Assert.assertEquals((String)"FormColors did not return the same instance for getForeground()", (Object)fg, (Object)fColors.getForeground());
        Assert.assertEquals((String)"FormColors did not return the same instance for getBorderColor()", (Object)bc, (Object)fColors.getBorderColor());
        fColors.dispose();
    }

    @Test
    public void testMultiple() {
        FormColors fColors = new FormColors(Display.getCurrent());
        Color[] colors = new Color[KEYS_NON_NULL.length];
        int i = 0;
        while (i < KEYS_NON_NULL.length) {
            colors[i] = fColors.getColor(KEYS_NON_NULL[i]);
            ++i;
        }
        Color[] nullColors = new Color[KEYS_NULL.length];
        int i2 = 0;
        while (i2 < KEYS_NULL.length) {
            nullColors[i2] = fColors.getColor(KEYS_NULL[i2]);
            ++i2;
        }
        Color inactiveBg = fColors.getInactiveBackground();
        Color bg = fColors.getBackground();
        Color fg = fColors.getForeground();
        Color bc = fColors.getBorderColor();
        FormColors fColors2 = new FormColors(Display.getCurrent());
        Color[] colors2 = new Color[KEYS_NON_NULL.length];
        int i3 = 0;
        while (i3 < KEYS_NON_NULL.length) {
            colors2[i3] = fColors2.getColor(KEYS_NON_NULL[i3]);
            ++i3;
        }
        Color[] nullColors2 = new Color[KEYS_NULL.length];
        int i4 = 0;
        while (i4 < KEYS_NULL.length) {
            nullColors2[i4] = fColors2.getColor(KEYS_NULL[i4]);
            ++i4;
        }
        Color inactiveBg2 = fColors2.getInactiveBackground();
        Color bg2 = fColors2.getBackground();
        Color fg2 = fColors2.getForeground();
        Color bc2 = fColors2.getBorderColor();
        int i5 = 0;
        while (i5 < KEYS_NON_NULL.length) {
            Assert.assertEquals((String)("Different concurrent instances of FormColors did not return the same Color for key: " + KEYS_NON_NULL[i5]), (Object)colors[i5], (Object)colors2[i5]);
            ++i5;
        }
        i5 = 0;
        while (i5 < KEYS_NULL.length) {
            Assert.assertEquals((String)("Different concurrent instances of FormColors did not return the same Color for key: " + KEYS_NULL[i5]), (Object)nullColors[i5], (Object)nullColors2[i5]);
            ++i5;
        }
        Assert.assertEquals((String)"Different concurrent instances of FormColors did not return the same Color for getInactiveBackground()", (Object)inactiveBg, (Object)inactiveBg2);
        Assert.assertEquals((String)"Different concurrent instances of FormColors did not return the same Color for getBackground()", (Object)bg, (Object)bg2);
        Assert.assertEquals((String)"Different concurrent instances of FormColors did not return the same Color for getForeground()", (Object)fg, (Object)fg2);
        Assert.assertEquals((String)"Different concurrent instances of FormColors did not return the same Color for getBorderColor()", (Object)bc, (Object)bc2);
        fColors2.dispose();
        i5 = 0;
        while (i5 < KEYS_NON_NULL.length) {
            Assert.assertFalse((String)("FormColors disposed different instance's key: " + KEYS_NON_NULL[i5]), (boolean)colors[i5].isDisposed());
            ++i5;
        }
        i5 = 0;
        while (i5 < KEYS_NULL.length) {
            Assert.assertFalse((String)("FormColors disposed different instance's key: " + KEYS_NULL[i5]), (nullColors[i5] != null && nullColors[i5].isDisposed() ? 1 : 0) != 0);
            ++i5;
        }
        Assert.assertFalse((String)"FormColors disposed different instance's getInactiveBackground()", (boolean)inactiveBg.isDisposed());
        Assert.assertFalse((String)"FormColors disposed different instance's getBackground()", (boolean)bg.isDisposed());
        Assert.assertFalse((String)"FormColors disposed different instance's getForeground()", (boolean)fg.isDisposed());
        Assert.assertFalse((String)"FormColors disposed different instance's getBorderColor()", (boolean)bc.isDisposed());
        fColors.dispose();
    }

    @Test
    public void testShared() {
        FormColors fColors = new FormColors(Display.getCurrent());
        fColors.markShared();
        FormToolkit tk = new FormToolkit(fColors);
        FormToolkit tk2 = new FormToolkit(fColors);
        Color[] colors = new Color[KEYS_NON_NULL.length];
        int i = 0;
        while (i < KEYS_NON_NULL.length) {
            colors[i] = tk.getColors().getColor(KEYS_NON_NULL[i]);
            ++i;
        }
        Color[] nullColors = new Color[KEYS_NULL.length];
        int i2 = 0;
        while (i2 < KEYS_NULL.length) {
            nullColors[i2] = tk.getColors().getColor(KEYS_NULL[i2]);
            ++i2;
        }
        Color inactiveBg = tk.getColors().getInactiveBackground();
        Color bg = tk.getColors().getBackground();
        Color fg = tk.getColors().getForeground();
        Color bc = tk.getColors().getBorderColor();
        Color[] colors2 = new Color[KEYS_NON_NULL.length];
        int i3 = 0;
        while (i3 < KEYS_NON_NULL.length) {
            colors2[i3] = tk2.getColors().getColor(KEYS_NON_NULL[i3]);
            ++i3;
        }
        Color[] nullColors2 = new Color[KEYS_NULL.length];
        int i4 = 0;
        while (i4 < KEYS_NULL.length) {
            nullColors2[i4] = tk2.getColors().getColor(KEYS_NULL[i4]);
            ++i4;
        }
        boolean testBorderDispose = !bc.equals((Object)fColors.getColor("org.eclipse.ui.forms.BORDER"));
        tk2.dispose();
        int i5 = 0;
        while (i5 < KEYS_NON_NULL.length) {
            Assert.assertFalse((String)("FormToolkit disposed shared FormColor's key: " + KEYS_NON_NULL[i5]), (boolean)colors[i5].isDisposed());
            ++i5;
        }
        i5 = 0;
        while (i5 < KEYS_NULL.length) {
            Assert.assertFalse((String)("FormToolkit disposed shared FormColor's key: " + KEYS_NULL[i5]), (nullColors[i5] != null && nullColors[i5].isDisposed() ? 1 : 0) != 0);
            ++i5;
        }
        Assert.assertFalse((String)"FormToolkit disposed shared FormColor's getInactiveBackground()", (boolean)inactiveBg.isDisposed());
        Assert.assertFalse((String)"FormToolkit disposed shared FormColor's getBackground()", (boolean)bg.isDisposed());
        Assert.assertFalse((String)"FormToolkit disposed shared FormColor's getForeground()", (boolean)fg.isDisposed());
        Assert.assertFalse((String)"FormToolkit disposed shared FormColor's getBorderColor()", (boolean)bc.isDisposed());
        tk.dispose();
        i5 = 0;
        while (i5 < KEYS_NON_NULL.length) {
            Assert.assertFalse((String)("Last FormToolkit disposed shared FormColor's key: " + KEYS_NON_NULL[i5]), (boolean)colors[i5].isDisposed());
            ++i5;
        }
        i5 = 0;
        while (i5 < KEYS_NULL.length) {
            Assert.assertFalse((String)("Last FormToolkit disposed shared FormColor's key: " + KEYS_NULL[i5]), (nullColors[i5] != null && nullColors[i5].isDisposed() ? 1 : 0) != 0);
            ++i5;
        }
        Assert.assertFalse((String)"Last FormToolkit disposed shared FormColor's getInactiveBackground()", (boolean)inactiveBg.isDisposed());
        Assert.assertFalse((String)"Last FormToolkit disposed shared FormColor's getBackground()", (boolean)bg.isDisposed());
        Assert.assertFalse((String)"Last FormToolkit disposed shared FormColor's getForeground()", (boolean)fg.isDisposed());
        if (testBorderDispose) {
            Assert.assertFalse((String)"Last FormToolkit with shared FormColors disposed getBorderColor() when it shouldn't have", (boolean)bc.isDisposed());
        }
        fColors.dispose();
    }

    @Test
    public void testCustom() {
        FormColors fColors = new FormColors(Display.getCurrent());
        Color test1 = fColors.createColor(TEST_KEY_1, 255, 155, 55);
        Color test2 = fColors.createColor(TEST_KEY_2, 55, 155, 255);
        Assert.assertEquals((String)"FormColors returned wrong color for an existing key.", (Object)fColors.getColor(TEST_KEY_1), (Object)test1);
        Assert.assertEquals((String)"FormColors returned wrong color for an existing key.", (Object)fColors.getColor(TEST_KEY_2), (Object)test2);
        fColors.dispose();
    }
}

