/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.forms.widgets;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.tests.forms.layout.ControlFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExpandableCompositeTest {
    private static final int SHORT_CONTROL_WIDTH = 58;
    private final int defaultFlags = 2;
    private static Display display;
    private Shell shell;
    private ExpandableCompositeForTest ec;
    private Rectangle ecbounds;
    private static String shortText;
    private static String longText;
    private Font font;
    private final boolean humanWatching = false;

    static {
        shortText = "Hedgehog";
        longText = "A hedgehog is any of the spiny mammals of the subfamily Erinaceinae, in the order Erinaceomorpha.\nThere are seventeen species of hedgehog in five genera, found through parts of Europe, Asia,\nAfrica and New Zealand.";
        try {
            display = PlatformUI.getWorkbench().getDisplay();
        }
        catch (Throwable e) {
            display = new Display();
        }
    }

    private Point getTextExtend(String str) {
        GC gc = new GC((Drawable)display);
        gc.setFont(this.font);
        try {
            Point point = gc.stringExtent(str);
            return point;
        }
        finally {
            gc.dispose();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.font = new Font((Device)display, "Arial", 12, 0);
        this.shell = new Shell(display);
        this.shell.setSize(600, 400);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.shell);
        this.shell.setFont(this.font);
        this.shell.open();
    }

    @After
    public void tearDown() throws Exception {
        this.shell.dispose();
        this.font.dispose();
    }

    private static void dispatch() {
        while (display.readAndDispatch()) {
        }
    }

    private static void dispatch(int msec) {
        long cur = System.currentTimeMillis();
        while (true) {
            ExpandableCompositeTest.dispatch();
            long pass = System.currentTimeMillis() - cur;
            if (pass >= (long)msec) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private Composite rectangleComposite(Composite parent, int x, int y) {
        return ControlFactory.create(parent, x, y);
    }

    private Composite createClient() {
        Composite client = this.rectangleComposite((Composite)this.ec, 200, 100);
        client.setBackground(display.getSystemColor(13));
        this.ec.setClient((Control)client);
        return client;
    }

    private Composite createTextClient(int w, int h) {
        Composite textClient = this.rectangleComposite((Composite)this.ec, w, h);
        textClient.setBackground(display.getSystemColor(8));
        this.ec.setTextClient((Control)textClient);
        return textClient;
    }

    private Composite createSeparator(int w) {
        Composite sep = this.rectangleComposite((Composite)this.ec, w, 20);
        sep.setBackground(display.getSystemColor(2));
        this.ec.setSeparatorControl((Control)sep);
        return sep;
    }

    private Composite createDescriptionControl(int w, int h) {
        Composite sep = this.rectangleComposite((Composite)this.ec, w, 20);
        sep.setBackground(display.getSystemColor(6));
        this.ec.setDescriptionControl((Control)sep);
        return sep;
    }

    private void createExtendableComposite(String text, int flags) {
        this.ec = new ExpandableCompositeForTest((Composite)this.shell, 0, flags);
        this.ec.setFont(this.font);
        this.ec.setText(text);
        this.ec.setBackground(display.getSystemColor(15));
        this.ec.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
            }

            public void expansionStateChanged(ExpansionEvent e) {
                ExpandableCompositeTest.this.ec.getParent().layout(true);
            }
        });
    }

    private Rectangle update() {
        this.shell.layout(true, true);
        ExpandableCompositeTest.dispatch();
        this.ecbounds = this.ec.getBounds();
        return this.ecbounds;
    }

    @Test
    public void testExpCompNoClient() {
        this.createExtendableComposite(shortText, 258);
        Rectangle bounds1 = this.update();
        this.ec.setExpanded(true);
        Rectangle bounds2 = this.update();
        Assert.assertEquals((long)bounds1.width, (long)bounds2.width);
        Assert.assertEquals((Object)bounds1, (Object)bounds2);
        this.createExtendableComposite(shortText, 2);
        Rectangle bounds3 = this.update();
        Assert.assertTrue((bounds3.width < bounds2.width ? 1 : 0) != 0);
    }

    @Test
    public void testExpCompWithClient() {
        this.createExtendableComposite(shortText, 258);
        this.createClient();
        Rectangle bounds1 = this.update();
        this.ec.setExpanded(true);
        Rectangle bounds2 = this.update();
        bounds2.height -= 100 + this.ec.clientVerticalSpacing;
        Assert.assertEquals((Object)bounds1, (Object)bounds2);
        this.createExtendableComposite(shortText, 2);
        this.createClient();
        Rectangle bounds3 = this.update();
        Assert.assertTrue((bounds3.width < bounds2.width ? 1 : 0) != 0);
    }

    @Test
    public void testExpCompWithClientAndCompact() {
        this.createExtendableComposite(shortText, 2);
        Rectangle bounds1 = this.update();
        this.createExtendableComposite(shortText, 34);
        this.createClient();
        Rectangle bounds2 = this.update();
        Assert.assertEquals((long)bounds1.width, (long)bounds2.width);
        this.ec.setExpanded(true);
        Rectangle bounds3 = this.update();
        Assert.assertTrue((bounds3.width > bounds2.width ? 1 : 0) != 0);
    }

    @Test
    public void testExpCompWithAndWithoutClientCompact() {
        this.createExtendableComposite(shortText, 34);
        Rectangle bounds1 = this.update();
        this.createClient();
        Rectangle bounds2 = this.update();
        Assert.assertEquals((Object)bounds1, (Object)bounds2);
    }

    @Test
    public void testExpCompWithTextClient() {
        int fontSize = this.getTextExtend((String)ExpandableCompositeTest.shortText).y;
        int SMALL_BOX_H = 3;
        int BIG_BOX_H = fontSize * 2;
        int BIG_W = 80;
        this.createExtendableComposite(shortText, 2);
        Rectangle bounds1 = this.update();
        this.createExtendableComposite(shortText, 2);
        this.createTextClient(80, 3);
        Rectangle bounds2 = this.update();
        Assert.assertTrue((bounds2.width >= bounds1.width + 80 ? 1 : 0) != 0);
        Assert.assertEquals((long)bounds2.height, (long)bounds1.height);
        this.createExtendableComposite(shortText, 2);
        this.createTextClient(80, BIG_BOX_H);
        Rectangle bounds3 = this.update();
        Assert.assertEquals((long)bounds2.width, (long)bounds3.width);
        Assert.assertTrue((bounds3.height >= BIG_BOX_H ? 1 : 0) != 0);
        this.createExtendableComposite(shortText, 8194);
        this.createTextClient(80, BIG_BOX_H);
        Rectangle bounds3l = this.update();
        Assert.assertEquals((long)bounds2.width, (long)bounds3l.width);
        Assert.assertTrue((bounds3l.height >= BIG_BOX_H ? 1 : 0) != 0);
        this.createExtendableComposite(shortText, 4098);
        Rectangle bounds4 = this.update();
        Assert.assertTrue((bounds4.width < bounds1.width ? 1 : 0) != 0);
        Assert.assertTrue((bounds4.height < bounds1.height ? 1 : 0) != 0);
        this.createExtendableComposite(shortText, 4098);
        Rectangle boundsToggle = this.update();
        Assert.assertTrue((boundsToggle.width > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boundsToggle.height > 0 ? 1 : 0) != 0);
        this.createExtendableComposite(shortText, 4098);
        this.createTextClient(80, 3);
        Rectangle bounds5 = this.update();
        Assert.assertTrue((bounds5.width >= boundsToggle.width + 80 ? 1 : 0) != 0);
        Assert.assertEquals((long)bounds5.height, (long)boundsToggle.height);
        this.createExtendableComposite(shortText, 12290);
        this.createTextClient(80, 3);
        Rectangle bounds5l = this.update();
        Assert.assertTrue((bounds5l.width >= boundsToggle.width + 80 ? 1 : 0) != 0);
        Assert.assertEquals((long)bounds5l.height, (long)boundsToggle.height);
        this.createExtendableComposite(shortText, 4098);
        this.createTextClient(80, BIG_BOX_H);
        Rectangle bounds6 = this.update();
        Assert.assertEquals((long)BIG_BOX_H, (long)bounds6.height);
        this.ec.setExpanded(true);
        Rectangle bounds7 = this.update();
        Assert.assertEquals((Object)bounds6, (Object)bounds7);
        this.createExtendableComposite(shortText, 4096);
        this.createTextClient(80, BIG_BOX_H);
        Rectangle bounds8 = this.update();
        Assert.assertEquals((long)BIG_BOX_H, (long)bounds8.height);
        Assert.assertEquals((long)80L, (long)bounds8.width);
    }

    @Test
    public void testExpCompWithTextSeparator() {
        this.createExtendableComposite(shortText, 2);
        this.createSeparator(10);
        this.checkSeparator();
        this.ec.setExpanded(true);
        this.checkSeparator();
        this.createExtendableComposite(shortText, 2);
        this.createSeparator(10);
        this.createClient();
        this.checkSeparator();
        this.ec.setExpanded(true);
        this.checkSeparator();
        this.createExtendableComposite(shortText, 2);
        this.createSeparator(10);
        this.createDescriptionControl(50, 20);
        this.createClient();
        this.checkSeparator();
        this.ec.setExpanded(true);
        this.update();
        Rectangle bounds = this.ec.getBounds();
        Rectangle sepBounds = this.ec.getSeparatorControl().getBounds();
        Assert.assertEquals((long)sepBounds.width, (long)bounds.width);
        Rectangle cb = this.ec.getClient().getBounds();
        Rectangle db = this.ec.getDescriptionControl().getBounds();
        Assert.assertEquals((long)(bounds.height - db.height - 3 - cb.height - this.ec.clientVerticalSpacing), (long)(sepBounds.y + sepBounds.height));
    }

    private void checkSeparator() {
        this.update();
        Rectangle bounds = this.ec.getBounds();
        Rectangle sepBounds = this.ec.getSeparatorControl().getBounds();
        Assert.assertEquals((long)sepBounds.width, (long)bounds.width);
        if (this.ec.isExpanded() && this.ec.getClient() != null) {
            Rectangle cb = this.ec.getClient().getBounds();
            Assert.assertEquals((long)(bounds.height - cb.height - this.ec.clientVerticalSpacing), (long)(sepBounds.y + sepBounds.height));
        } else {
            Assert.assertEquals((long)bounds.height, (long)(sepBounds.y + sepBounds.height));
        }
    }

    private void width500() {
        GridData layoutData = new GridData();
        layoutData.widthHint = 500;
        this.ec.setLayoutData(layoutData);
    }

    @Test
    public void testLabelLong() {
        this.createExtendableComposite(longText, 0);
        this.width500();
        Rectangle bounds = this.update();
        Assert.assertEquals((long)500L, (long)bounds.width);
        this.assertTextLines(4, bounds);
    }

    @Test
    public void testLinkLong() {
        this.createExtendableComposite(longText, 8);
        this.width500();
        Rectangle bounds = this.update();
        this.assertAround("Width", 500, bounds.width, 8);
        this.assertTextLines(4, bounds);
    }

    private void assertTextLines(int lines, Rectangle bounds) {
        Point textExtend = this.getTextExtend(shortText);
        this.assertAround("Expected " + lines + " lines of text", textExtend.y * lines, bounds.height, textExtend.y * 2);
    }

    private Label createLabel(Composite comp, String text) {
        Label l = new Label(comp, 64);
        l.setText(text);
        l.setFont(this.font);
        return l;
    }

    @Test
    public void testLabelLongAndTextClientLabel() {
        this.createExtendableComposite(longText, 0);
        this.width500();
        Label client = this.createLabel((Composite)this.ec, longText);
        this.ec.setTextClient((Control)client);
        Rectangle bounds = this.update();
        Assert.assertEquals((long)500L, (long)bounds.width);
        this.assertAround("Text Client Width", 250, client.getBounds().width, 3);
        this.assertTextLines(7, bounds);
    }

    private Composite createComposite(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setBackground(comp.getDisplay().getSystemColor(11));
        return comp;
    }

    private Composite createFillComp(Composite parent) {
        Composite comp = this.createComposite(parent);
        GridLayoutFactory.fillDefaults().applyTo(comp);
        Label l = this.createLabel(comp, longText);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)l);
        return comp;
    }

    private Composite createFixedComp(Composite parent) {
        Composite comp = this.createComposite(parent);
        GridLayoutFactory.fillDefaults().applyTo(comp);
        Composite control = ControlFactory.create(comp, 58, 15);
        GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)control);
        return comp;
    }

    @Test
    public void testLabelLongAndTextClientComp() {
        this.createExtendableComposite(longText, 0);
        this.width500();
        Composite client = this.createFillComp((Composite)this.ec);
        this.ec.setTextClient((Control)client);
        Rectangle bounds = this.update();
        Assert.assertEquals((String)"Width", (long)500L, (long)bounds.width);
        this.assertAround("Text Client width", 250, client.getBounds().width, 3);
        this.assertTextLines(7, bounds);
    }

    @Test
    public void testLabelShortAndTextClientComp() {
        this.createExtendableComposite(shortText, 0);
        this.width500();
        Composite client = this.createFillComp((Composite)this.ec);
        this.ec.setTextClient((Control)client);
        Rectangle bounds = this.update();
        Assert.assertEquals((String)"Width", (long)500L, (long)bounds.width);
        int w = this.getTextExtend((String)ExpandableCompositeTest.shortText).x;
        this.assertAround("Text Client width", 500 - w, client.getBounds().width, 8);
        this.assertTextLines(4, bounds);
    }

    private void assertAround(String prefix, int len1, int len2, int delta) {
        Assert.assertTrue((String)(prefix + ": expected around " + len1 + " pixes +/- " + delta + " but was " + len2), (len1 - delta <= len2 && len2 <= len1 + delta ? 1 : 0) != 0);
    }

    @Test
    public void testLabelLongAndTextClientCompFixed() {
        this.createExtendableComposite(longText, 0);
        this.width500();
        Composite client = this.createFixedComp((Composite)this.ec);
        this.ec.setTextClient((Control)client);
        Rectangle bounds = this.update();
        Assert.assertEquals((long)58L, (long)client.getBounds().width);
        this.assertTextLines(4, bounds);
        this.assertAround("Width", 500, bounds.width, 8);
    }

    @Test
    public void testLabelLongAndTextClientCompFixedL() {
        this.createExtendableComposite(longText, 8192);
        this.width500();
        Composite client = this.createFixedComp((Composite)this.ec);
        this.ec.setTextClient((Control)client);
        Rectangle bounds = this.update();
        this.assertAround("Text Client width", 58, client.getBounds().width, 8);
        this.assertTextLines(4, bounds);
        this.assertAround("Width", 500, bounds.width, 2);
    }

    @Test
    public void testTwistieIsVerticallyCentered() {
        this.createExtendableComposite(shortText, 8194);
        this.width500();
        this.update();
        Control[] children = this.ec.getChildren();
        int textCenter = Geometry.centerPoint((Rectangle)children[1].getBounds()).y;
        int twistieCenter = Geometry.centerPoint((Rectangle)children[0].getBounds()).y;
        this.assertAround("Twisty position", textCenter, twistieCenter, 1);
    }

    private static class ExpandableCompositeForTest
    extends ExpandableComposite {
        private Control separator;
        private Control description;

        public ExpandableCompositeForTest(Composite parent, int style, int expansionStyle) {
            super(parent, style, expansionStyle);
        }

        public void setSeparatorControl(Control separator) {
            this.separator = separator;
        }

        public Control getSeparatorControl() {
            return this.separator;
        }

        public Control getDescriptionControl() {
            return this.description;
        }

        public void setDescriptionControl(Control description) {
            this.description = description;
        }
    }
}

