/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.forms.widgets;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.forms.widgets.SizeCache;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FormTest {
    private static Display display;
    private Shell shell;

    static {
        try {
            display = PlatformUI.getWorkbench().getDisplay();
        }
        catch (Throwable e) {
            display = new Display();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.shell = new Shell(display);
    }

    @After
    public void tearDown() throws Exception {
        this.shell.dispose();
    }

    @Test
    public void testFormLayoutCanIgnoreBody() {
        Form form = new Form((Composite)this.shell, 0);
        Label label = new Label(form.getBody(), 0);
        label.setText("A very long text to force a large minimum widgth");
        SizeCache headCache = new SizeCache();
        SizeCache bodyCache = new SizeCache();
        headCache.setControl((Control)form.getHead());
        bodyCache.setControl((Control)form.getBody());
        Assert.assertEquals((long)Math.max(headCache.computeMinimumWidth(), bodyCache.computeMinimumWidth()), (long)((ILayoutExtension)form.getLayout()).computeMinimumWidth((Composite)form, true));
        form.setData("__ignore_body__", (Object)Boolean.TRUE);
        Assert.assertEquals((long)Math.max(headCache.computeMinimumWidth(), 0), (long)((ILayoutExtension)form.getLayout()).computeMinimumWidth((Composite)form, true));
    }
}

