/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.forms.widgets;

import org.eclipse.ui.internal.forms.widgets.FormTextModel;
import org.junit.Assert;
import org.junit.Test;

public class FormTextModelTest {
    @Test
    public void testWhitespaceNormalized() {
        FormTextModel formTextModel = new FormTextModel();
        formTextModel.setWhitespaceNormalized(true);
        formTextModel.parseTaggedText("<form><p>   line with   \r\n   <b>  whitespace </b> Test </p></form>", false);
        Assert.assertEquals((String)"FormTextModel does not remove whitespace correctly according to the rules", (Object)("line with whitespace Test" + System.lineSeparator()), (Object)formTextModel.getAccessibleText());
    }

    @Test
    public void testWhitespaceNotNormalized() {
        FormTextModel formTextModel = new FormTextModel();
        formTextModel.setWhitespaceNormalized(false);
        formTextModel.parseTaggedText("<form><p>   line with      <b>  whitespace </b> Test </p></form>", false);
        Assert.assertEquals((String)"FormTextModel does not preserve whitespace correctly according to the rules", (Object)("   line with        whitespace  Test " + System.lineSeparator()), (Object)formTextModel.getAccessibleText());
    }

    @Test
    public void testTextWithAmpersand() {
        FormTextModel formTextModel = new FormTextModel();
        formTextModel.parseTaggedText("<form>Foo &Bar</form>", false);
        Assert.assertEquals((Object)("Foo &Bar" + System.lineSeparator()), (Object)formTextModel.getAccessibleText());
    }

    private void goParse(String lin, String lout) {
        FormTextModel formTextModel = new FormTextModel();
        formTextModel.parseTaggedText("<form>" + lin + "</form>", false);
        Assert.assertEquals((Object)(lout + System.lineSeparator()), (Object)formTextModel.getAccessibleText());
    }

    @Test
    public void testAmpersandEscapes1() {
        String lin = "the &apos;quick&apos; & brown fox";
        String lout = "the 'quick' & brown fox";
        this.goParse(lin, lout);
    }

    @Test
    public void testAmpersandEscapes2() {
        String lin = "the &amp;quick&amp; & brown fox";
        String lout = "the &quick& & brown fox";
        this.goParse(lin, lout);
    }

    @Test
    public void testAmpersandEscapes3() {
        String lin = "the &lt;quick&gt; & brown fox";
        String lout = "the <quick> & brown fox";
        this.goParse(lin, lout);
    }

    @Test
    public void testAmpersandEscapes4() {
        String lin = "&&quot;&lt;&&apos;&&apos;&gt;&&amp;&";
        String lout = "&\"<&'&'>&&&";
        this.goParse(lin, lout);
    }

    @Test
    public void testAmpersandEscapes5() {
        String lin = "the &apos;quick&quot; & brown fox";
        String lout = "the 'quick\" & brown fox";
        this.goParse(lin, lout);
    }
}

