/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.forms.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.ScrolledFormText;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TreeNode;
import org.eclipse.ui.forms.widgets.Twistie;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HintAdjustmentTest {
    private static Display display;
    private Shell shell;

    static {
        try {
            display = PlatformUI.getWorkbench().getDisplay();
        }
        catch (Throwable e) {
            display = new Display();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.shell = new Shell(display);
    }

    @After
    public void tearDown() throws Exception {
        this.shell.dispose();
    }

    void verifyComputeSize(Control control) {
        int heightAdjustment;
        int widthAdjustment;
        if (control instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)control;
            Rectangle trim = scrollable.computeTrim(0, 0, 0, 0);
            widthAdjustment = trim.width;
            heightAdjustment = trim.height;
        } else {
            heightAdjustment = widthAdjustment = control.getBorderWidth() * 2;
        }
        int TEST_VALUE = 100;
        Point computedSize = control.computeSize(100, 100);
        Assert.assertEquals((String)"control is not applying the width adjustment correctly", (long)(100 + widthAdjustment), (long)computedSize.x);
        Assert.assertEquals((String)"control is not applying the height adjustment correctly", (long)(100 + heightAdjustment), (long)computedSize.y);
    }

    @Test
    public void testScrollingHyperlink() {
        Hyperlink link = new Hyperlink((Composite)this.shell, 768);
        link.setText("This is some sample text");
        this.verifyComputeSize((Control)link);
    }

    @Test
    public void testHyperlink() {
        Hyperlink link = new Hyperlink((Composite)this.shell, 0);
        link.setText("This is some sample text");
        this.verifyComputeSize((Control)link);
    }

    @Test
    public void testScrollingExpandableComposite() {
        ExpandableComposite ec = new ExpandableComposite((Composite)this.shell, 768);
        ec.setText("Foo bar baz zipp");
        this.verifyComputeSize((Control)ec);
    }

    @Test
    public void testExpandableComposite() {
        ExpandableComposite ec = new ExpandableComposite((Composite)this.shell, 0);
        ec.setText("Foo bar baz zipp");
        this.verifyComputeSize((Control)ec);
    }

    @Test
    public void testScrollingForm() {
        Form form = new Form((Composite)this.shell, 768);
        form.setMessage("Hello world");
        this.verifyComputeSize((Control)form);
    }

    @Test
    public void testForm() {
        Form form = new Form((Composite)this.shell, 0);
        form.setMessage("Hello world");
        this.verifyComputeSize((Control)form);
    }

    @Test
    public void testScrollingFormText() {
        FormText formText = new FormText((Composite)this.shell, 768);
        formText.setText("This izza test", false, false);
        this.verifyComputeSize((Control)formText);
    }

    @Test
    public void testFormText() {
        FormText formText = new FormText((Composite)this.shell, 0);
        formText.setText("This izza test", false, false);
        this.verifyComputeSize((Control)formText);
    }

    @Test
    public void testScrollingImageHyperlink() {
        ImageHyperlink hyperlink = new ImageHyperlink((Composite)this.shell, 768);
        hyperlink.setText("Foo, bar, baz");
        this.verifyComputeSize((Control)hyperlink);
    }

    @Test
    public void testImageHyperlink() {
        ImageHyperlink hyperlink = new ImageHyperlink((Composite)this.shell, 0);
        hyperlink.setText("Foo, bar, baz");
        this.verifyComputeSize((Control)hyperlink);
    }

    @Test
    public void testScrolledForm() {
        ScrolledForm scrolledForm = new ScrolledForm((Composite)this.shell, 0);
        scrolledForm.setText("Foo, bar, baz");
        this.verifyComputeSize((Control)scrolledForm);
    }

    @Test
    public void testScrollingScrolledForm() {
        ScrolledForm scrolledForm = new ScrolledForm((Composite)this.shell, 768);
        scrolledForm.setText("Foo, bar, baz");
        this.verifyComputeSize((Control)scrolledForm);
    }

    @Test
    public void testScrolledFormText() {
        ScrolledFormText scrolledForm = new ScrolledFormText((Composite)this.shell, 0, true);
        scrolledForm.setText("Foo, bar, baz");
        this.verifyComputeSize((Control)scrolledForm);
    }

    @Test
    public void testScrollingScrolledFormText() {
        ScrolledFormText scrolledForm = new ScrolledFormText((Composite)this.shell, 768, true);
        scrolledForm.setText("Foo, bar, baz");
        this.verifyComputeSize((Control)scrolledForm);
    }

    @Test
    public void testScrolledPageBook() {
        ScrolledPageBook scrolledPageBook = new ScrolledPageBook((Composite)this.shell, 0);
        this.verifyComputeSize((Control)scrolledPageBook);
    }

    @Test
    public void testScrollingScrolledPageBook() {
        ScrolledPageBook scrolledPageBook = new ScrolledPageBook((Composite)this.shell, 768);
        this.verifyComputeSize((Control)scrolledPageBook);
    }

    @Test
    public void testSection() {
        Section section = new Section((Composite)this.shell, 0);
        section.setText("Hi ho he hum de da doo dum");
        this.verifyComputeSize((Control)section);
    }

    @Test
    public void testScrollingSection() {
        Section section = new Section((Composite)this.shell, 768);
        section.setText("Hi ho he hum de da doo dum");
        this.verifyComputeSize((Control)section);
    }

    @Test
    public void testTreeNode() {
        TreeNode treeNode = new TreeNode((Composite)this.shell, 0);
        this.verifyComputeSize((Control)treeNode);
    }

    @Test
    public void testScrollingTreeNode() {
        TreeNode treeNode = new TreeNode((Composite)this.shell, 768);
        this.verifyComputeSize((Control)treeNode);
    }

    @Test
    public void testTwistie() {
        Twistie twistie = new Twistie((Composite)this.shell, 0);
        this.verifyComputeSize((Control)twistie);
    }

    @Test
    public void testScrollingTwistie() {
        Twistie twistie = new Twistie((Composite)this.shell, 768);
        this.verifyComputeSize((Control)twistie);
    }
}

