/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.forms.widgets;

final class ScrollTestData {
    boolean useLayoutExtension;
    boolean expandHorizontal;
    boolean expandVertical;
    int minWidth;
    int maxWidth;
    int maxHeight;
    int formMinX;
    int formMinY;
    boolean hScroll;
    boolean vScroll;

    ScrollTestData() {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("new ScrollTestData()");
        builder.append(".setMax(" + this.maxWidth + ", " + this.maxHeight + ")");
        if (this.formMinX != 0 || this.formMinY != 0) {
            builder.append(".setFormMin(" + this.formMinX + ", " + this.formMinY + ")");
        }
        if (this.expandHorizontal || this.expandVertical) {
            builder.append(".expand(" + this.expandHorizontal + ", " + this.expandVertical + ")");
        }
        if (this.useLayoutExtension) {
            builder.append(".setMinWidth(" + this.minWidth + ")");
        }
        if (this.hScroll || this.vScroll) {
            builder.append(".expectScroll(" + this.hScroll + ", " + this.vScroll + ")");
        }
        return builder.toString();
    }

    public boolean expectsHScroll() {
        return this.hScroll;
    }

    public boolean expectsVScroll() {
        return this.vScroll;
    }

    public boolean useLayoutExtension() {
        return this.useLayoutExtension;
    }

    public boolean expandHorizontal() {
        return this.expandHorizontal;
    }

    public boolean expandVertical() {
        return this.expandVertical;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getFormMinX() {
        return this.formMinX;
    }

    public int getFormMinY() {
        return this.formMinY;
    }

    public ScrollTestData expectScroll(boolean h, boolean v) {
        this.hScroll = h;
        this.vScroll = v;
        return this;
    }

    public ScrollTestData expand(boolean expandHorizontal, boolean expandVertical) {
        this.expandHorizontal = expandHorizontal;
        this.expandVertical = expandVertical;
        return this;
    }

    public ScrollTestData setMinWidth(int minWidth) {
        this.useLayoutExtension = minWidth != -1;
        this.minWidth = minWidth;
        return this;
    }

    public ScrollTestData setMax(int maxWidth, int maxHeight) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        return this;
    }

    public ScrollTestData setFormMin(int formMinX, int formMinY) {
        this.formMinX = formMinX;
        this.formMinY = formMinY;
        return this;
    }
}

