/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.forms.widgets;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.SectionFactory;
import org.eclipse.ui.forms.widgets.Twistie;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SectionFactoryTest {
    protected static Shell shell;

    @Before
    public void setup() {
        shell = new Shell();
    }

    @After
    public void tearDown() {
        shell.dispose();
    }

    @Test
    public void createsSection() {
        Section section = (Section)SectionFactory.newSection((int)0).create((Widget)shell);
        Assert.assertEquals((Object)shell, (Object)section.getParent());
    }

    @Test
    public void createsSectionWithText() {
        Section section = (Section)SectionFactory.newSection((int)0).title("test").create((Widget)shell);
        Assert.assertEquals((Object)"test", (Object)section.getText());
    }

    @Test
    public void createsSectionWithDescription() {
        Section section = (Section)SectionFactory.newSection((int)128).description("test").create((Widget)shell);
        Assert.assertEquals((Object)"test", (Object)section.getDescription());
    }

    @Test
    public void createsSectionWithDescriptionControl() {
        Section section = (Section)SectionFactory.newSection((int)0).description(parent -> new Label((Composite)parent, 0)).create((Widget)shell);
        Assert.assertTrue((boolean)(section.getDescriptionControl() instanceof Label));
    }

    @Test
    public void addsSectionExpandListeners() {
        ExpansionEvent[] raisedEvents = new ExpansionEvent[1];
        Section section = (Section)SectionFactory.newSection((int)2).onExpanded(e -> {
            ExpansionEvent expansionEvent = e;
        }).create((Widget)shell);
        Control twistie = section.getChildren()[0];
        Assert.assertTrue((String)"Expected a twistie", (boolean)(twistie instanceof Twistie));
        this.click(twistie);
        Assert.assertNotNull((Object)raisedEvents[0]);
    }

    @Test
    public void addsSectionExpandingListener() {
        ExpansionEvent[] raisedEvents = new ExpansionEvent[1];
        Section section = (Section)SectionFactory.newSection((int)2).onExpanding(e -> {
            ExpansionEvent expansionEvent = e;
        }).create((Widget)shell);
        Control twistie = section.getChildren()[0];
        Assert.assertTrue((String)"Expected a twistie", (boolean)(twistie instanceof Twistie));
        this.click(twistie);
        Assert.assertNotNull((Object)raisedEvents[0]);
    }

    private void click(Control twistie) {
        Event event = new Event();
        event.keyCode = 0x1000004;
        twistie.notifyListeners(1, event);
    }
}

