/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.compatibiliy.migration;

import java.util.List;
import org.eclipse.e4.tools.internal.compatibiliy.migration.E4MigrationTool;
import org.eclipse.e4.tools.internal.compatibiliy.migration.WorkbenchUtil;
import org.eclipse.e4.tools.internal.persistence.IWorkbenchState;
import org.eclipse.e4.tools.persistence.PerspectivePersister;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.ui.IMemento;

public final class PerspectiveMigrator {
    private PerspectiveMigrator() {
    }

    public static void apply3xWorkbenchState(IMemento iMemento) {
        MApplication application = PerspectiveMigrator.convertToMApplication(iMemento);
        IWorkbenchState workbenchState = PerspectiveMigrator.convertToWorkbenchState(application);
        PerspectivePersister.restoreWorkbenchState((IWorkbenchState)workbenchState);
    }

    public static MApplication convertToMApplication(IMemento iMemento) {
        return E4MigrationTool.convert(iMemento);
    }

    public static IWorkbenchState convertToWorkbenchState(MApplication application) {
        EModelService modelService = WorkbenchUtil.getEModelService();
        MPerspective activePerspective = modelService.getActivePerspective(WorkbenchUtil.getCurrentMainWindow());
        List findElements = modelService.findElements((MUIElement)application, null, MPerspective.class, null);
        MPerspective mPerspective = null;
        String elementId = activePerspective.getElementId();
        for (MPerspective perspective : findElements) {
            if (!elementId.equals(perspective.getElementId())) continue;
            mPerspective = perspective;
        }
        if (mPerspective == null) {
            System.err.println("No perspective with id " + elementId + " was found. Using first perspective to restore");
            mPerspective = (MPerspective)findElements.get(0);
            mPerspective.setElementId(elementId);
        }
        return PerspectivePersister.convertPerspective(mPerspective);
    }

    public static boolean isLegacyWorkbench(IMemento iMemento) {
        try {
            return "workbench".equals(iMemento.getType());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

