/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.internal.compatibiliy.migration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.e4.tools.internal.compatibiliy.migration.WorkbenchUtil;
import org.eclipse.e4.ui.model.application.MAddon;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MAdvancedFactory;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.e4.compatibility.ModeledPageLayoutUtils;

public final class E4MigrationTool {
    private static final String PRIMARY_EDITOR_PART_STACK_ID = "org.eclipse.e4.primaryDataStack";
    private static final String EDITOR_AREA_ID = "org.eclipse.ui.editorss";
    private final Map<Object, Set<String>> visited = new LinkedHashMap<Object, Set<String>>();

    private E4MigrationTool() {
    }

    public static void convert(File sourceMementoFile, File targetMApplicationFile) throws FileNotFoundException, IOException, WorkbenchException {
        XMLMemento memento;
        E4MigrationTool converter = new E4MigrationTool();
        Throwable throwable = null;
        Object var5_5 = null;
        try (FileInputStream input = new FileInputStream(sourceMementoFile);){
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)input, StandardCharsets.UTF_8));
            memento = XMLMemento.createReadRoot((Reader)reader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createURI((String)"sample.e4xmi"));
        resource.getContents().add((Object)((EObject)converter.internalConvert((IMemento)memento)));
        Throwable throwable3 = null;
        Object var7_9 = null;
        try (FileOutputStream output = new FileOutputStream(targetMApplicationFile);){
            resource.save((OutputStream)output, null);
        }
        catch (Throwable throwable4) {
            if (throwable3 == null) {
                throwable3 = throwable4;
            } else if (throwable3 != throwable4) {
                throwable3.addSuppressed(throwable4);
            }
            throw throwable3;
        }
    }

    public static MApplication convert(IMemento memento) {
        E4MigrationTool converter = new E4MigrationTool();
        return converter.internalConvert(memento);
    }

    private MApplication internalConvert(IMemento memento) {
        IMemento[] windowMementos;
        String[][] addonValues;
        MApplication application = MApplicationFactory.INSTANCE.createApplication();
        List addons = application.getAddons();
        String[][] stringArrayArray = new String[13][];
        stringArrayArray[0] = new String[]{"org.eclipse.e4.core.commands.service", "platform:/plugin/org.eclipse.platform", "bundleclass://org.eclipse.e4.core.commands/org.eclipse.e4.core.commands.CommandServiceAddon"};
        stringArrayArray[1] = new String[]{"org.eclipse.e4.ui.contexts.service", "platform:/plugin/org.eclipse.platform", "bundleclass://org.eclipse.e4.ui.services/org.eclipse.e4.ui.services.ContextServiceAddon"};
        stringArrayArray[2] = new String[]{"org.eclipse.e4.ui.bindings.service", "platform:/plugin/org.eclipse.platform", "bundleclass://org.eclipse.e4.ui.bindings/org.eclipse.e4.ui.bindings.BindingServiceAddon"};
        stringArrayArray[3] = new String[]{"org.eclipse.e4.ui.workbench.commands.model", "platform:/plugin/org.eclipse.platform", "bundleclass://org.eclipse.e4.ui.workbench/org.eclipse.e4.ui.internal.workbench.addons.CommandProcessingAddon"};
        stringArrayArray[4] = new String[]{"org.eclipse.e4.ui.workbench.contexts.model", "platform:/plugin/org.eclipse.platform", "bundleclass://org.eclipse.e4.ui.workbench/org.eclipse.e4.ui.internal.workbench.addons.ContextProcessingAddon"};
        stringArrayArray[5] = new String[]{"org.eclipse.e4.ui.workbench.bindings.model", "platform:/plugin/org.eclipse.platform", "bundleclass://org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.workbench.swt.util.BindingProcessingAddon"};
        stringArrayArray[6] = new String[]{"Cleanup Addon", "platform:/plugin/org.eclipse.platform", "bundleclass://org.eclipse.e4.ui.workbench.addons.swt/org.eclipse.e4.ui.workbench.addons.cleanupaddon.CleanupAddon"};
        stringArrayArray[7] = new String[]{"DnD Addon", "platform:/plugin/org.eclipse.platform", "bundleclass://org.eclipse.e4.ui.workbench.addons.swt/org.eclipse.e4.ui.workbench.addons.dndaddon.DnDAddon"};
        stringArrayArray[8] = new String[]{"MinMax Addon", "platform:/plugin/org.eclipse.platform", "bundleclass://org.eclipse.e4.ui.workbench.addons.swt/org.eclipse.e4.ui.workbench.addons.minmax.MinMaxAddon"};
        stringArrayArray[9] = new String[]{"org.eclipse.ui.workbench.addon.0", "platform:/plugin/org.eclipse.platform", "bundleclass://org.eclipse.e4.ui.workbench/org.eclipse.e4.ui.internal.workbench.addons.HandlerProcessingAddon"};
        String[] stringArray = new String[3];
        stringArray[0] = "SplitterAddon";
        stringArray[2] = "bundleclass://org.eclipse.e4.ui.workbench.addons.swt/org.eclipse.e4.ui.workbench.addons.splitteraddon.SplitterAddon";
        stringArrayArray[10] = stringArray;
        String[] stringArray2 = new String[3];
        stringArray2[0] = "org.eclipse.ui.ide.addon.0";
        stringArray2[2] = "bundleclass://org.eclipse.ui.ide/org.eclipse.ui.internal.ide.addons.SaveAllDirtyPartsAddon";
        stringArrayArray[11] = stringArray2;
        stringArrayArray[12] = new String[]{"org.eclipse.ui.ide.application.addon.0", "platform:/plugin/org.eclipse.ui.ide.application", "bundleclass://org.eclipse.ui.ide.application/org.eclipse.ui.internal.ide.application.addons.ModelCleanupAddon"};
        String[][] stringArrayArray2 = addonValues = stringArrayArray;
        int n = addonValues.length;
        int n2 = 0;
        while (n2 < n) {
            String[] addonValue = stringArrayArray2[n2];
            MAddon addon = MApplicationFactory.INSTANCE.createAddon();
            addon.setElementId(addonValue[0]);
            addon.setContributorURI(addonValue[1]);
            addon.setContributionURI(addonValue[2]);
            addons.add(addon);
            ++n2;
        }
        IMemento mruMemento = memento.getChild("mruList");
        if (mruMemento != null) {
            IMemento[] iMementoArray = mruMemento.getChildren("file");
            n2 = iMementoArray.length;
            int addonValue = 0;
            while (addonValue < n2) {
                IMemento fileMemento = iMementoArray[addonValue];
                fileMemento.toString();
                ++addonValue;
            }
        }
        if ((windowMementos = memento.getChildren("window")) == null || windowMementos.length == 0) {
            this.visitWindow(application, memento);
        } else {
            stringArrayArray2 = windowMementos;
            n = windowMementos.length;
            n2 = 0;
            while (n2 < n) {
                String[] windowMemento = stringArrayArray2[n2];
                this.visitWindow(application, (IMemento)windowMemento);
                ++n2;
            }
        }
        return application;
    }

    private void visitWindow(MApplication application, IMemento memento) {
        MTrimmedWindow window = MBasicFactory.INSTANCE.createTrimmedWindow();
        window.setContributorURI("platform:/plugin/org.eclipse.platform");
        application.getChildren().add(window);
        Rectangle shellBounds = new Rectangle(this.getInteger(memento, "x"), this.getInteger(memento, "y"), this.getInteger(memento, "width"), this.getInteger(memento, "height"));
        if (!shellBounds.isEmpty()) {
            window.setX(shellBounds.x);
            window.setY(shellBounds.y);
            window.setWidth(shellBounds.width);
            window.setHeight(shellBounds.height);
        }
        this.getBoolean(memento, "maximized");
        this.getBoolean(memento, "minimized");
        IMemento perspectiveBarMemento = memento.getChild("perspectiveBar");
        this.visitPerspectiveBar(perspectiveBarMemento);
        IMemento[] iMementoArray = memento.getChildren("page");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento pageMemento = iMementoArray[n2];
            this.visitPage((MWindow)window, pageMemento);
            ++n2;
        }
    }

    private void visitPage(MWindow window, IMemento memento) {
        String focus = this.getString(memento, "focus");
        if (focus != null && !focus.isEmpty()) {
            IMemento perspectivesMemento;
            IMemento viewsMemento;
            String pageName = this.getString(memento, "label");
            String workingSetName = this.getString(memento, "workingSet");
            IMemento workingSetsMemento = memento.getChild("workingSets");
            if (workingSetsMemento != null) {
                IMemento[] iMementoArray = workingSetsMemento.getChildren("workingSet");
                int n = iMementoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento workingSetMemento = iMementoArray[n2];
                    String string = this.getID(workingSetMemento);
                    ++n2;
                }
            }
            String aggregateWorkingSetId = this.getString(memento, "aggregateWorkingSetId");
            IMemento editorsMemento = memento.getChild("editors");
            if (editorsMemento != null) {
                this.visitEditors(window, editorsMemento);
            }
            if ((viewsMemento = memento.getChild("views")) != null) {
                this.visitViews(window, viewsMemento);
            }
            if ((perspectivesMemento = memento.getChild("perspectives")) != null) {
                this.visitPerspectives(window, perspectivesMemento);
            }
        }
    }

    private void visitPerspectives(MWindow window, IMemento memento) {
        String activePartID = this.getString(memento, "activePart");
        String activePerspectiveID = this.getString(memento, "activePerspective");
        MPartSashContainer partSashContainer = MBasicFactory.INSTANCE.createPartSashContainer();
        partSashContainer.setHorizontal(true);
        window.getChildren().add(partSashContainer);
        MPerspectiveStack perspectiveStack = MAdvancedFactory.INSTANCE.createPerspectiveStack();
        partSashContainer.getChildren().add(perspectiveStack);
        List perspectiveStackChildren = perspectiveStack.getChildren();
        IMemento[] iMementoArray = memento.getChildren("perspective");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string;
            IMemento perspectiveMemento;
            block43: {
                EObject eObject;
                IMemento mainWindowMemento;
                IMemento layoutMemento;
                IMemento boundsMemento;
                IMemento descriptorMemento;
                perspectiveMemento = iMementoArray[n2];
                MPerspective perspective = MAdvancedFactory.INSTANCE.createPerspective();
                perspectiveStackChildren.add(0, perspective);
                int areaVisible = this.getInteger(perspectiveMemento, "editorAreaVisible");
                int trimAreaState = this.getInteger(perspectiveMemento, "editorAreaTrimState");
                LinkedHashSet<String> visibleViews = new LinkedHashSet<String>();
                IMemento[] iMementoArray2 = perspectiveMemento.getChildren("view");
                int n3 = iMementoArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemento viewMemento = iMementoArray2[n4];
                    String id = this.getID(viewMemento);
                    visibleViews.add(id);
                    ++n4;
                }
                Set<String> minimizedViews = this.getMinimizedViews(perspectiveMemento);
                IMemento fastViewsMemento = perspectiveMemento.getChild("fastViews");
                if (fastViewsMemento != null) {
                    IMemento[] iMementoArray3 = fastViewsMemento.getChildren("view");
                    int id = iMementoArray3.length;
                    int n5 = 0;
                    while (n5 < id) {
                        IMemento viewMemento = iMementoArray3[n5];
                        String string2 = this.getID(viewMemento);
                        ++n5;
                    }
                }
                if ((descriptorMemento = perspectiveMemento.getChild("descriptor")) != null) {
                    String id = this.getString(descriptorMemento, "id");
                    String label = this.getString(descriptorMemento, "label");
                    perspective.setElementId(id);
                    perspective.setLabel(label);
                    if (id.equals(activePerspectiveID)) {
                        perspectiveStack.setSelectedElement((MUIElement)perspective);
                    }
                }
                if ((boundsMemento = perspectiveMemento.getChild("window")) != null) {
                    Rectangle bounds = new Rectangle(this.getInteger(boundsMemento, "x"), this.getInteger(boundsMemento, "y"), this.getInteger(boundsMemento, "width"), this.getInteger(boundsMemento, "height"));
                    bounds.isEmpty();
                }
                if ((layoutMemento = perspectiveMemento.getChild("layout")) == null || (mainWindowMemento = layoutMemento.getChild("mainWindow")) == null) break block43;
                MPartSashContainer perspectivePartSashContainer = MBasicFactory.INSTANCE.createPartSashContainer();
                perspectivePartSashContainer.setHorizontal(true);
                perspective.getChildren().add(perspectivePartSashContainer);
                LinkedHashMap<String, Info> infos = new LinkedHashMap<String, Info>();
                IMemento[] iMementoArray4 = mainWindowMemento.getChildren("info");
                int n6 = iMementoArray4.length;
                int n7 = 0;
                while (n7 < n6) {
                    block46: {
                        Info info;
                        block45: {
                            block44: {
                                String folder;
                                IMemento infoMemento = iMementoArray4[n7];
                                info = new Info();
                                info.partID = this.getString(infoMemento, "part");
                                info.relativeID = this.getString(infoMemento, "relative");
                                if (info.relativeID != null) {
                                    info.relationship = this.getInteger(infoMemento, "relationship");
                                    info.ratio = this.getFloat(infoMemento, "ratio", 0.5f);
                                    info.left = this.getInteger(infoMemento, "ratioLeft");
                                    info.right = this.getInteger(infoMemento, "ratioRight");
                                }
                                if ((folder = this.getString(infoMemento, "folder")) == null) break block44;
                                IMemento folderMemento = infoMemento.getChild("folder");
                                if (folderMemento != null) {
                                    MPartStack partStack = MBasicFactory.INSTANCE.createPartStack();
                                    partStack.setElementId(info.partID);
                                    perspectivePartSashContainer.getChildren().add(partStack);
                                    info.part = partStack;
                                    String activePageID = this.getString(folderMemento, "activePageID");
                                    List partStackChildren = partStack.getChildren();
                                    IMemento[] iMementoArray5 = folderMemento.getChildren("page");
                                    int n8 = iMementoArray5.length;
                                    int n9 = 0;
                                    while (n9 < n8) {
                                        IMemento pageMemento = iMementoArray5[n9];
                                        String pagePartID = this.getString(pageMemento, "content");
                                        if (pagePartID != null) {
                                            MPlaceholder placeHolder = MAdvancedFactory.INSTANCE.createPlaceholder();
                                            partStackChildren.add(placeHolder);
                                            placeHolder.setElementId(pagePartID);
                                            boolean visibleOrMinimized = visibleViews.contains(pagePartID) || minimizedViews.contains(pagePartID);
                                            placeHolder.setToBeRendered(visibleOrMinimized);
                                            for (MUIElement element : window.getSharedElements()) {
                                                if (!pagePartID.equals(element.getElementId())) continue;
                                                placeHolder.setRef(element);
                                                break;
                                            }
                                            if (placeHolder.getRef() == null) {
                                                MPart part = MBasicFactory.INSTANCE.createPart();
                                                part.setElementId(pagePartID);
                                                part.setLabel("fake" + pagePartID);
                                                part.setContributionURI("bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityView");
                                                window.getSharedElements().add(part);
                                                placeHolder.setRef((MUIElement)part);
                                            }
                                            if (pagePartID.equals(activePageID)) {
                                                partStack.setSelectedElement((MUIElement)placeHolder);
                                                if (placeHolder.getRef() == null) {
                                                    System.err.print("");
                                                }
                                            }
                                        }
                                        ++n9;
                                    }
                                    int state = this.getInteger(folderMemento, "expanded");
                                    IMemento[] iMementoArray6 = folderMemento.getChildren("presentation");
                                    int n10 = iMementoArray6.length;
                                    n8 = 0;
                                    while (n8 < n10) {
                                        IMemento presentationMemento = iMementoArray6[n8];
                                        String string3 = this.getString(presentationMemento, "id");
                                        ++n8;
                                    }
                                    LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
                                    IMemento propertiesMemento = folderMemento.getChild("properties");
                                    if (propertiesMemento != null) {
                                        IMemento[] iMementoArray7 = propertiesMemento.getChildren("property");
                                        int n11 = iMementoArray7.length;
                                        int n12 = 0;
                                        while (n12 < n11) {
                                            IMemento propertyMemento = iMementoArray7[n12];
                                            properties.put(this.getID(propertiesMemento), propertyMemento.getTextData());
                                            ++n12;
                                        }
                                    }
                                }
                                break block45;
                            }
                            if (!EDITOR_AREA_ID.equals(info.partID)) break block46;
                            MPlaceholder areaPlaceholder = MAdvancedFactory.INSTANCE.createPlaceholder();
                            perspectivePartSashContainer.getChildren().add(areaPlaceholder);
                            areaPlaceholder.setElementId(EDITOR_AREA_ID);
                            info.part = areaPlaceholder;
                            window.getSharedElements().stream().filter(e -> EDITOR_AREA_ID.equals(e.getElementId())).findFirst().ifPresent(e -> areaPlaceholder.setRef(e));
                        }
                        infos.put(info.partID, info);
                    }
                    ++n7;
                }
                ModeledPageLayoutUtils modeledPageLayoutUtils = new ModeledPageLayoutUtils(WorkbenchUtil.getEModelService());
                System.out.println("Perspective: " + perspective.getLabel());
                for (Info info : infos.values()) {
                    System.out.println("  " + String.valueOf(info));
                    Info relativePart = (Info)infos.get(info.relativeID);
                    if (relativePart == null) continue;
                    modeledPageLayoutUtils.insert((MUIElement)info.part, (MUIElement)relativePart.part, modeledPageLayoutUtils.plRelToSwt(info.relationship), info.ratio);
                }
                TreeIterator i = ((EObject)perspectivePartSashContainer).eAllContents();
                while (i.hasNext()) {
                    eObject = (EObject)i.next();
                    if (!(eObject instanceof MPartStack)) continue;
                    MPartStack partStack = (MPartStack)eObject;
                    boolean toBeRendered = false;
                    boolean minimized = false;
                    for (MStackElement stackElement : partStack.getChildren()) {
                        if (stackElement.isToBeRendered()) {
                            toBeRendered = true;
                        }
                        if (!minimizedViews.contains(stackElement.getElementId())) continue;
                        minimized = true;
                        toBeRendered = true;
                        break;
                    }
                    if (minimized) {
                        for (MStackElement stackElement : partStack.getChildren()) {
                            if (!stackElement.isToBeRendered()) continue;
                            partStack.setSelectedElement((MUIElement)stackElement);
                            break;
                        }
                        partStack.setToBeRendered(true);
                        partStack.setVisible(false);
                        partStack.getTags().add("Minimized");
                        continue;
                    }
                    partStack.setToBeRendered(toBeRendered);
                    partStack.setVisible(toBeRendered);
                }
                i = ((EObject)perspectivePartSashContainer).eAllContents();
                while (i.hasNext()) {
                    eObject = (EObject)i.next();
                    if (!(eObject instanceof MPartSashContainer)) continue;
                    MPartSashContainer otherPartSashContainer = (MPartSashContainer)eObject;
                    boolean toBeRendered = false;
                    boolean visible = false;
                    for (MPartSashContainerElement sashContainerElement : otherPartSashContainer.getChildren()) {
                        if (sashContainerElement.isVisible()) {
                            visible = true;
                        }
                        if (sashContainerElement.isToBeRendered()) {
                            toBeRendered = true;
                        }
                        if (visible && toBeRendered) break;
                    }
                    otherPartSashContainer.setToBeRendered(toBeRendered);
                    otherPartSashContainer.setVisible(visible && toBeRendered);
                }
                IMemento[] iMementoArray8 = mainWindowMemento.getChildren("detachedWindow");
                int n13 = iMementoArray8.length;
                n6 = 0;
                while (n6 < n13) {
                    string = iMementoArray8[n6];
                    ++n6;
                }
                iMementoArray8 = mainWindowMemento.getChildren("hiddenWindow");
                n13 = iMementoArray8.length;
                n6 = 0;
                while (n6 < n13) {
                    string = iMementoArray8[n6];
                    ++n6;
                }
                string = this.getString(mainWindowMemento, "maximized");
            }
            IMemento[] iMementoArray9 = perspectiveMemento.getChildren("view");
            int n14 = iMementoArray9.length;
            int n15 = 0;
            while (n15 < n14) {
                IMemento viewMemento = iMementoArray9[n15];
                string = this.getString(viewMemento, "id");
                ++n15;
            }
            iMementoArray9 = perspectiveMemento.getChildren("alwaysOnActionSet");
            n14 = iMementoArray9.length;
            n15 = 0;
            while (n15 < n14) {
                IMemento alwaysOnActionMemento = iMementoArray9[n15];
                string = this.getString(alwaysOnActionMemento, "id");
                ++n15;
            }
            iMementoArray9 = perspectiveMemento.getChildren("show_view_action");
            n14 = iMementoArray9.length;
            n15 = 0;
            while (n15 < n14) {
                IMemento toggleViewActionMemento = iMementoArray9[n15];
                string = this.getString(toggleViewActionMemento, "id");
                ++n15;
            }
            iMementoArray9 = perspectiveMemento.getChildren("show_in_time");
            n14 = iMementoArray9.length;
            n15 = 0;
            while (n15 < n14) {
                IMemento showInTimeMemento = iMementoArray9[n15];
                string = this.getString(showInTimeMemento, "id");
                ++n15;
            }
            iMementoArray9 = perspectiveMemento.getChildren("new_wizard_action");
            n14 = iMementoArray9.length;
            n15 = 0;
            while (n15 < n14) {
                IMemento newWizardActionMemento = iMementoArray9[n15];
                string = this.getString(newWizardActionMemento, "id");
                ++n15;
            }
            iMementoArray9 = perspectiveMemento.getChildren("perspective_action");
            n14 = iMementoArray9.length;
            n15 = 0;
            while (n15 < n14) {
                IMemento perspectiveActionMemento = iMementoArray9[n15];
                string = this.getString(perspectiveActionMemento, "id");
                ++n15;
            }
            iMementoArray9 = perspectiveMemento.getChildren("hide_menu_item_id");
            n14 = iMementoArray9.length;
            n15 = 0;
            while (n15 < n14) {
                IMemento hideMenuMemento = iMementoArray9[n15];
                string = this.getString(hideMenuMemento, "id");
                ++n15;
            }
            iMementoArray9 = perspectiveMemento.getChildren("hide_toolbar_item_id");
            n14 = iMementoArray9.length;
            n15 = 0;
            while (n15 < n14) {
                IMemento hideToolbarMemento = iMementoArray9[n15];
                string = this.getString(hideToolbarMemento, "id");
                ++n15;
            }
            ++n2;
        }
    }

    private Set<String> getMinimizedViews(IMemento perspectiveMemento) {
        IMemento fastViewBarsMemento = perspectiveMemento.getChild("fastViewBars");
        if (fastViewBarsMemento != null) {
            Set<String> result = Arrays.stream(fastViewBarsMemento.getChildren("fastViewBar")).map(fVB -> fVB.getChild("fastViews")).filter(Objects::nonNull).flatMap(fV -> Arrays.stream(fV.getChildren("view"))).map(v -> v.getString("id")).filter(Objects::nonNull).collect(Collectors.toSet());
            return result;
        }
        return new HashSet<String>();
    }

    private void visitViews(MWindow window, IMemento memento) {
        List sharedElements = window.getSharedElements();
        IMemento[] iMementoArray = memento.getChildren("view");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento viewMemento = iMementoArray[n2];
            String id = this.getString(viewMemento, "id");
            IMemento viewStateMemento = viewMemento.getChild("viewState");
            String name = this.getString(viewMemento, "partName");
            MPart part = MBasicFactory.INSTANCE.createPart();
            part.setElementId(id);
            part.setLabel(name);
            part.setContributionURI("bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityView");
            sharedElements.add(part);
            if (viewStateMemento instanceof XMLMemento) {
                part.getPersistedState().put("memento", this.toXML(viewStateMemento));
            }
            Map properties = part.getProperties();
            IMemento propertiesMemento = viewMemento.getChild("properties");
            if (propertiesMemento != null) {
                IMemento[] iMementoArray2 = propertiesMemento.getChildren("property");
                int n3 = iMementoArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemento propertyMemento = iMementoArray2[n4];
                    properties.put(this.getID(propertiesMemento), propertyMemento.getTextData());
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private String toXML(IMemento memento) {
        try {
            StringWriter writer = new StringWriter();
            ((XMLMemento)memento).save((Writer)writer);
            writer.flush();
            return writer.toString();
        }
        catch (Throwable ex) {
            return null;
        }
    }

    private void visitEditors(MWindow window, IMemento memento) {
        IMemento areaMemento = memento.getChild("editorArea");
        if (areaMemento != null) {
            MArea area = MAdvancedFactory.INSTANCE.createArea();
            area.setElementId(EDITOR_AREA_ID);
            window.getSharedElements().add(area);
            LinkedHashMap<String, Info> partStackInfos = new LinkedHashMap<String, Info>();
            IMemento[] infoMementos = areaMemento.getChildren("info");
            int infoIndex = 0;
            while (infoIndex < infoMementos.length) {
                IMemento folderMemento;
                IMemento infoMemento = infoMementos[infoIndex];
                Info info = new Info();
                info.partID = this.getString(infoMemento, "part");
                info.relativeID = this.getString(infoMemento, "relative");
                if (info.relativeID != null) {
                    info.relationship = this.getInteger(infoMemento, "relationship");
                    info.ratio = this.getFloat(infoMemento, "ratio", 0.5f);
                    info.left = this.getInteger(infoMemento, "ratioLeft");
                    info.right = this.getInteger(infoMemento, "ratioRight");
                }
                partStackInfos.put(info.partID, info);
                Object partStackId = PRIMARY_EDITOR_PART_STACK_ID;
                if (infoIndex > 0) {
                    partStackId = (String)partStackId + "." + infoIndex;
                }
                MPartStack partStack = MBasicFactory.INSTANCE.createPartStack();
                partStack.setElementId((String)partStackId);
                area.getChildren().add(partStack);
                info.part = partStack;
                if (infoIndex == 0) {
                    partStack.getTags().add(PRIMARY_EDITOR_PART_STACK_ID);
                    partStack.getTags().add("EditorStack");
                }
                if ((folderMemento = infoMemento.getChild("folder")) != null) {
                    int state = this.getInteger(folderMemento, "expanded");
                    IMemento[] iMementoArray = folderMemento.getChildren("presentation");
                    int n = iMementoArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMemento presentationMemento = iMementoArray[n2];
                        String string = this.getString(presentationMemento, "id");
                        ++n2;
                    }
                }
                List relevantEditorMementos = Stream.of(memento.getChildren("editor")).filter(e -> info.partID.equals(e.getString("workbook"))).collect(Collectors.toList());
                for (IMemento editorMemento : relevantEditorMementos) {
                    MPart editorPart = MBasicFactory.INSTANCE.createPart();
                    partStack.getChildren().add(editorPart);
                    editorPart.setElementId("org.eclipse.e4.ui.compatibility.editor");
                    editorPart.setContributionURI("bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor");
                    editorPart.setCloseable(true);
                    editorPart.getPersistedState().put("memento", editorMemento.toString());
                    editorPart.getTags().add("Editor");
                    editorPart.getTags().add("removeOnHide");
                    editorPart.getTags().add(editorMemento.getString("id"));
                    String partName = this.getString(editorMemento, "partName");
                    if (partName != null) {
                        editorPart.setLabel(partName);
                    } else {
                        editorPart.setLabel(this.getString(editorMemento, "title"));
                    }
                    editorPart.setTooltip(this.getString(editorMemento, "tooltip"));
                    if (this.getBoolean(editorMemento, "activePart")) {
                        editorPart.getTags().add("active");
                    }
                    if (!this.getBoolean(editorMemento, "focus")) continue;
                    partStack.setSelectedElement((MUIElement)editorPart);
                }
                ++infoIndex;
            }
            ModeledPageLayoutUtils modeledPageLayoutUtils = new ModeledPageLayoutUtils(WorkbenchUtil.getEModelService());
            for (Info info : partStackInfos.values()) {
                Info relativePart = (Info)partStackInfos.get(info.relativeID);
                if (relativePart == null) continue;
                modeledPageLayoutUtils.insert((MUIElement)info.part, (MUIElement)relativePart.part, modeledPageLayoutUtils.plRelToSwt(info.relationship), info.ratio);
            }
        }
    }

    private void visitPerspectiveBar(IMemento memento) {
    }

    private void visited(IMemento memento, String tag) {
        Object key = E4MigrationTool.key(memento);
        Set<String> set = this.visited.get(key);
        if (set == null) {
            set = new LinkedHashSet<String>();
            this.visited.put(key, set);
        }
        if (tag != null) {
            set.add(tag);
        }
    }

    private static Object key(IMemento memento) {
        try {
            Field field = memento.getClass().getDeclaredField("element");
            field.setAccessible(true);
            return field.get(memento);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private float getFloat(IMemento memento, String tag, float defaultValue) {
        this.visited(memento, tag);
        Float value = memento.getFloat(tag);
        return value == null ? defaultValue : value.floatValue();
    }

    private int getInteger(IMemento memento, String tag) {
        return this.getInteger(memento, tag, 0);
    }

    private int getInteger(IMemento memento, String tag, int defaultValue) {
        this.visited(memento, tag);
        Integer value = memento.getInteger(tag);
        return value == null ? defaultValue : value;
    }

    private boolean getBoolean(IMemento memento, String tag) {
        this.visited(memento, tag);
        Boolean value = memento.getBoolean(tag);
        return value != null && value != false;
    }

    private String getString(IMemento memento, String tag) {
        return this.getString(memento, tag, null);
    }

    private String getString(IMemento memento, String tag, String defaultValue) {
        this.visited(memento, tag);
        String value = memento.getString(tag);
        return value == null ? defaultValue : value;
    }

    private String getID(IMemento memento) {
        return this.getString(memento, "id");
    }

    private static class Info {
        public String partID;
        public String relativeID;
        public int relationship;
        public int left;
        public int right;
        public float ratio = 0.5f;
        public MPartSashContainerElement part;

        private Info() {
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("Info [partID=").append(this.partID);
            if (this.relativeID != null) {
                result.append(", relativeID=").append(this.relativeID);
                result.append(", relationship=").append(this.relationship);
                result.append(", left=").append(this.left);
                result.append(", right=").append(this.right);
                result.append(", ratio=").append(this.ratio);
            }
            result.append(']');
            return result.toString();
        }
    }
}

