/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.doc.internal.actions;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.help.ILiveHelpAction;
import org.eclipse.ua.tests.doc.internal.actions.LoadTocAction;
import org.eclipse.ua.tests.doc.internal.actions.VisitPageAction;

public class CheckLinkAction
implements ILiveHelpAction {
    private static final String HELP_TOPIC = "/help/topic";
    private static Map<String, String> links = new HashMap<String, String>();
    private String link;
    public static final String ALL_PAGES_LOADED = "ALL_PAGES_LOADED";
    public static final String CHECK_LINKS = "CHECK_LINKS";

    public void setInitializationString(String data) {
        this.link = data;
    }

    public void run() {
        if (ALL_PAGES_LOADED.equals(this.link)) {
            LoadTocAction.showErrors();
        } else if (CHECK_LINKS.equals(this.link)) {
            LoadTocAction.showErrors();
            this.checkLinks();
        } else if (this.link.startsWith("htt")) {
            links.put(this.link, VisitPageAction.lastPageVisited);
        }
    }

    private void checkLinks() {
        String errorPage = Platform.getPreferencesService().getString("org.eclipse.help.base", "page_not_found", null, null);
        this.setPageNotFoundPreference("");
        System.out.println("Start checking " + links.size() + " links");
        int count = 0;
        for (Map.Entry<String, String> entry : links.entrySet()) {
            boolean opened;
            String next = entry.getKey();
            if (++count % 1000 == 0) {
                System.out.println("Checked " + count + " links");
            }
            try {
                URL url = new URL(next);
                Throwable throwable = null;
                Object var9_11 = null;
                try (InputStream input = url.openStream();){
                    int nextChar = input.read();
                    if (nextChar == -1) {
                        System.out.println("Cannot read " + next);
                        opened = false;
                    } else {
                        opened = true;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                opened = false;
            }
            if (opened) continue;
            String containingPage = entry.getValue();
            System.out.println("Cannot open link from " + this.trimPath(containingPage) + " to " + this.trimPath(next));
        }
        this.setPageNotFoundPreference(errorPage);
        links = new HashMap<String, String>();
        System.out.println("End check links");
    }

    private String trimPath(String next) {
        int queryIndex;
        String result = next;
        int htIndex = result.indexOf(HELP_TOPIC);
        if (htIndex > 0) {
            result = result.substring(htIndex + HELP_TOPIC.length());
        }
        if ((queryIndex = result.lastIndexOf(63)) > 0) {
            result = result.substring(0, queryIndex);
        }
        return result;
    }

    private void setPageNotFoundPreference(String value) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.help.base");
        prefs.put("page_not_found", value);
    }
}

