/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.doc.internal.actions;

import java.util.List;
import org.eclipse.core.runtime.ILog;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.validation.TocValidator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ua.tests.doc.internal.dialogs.SelectTocDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class CheckTocAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;

    private static void showErrors(List<TocValidator.BrokenLink> errors) {
        if (errors.isEmpty()) {
            CheckTocAction.reportStatus("No errors detected in load");
        }
        for (TocValidator.BrokenLink link : errors) {
            CheckTocAction.reportStatus("Invalid link in \"" + link.getTocID() + "\": " + link.getHref());
        }
    }

    private static void reportStatus(String errorMessage) {
        ILog.of(CheckTocAction.class).warn(errorMessage);
    }

    public void run(IAction action) {
        SelectTocDialog dlg = new SelectTocDialog(this.window.getShell());
        dlg.open();
        if (dlg.getReturnCode() == 1) {
            return;
        }
        List<Toc> tocsToCheck = dlg.getTocsToCheck();
        this.checkTocFilesExist(tocsToCheck);
    }

    public void checkTocFilesExist(List<Toc> tocsToCheck) {
        for (Toc toc : tocsToCheck) {
            String id = toc.getTocContribution().getId();
            CheckTocAction.reportStatus("Testing " + id);
            String[] href = new String[]{id};
            try {
                List errors = TocValidator.validate((String[])href);
                CheckTocAction.showErrors(errors);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }
}

