/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.doc.internal.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.webapp.servlet.EclipseConnector;
import org.eclipse.help.internal.webapp.servlet.ExtraFilters;
import org.eclipse.help.internal.webapp.servlet.PrioritizedFilter;
import org.eclipse.help.webapp.IFilter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ua.tests.doc.internal.actions.CheckTocAction;
import org.eclipse.ua.tests.doc.internal.dialogs.SelectTocDialog;
import org.eclipse.ua.tests.doc.internal.linkchecker.AddScriptFilter;
import org.eclipse.ua.tests.doc.internal.linkchecker.OnLoadFilter;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class LoadTocAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private static ArrayList<String> topicList;
    private String firstHref;
    private static List<String> errors;
    private String lastPage;

    static {
        errors = new ArrayList<String>();
    }

    public static void showErrors() {
        if (errors == null) {
            return;
        }
        if (errors.isEmpty()) {
            LoadTocAction.reportStatus("Testing complete, no errors found");
        } else {
            LoadTocAction.reportStatus("Testing complete, errors found");
        }
        for (String errorMessage : errors) {
            LoadTocAction.reportStatus(errorMessage);
        }
        errors = null;
        topicList = null;
    }

    private static void reportStatus(String errorMessage) {
        System.out.println(errorMessage);
    }

    public void run(IAction action) {
        LoadTocAction.showErrors();
        SelectTocDialog dlg = new SelectTocDialog(this.window.getShell());
        dlg.open();
        if (dlg.getReturnCode() == 1) {
            return;
        }
        int testKind = dlg.getTestKind();
        PrioritizedFilter[] filters = new PrioritizedFilter[]{new PrioritizedFilter((IFilter)new OnLoadFilter(testKind), 1), new PrioritizedFilter((IFilter)new AddScriptFilter(), 2)};
        ExtraFilters.setFilters((PrioritizedFilter[])filters);
        List<Toc> tocsToCheck = dlg.getTocsToCheck();
        if (testKind == 1) {
            new CheckTocAction().checkTocFilesExist(tocsToCheck);
            return;
        }
        this.firstHref = null;
        topicList = new ArrayList();
        for (Toc toc : tocsToCheck) {
            LoadTocAction.reportStatus("Test level = " + testKind + " testing " + toc.getTocContribution().getId());
            ITopic[] topics = toc.getTopics();
            this.addTopics(topics);
        }
        this.lastPage = "No pages read";
        LinkProvider linkProvider = new LinkProvider(topicList);
        OnLoadFilter.setLinkProvider(linkProvider);
        EclipseConnector.setNotFoundCallout((EclipseConnector.INotFoundCallout)new NotFoundCallout());
        errors = new ArrayList<String>();
        if (linkProvider.hasNext()) {
            this.firstHref = linkProvider.next();
            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(this.firstHref);
            new MonitorThread().start();
        } else {
            LoadTocAction.reportStatus("No pages to check");
        }
    }

    private void addTopics(ITopic[] topics) {
        ITopic[] iTopicArray = topics;
        int n = topics.length;
        int n2 = 0;
        while (n2 < n) {
            ITopic nextTopic = iTopicArray[n2];
            this.addTopic(nextTopic);
            ++n2;
        }
    }

    private void addTopic(ITopic nextTopic) {
        String href = nextTopic.getHref();
        if (href != null && !this.isFiltered(href)) {
            if (this.firstHref == null) {
                this.firstHref = href;
            }
            topicList.add(href);
        }
        this.addTopics(nextTopic.getSubtopics());
    }

    private boolean isFiltered(String href) {
        return !href.startsWith("/");
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    private class LinkProvider
    implements Iterator<String> {
        private final List<String> links;
        int lastLink = -1;

        public LinkProvider(List<String> links) {
            this.links = links;
        }

        @Override
        public boolean hasNext() {
            if (topicList != null && this.lastLink < this.links.size() && this.links.size() > 0) {
                return true;
            }
            EclipseConnector.setNotFoundCallout(null);
            LoadTocAction.showErrors();
            return false;
        }

        @Override
        public String next() {
            if (this.lastLink >= 0 && this.lastLink < this.links.size()) {
                LoadTocAction.this.lastPage = this.links.get(this.lastLink);
            }
            ++this.lastLink;
            if (this.lastLink < this.links.size()) {
                String currentPage = this.links.get(this.lastLink);
                return currentPage;
            }
            if (this.lastLink == this.links.size()) {
                String currentPage = this.links.get(this.lastLink - 1);
                return currentPage;
            }
            return null;
        }

        @Override
        public void remove() {
        }
    }

    private class MonitorThread
    extends Thread {
        String lastHref;
        int timesSame = 0;
        boolean isComplete = false;

        private MonitorThread() {
        }

        @Override
        public void run() {
            while (!this.isComplete) {
                if (this.lastHref == LoadTocAction.this.lastPage) {
                    ++this.timesSame;
                } else {
                    this.lastHref = LoadTocAction.this.lastPage;
                    this.timesSame = 0;
                }
                if (topicList == null) {
                    this.isComplete = true;
                    continue;
                }
                if (this.timesSame >= 10) {
                    errors.add("Time out on page " + LoadTocAction.this.lastPage);
                    this.isComplete = true;
                    LoadTocAction.showErrors();
                    continue;
                }
                try {
                    MonitorThread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private class NotFoundCallout
    implements EclipseConnector.INotFoundCallout {
        private NotFoundCallout() {
        }

        public void notFound(String url) {
            if (errors != null) {
                errors.add("Error opening " + LoadTocAction.this.lastPage + "\n   cannot load " + url);
            }
        }
    }
}

