/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.doc.internal.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SelectTocDialog
extends Dialog {
    private int[] selectedTocs = new int[0];
    private org.eclipse.swt.widgets.List tocList;
    private final Toc[] tocs;
    private Button existButton;
    private Button loadButton;
    private Button followLinksButton;
    public static final int PAGES_EXIST = 1;
    public static final int LOAD_PAGES = 2;
    public static final int FOLLOW_LINKS = 3;
    public static final int NO_SELECTION = 3;
    private int buttonState;

    public SelectTocDialog(Shell parentShell) {
        super(parentShell);
        String locale = Platform.getNL();
        this.tocs = HelpPlugin.getTocManager().getTocs(locale);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Check Table of Contents");
    }

    protected Control createDialogArea(Composite parent) {
        Composite inner = new Composite(parent, 0);
        inner.setLayout((Layout)new GridLayout());
        inner.setLayoutData((Object)new GridData(1808));
        Label selectLabel = new Label(inner, 0);
        selectLabel.setText("Select a TOC to check");
        this.tocList = new org.eclipse.swt.widgets.List(inner, 2818);
        Toc[] tocArray = this.tocs;
        int n = this.tocs.length;
        int n2 = 0;
        while (n2 < n) {
            Toc toc = tocArray[n2];
            this.tocList.add(toc.getLabel());
            ++n2;
        }
        this.tocList.setSelection(0);
        GridData tocData = new GridData(1808);
        tocData.widthHint = 300;
        tocData.heightHint = 300;
        this.tocList.setLayoutData((Object)tocData);
        this.existButton = new Button(inner, 16);
        this.existButton.setText("Check files in TOC exist");
        this.loadButton = new Button(inner, 16);
        this.loadButton.setText("Check files in TOC can load including css/images/javascript");
        this.followLinksButton = new Button(inner, 16);
        this.followLinksButton.setText("Check files in TOC can load and check hyperlinks");
        this.existButton.setSelection(true);
        return inner;
    }

    protected void okPressed() {
        this.selectedTocs = this.tocList.getSelectionIndices();
        this.buttonState = this.existButton.getSelection() ? 1 : (this.loadButton.getSelection() ? 2 : (this.followLinksButton.getSelection() ? 3 : 3));
        super.okPressed();
    }

    public List<Toc> getTocsToCheck() {
        ArrayList<Toc> selected = new ArrayList<Toc>();
        int[] nArray = this.selectedTocs;
        int n = this.selectedTocs.length;
        int n2 = 0;
        while (n2 < n) {
            int selectedToc = nArray[n2];
            selected.add(this.tocs[selectedToc]);
            ++n2;
        }
        return selected;
    }

    public int getTestKind() {
        return this.buttonState;
    }
}

