/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.doc.internal.linkchecker;

import java.net.URI;
import java.net.URL;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.SAXParser;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.simpleconfigurator.manipulator.SimpleConfiguratorManipulator;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.IToc;
import org.eclipse.help.IUAElement;
import org.eclipse.help.internal.toc.TocContribution;
import org.eclipse.help.internal.toc.TocFile;
import org.eclipse.help.internal.toc.TocFileParser;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.junit.jupiter.api.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ApiDocTest {
    private static final String[] TOCS = new String[]{"org.eclipse.platform.doc.isv", "org.eclipse.jdt.doc.isv", "org.eclipse.pde.doc.user"};
    private static final String TOPICS_REFERENCE_XML = "topics_Reference.xml";
    private static final String REFERENCE_EXTENSION_POINTS = "reference/extension-points/";
    private static final String REFERENCE_API = "reference/api/";

    @Test
    public void testTopicsReference() throws Exception {
        System.out.println("Running " + ApiDocTest.class.getName() + "#testTopicsReference()\n");
        StringBuilder problems = new StringBuilder();
        TreeSet<String> extIds = new TreeSet<String>();
        TreeSet<String> packageIds = new TreeSet<String>();
        TocFileParser parser = new TocFileParser();
        String[] stringArray = TOCS;
        int n = TOCS.length;
        int n2 = 0;
        while (n2 < n) {
            IUAElement[] children;
            String tocFile = stringArray[n2];
            TocContribution contribution = parser.parse(new TocFile(tocFile, TOPICS_REFERENCE_XML, true, "en", null, null));
            IToc toc = contribution.getToc();
            IUAElement[] iUAElementArray = children = toc.getChildren();
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                IUAElement child = iUAElementArray[n4];
                IUAElement[] iUAElementArray2 = child.getChildren();
                int n5 = iUAElementArray2.length;
                int n6 = 0;
                while (n6 < n5) {
                    IHelpResource topic;
                    String href;
                    IUAElement child2 = iUAElementArray2[n6];
                    if (child2 instanceof IHelpResource && (href = (topic = (IHelpResource)child2).getHref()) != null) {
                        if (href.startsWith(REFERENCE_EXTENSION_POINTS)) {
                            id = topic.getLabel();
                            if (!extIds.add(id)) {
                                problems.append("Extension point label '" + id + "' appears more than once in 'topics_Reference.xml' files.\n");
                            } else {
                                filename = href.substring(REFERENCE_EXTENSION_POINTS.length());
                                expectedFileName = id.replace('.', '_') + ".html";
                                if (!expectedFileName.equals(filename)) {
                                    problems.append("File name for extension point '" + id + "' expected: '" + expectedFileName + "' but was: '" + filename + "'\n");
                                }
                            }
                        } else if (href.startsWith(REFERENCE_API)) {
                            id = topic.getLabel();
                            if (!packageIds.add(id)) {
                                problems.append("API package label '" + id + "' appears more than once in 'topics_Reference.xml' files.\n");
                            } else {
                                filename = href.substring(REFERENCE_API.length());
                                expectedFileName = id.replace('.', '/') + "/package-summary.html";
                                if (!expectedFileName.equals(filename)) {
                                    problems.append("File name for package label '" + id + "' expected: '" + expectedFileName + "' but was: '" + filename + "'\n");
                                }
                            }
                        }
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        ApiDocTest.checkExtensionPoints(extIds, problems);
        ApiDocTest.checkPackages(packageIds, problems);
        Assertions.assertThat((StringBuilder)problems).isEmpty();
    }

    private static void checkExtensionPoints(Set<String> extIds, StringBuilder problems) throws Exception {
        IExtensionPoint[] extensionPoints;
        Callable<BundleInfo[]> sourceBundlesCache = new Callable<BundleInfo[]>(){
            private BundleInfo[] bundleInfos;

            @Override
            public BundleInfo[] call() throws Exception {
                if (this.bundleInfos == null) {
                    BundleContext context = FrameworkUtil.getBundle(ApiDocTest.class).getBundleContext();
                    ServiceReference serviceReference = context.getServiceReference(SimpleConfiguratorManipulator.class);
                    SimpleConfiguratorManipulator manipulator = (SimpleConfiguratorManipulator)context.getService(serviceReference);
                    this.bundleInfos = manipulator.loadConfiguration(context, SimpleConfiguratorManipulator.SOURCE_INFO);
                }
                return this.bundleInfos;
            }
        };
        TreeSet<String> registeredIds = new TreeSet<String>();
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint[] iExtensionPointArray = extensionPoints = registry.getExtensionPoints();
        int n = extensionPoints.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                String id;
                block10: {
                    IExtensionPoint extensionPoint = iExtensionPointArray[n2];
                    id = extensionPoint.getUniqueIdentifier();
                    String schemaReference = extensionPoint.getSchemaReference();
                    if (schemaReference == null || schemaReference.isEmpty()) {
                        problems.append("Extension point missing a schema reference: " + id + "\n");
                    } else {
                        InputSource schemaSource = ApiDocTest.getExtensionPointSchemaSource(extensionPoint, schemaReference, sourceBundlesCache);
                        if (schemaSource != null) {
                            SAXParser parser = XmlProcessorFactory.createSAXParserWithErrorOnDOCTYPE((boolean)false);
                            InternalExtensionFinder handler = new InternalExtensionFinder();
                            try {
                                parser.parse(schemaSource, (DefaultHandler)handler);
                                break block10;
                            }
                            catch (InternalExtensionFoundException e) {
                                System.out.append("Skipping internal extension point " + id + "\n");
                                break block11;
                            }
                        }
                        System.out.append("Extension point schema file not found for " + id + ": " + schemaReference + "\n");
                    }
                }
                registeredIds.add(id);
            }
            ++n2;
        }
        TreeSet<String> unexpectedTocIds = new TreeSet<String>(extIds);
        unexpectedTocIds.removeAll(registeredIds);
        if (!unexpectedTocIds.isEmpty()) {
            problems.append("\n* Unexpected extension points in topics_Reference.xml:\n");
            for (String unexpectedTocId : unexpectedTocIds) {
                problems.append(unexpectedTocId).append('\n');
            }
        }
        registeredIds.removeAll(extIds);
        if (!registeredIds.isEmpty()) {
            System.out.append("\n* Undocumented non-internal extension points:\n");
            for (String registeredId : registeredIds) {
                System.out.append(registeredId).append('\n');
            }
        }
    }

    private static InputSource getExtensionPointSchemaSource(IExtensionPoint extensionPoint, String schemaReference, Callable<BundleInfo[]> sourceBundlesLoader) throws Exception {
        BundleInfo[] bundles;
        String contributor = extensionPoint.getContributor().getName();
        Bundle bundle = Platform.getBundle((String)contributor);
        URL schemaURL = bundle.getEntry(schemaReference);
        if (schemaURL != null) {
            return new InputSource(schemaURL.toString());
        }
        BundleInfo[] bundleInfoArray = bundles = sourceBundlesLoader.call();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleInfo bundleInfo = bundleInfoArray[n2];
            if (bundleInfo.getSymbolicName().equals(contributor + ".source")) {
                URI location = bundleInfo.getLocation();
                URL fileURL = FileLocator.toFileURL((URL)location.toURL());
                ZipFile zipFile = new ZipFile(fileURL.getPath());
                ZipEntry entry = zipFile.getEntry(schemaReference);
                if (entry == null) {
                    return null;
                }
                return new InputSource(zipFile.getInputStream(entry));
            }
            ++n2;
        }
        return null;
    }

    private static void checkPackages(Set<String> packageIds, StringBuilder problems) {
        TreeSet<String> exportedPackageIds = new TreeSet<String>();
        exportedPackageIds.add("org.eclipse.core.runtime.adaptor");
        exportedPackageIds.add("org.eclipse.swt.ole.win32");
        BundleContext context = FrameworkUtil.getBundle(ApiDocTest.class).getBundleContext();
        ServiceReference platformAdminReference = context.getServiceReference(PlatformAdmin.class);
        PlatformAdmin service = (PlatformAdmin)context.getService(platformAdminReference);
        State state = service.getState(false);
        BundleDescription[] bundleDescriptionArray = state.getBundles();
        int n = bundleDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription bundle = bundleDescriptionArray[n2];
            bundle.getCapabilities("osgi.wiring.package").forEach(t -> {
                boolean bl = exportedPackageIds.add((String)t.getAttributes().get("osgi.wiring.package"));
            });
            ++n2;
        }
        TreeSet<String> unexpectedPackageIds = new TreeSet<String>(packageIds);
        unexpectedPackageIds.removeAll(exportedPackageIds);
        if (!unexpectedPackageIds.isEmpty()) {
            problems.append("\n* Unexpected exported API packages in topics_Reference.xml:\n");
            for (String unexpectedTocId : unexpectedPackageIds) {
                problems.append(unexpectedTocId).append('\n');
            }
        }
        exportedPackageIds.removeAll(packageIds);
        if (!exportedPackageIds.isEmpty()) {
            System.out.append("\n* Undocumented exported API package:\n");
            for (String exportedPackageId : exportedPackageIds) {
                System.out.append(exportedPackageId).append('\n');
            }
        }
    }

    static class InternalExtensionFinder
    extends DefaultHandler {
        int state = 0;

        InternalExtensionFinder() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            switch (this.state) {
                case 0: {
                    if (!"element".equalsIgnoreCase(qName) || !"extension".equals(attributes.getValue("name"))) break;
                    this.state = 1;
                    break;
                }
                case 1: {
                    if (!"annotation".equalsIgnoreCase(qName)) break;
                    this.state = 2;
                    break;
                }
                case 2: {
                    if (!"appInfo".equalsIgnoreCase(qName)) break;
                    this.state = 3;
                    break;
                }
                case 3: {
                    if (!"meta.element".equalsIgnoreCase(qName) || !"true".equals(attributes.getValue("internal"))) break;
                    throw new InternalExtensionFoundException();
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.state = 0;
        }
    }

    static class InternalExtensionFoundException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        InternalExtensionFoundException() {
        }
    }
}

