/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.doc.internal.linkchecker;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.QueryTooComplexException;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.search.SearchQuery;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.junit.jupiter.api.Test;

public class LinkTest {
    private static final Pattern HREF = Pattern.compile("<a href=\"([^\"]+)\"");

    @Test
    public void testAllLinks() {
        final IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        SearchQuery query = new SearchQuery("*", false, Collections.emptyList(), Platform.getNL());
        final HashSet indexedPagesURIs = new HashSet();
        final Set hrefErrors = Collections.synchronizedSet(new LinkedHashSet());
        ISearchHitCollector collector = new ISearchHitCollector(){

            public void addQTCException(QueryTooComplexException exception) throws QueryTooComplexException {
                throw exception;
            }

            public void addHits(List<SearchHit> hits, String wordsSearched) {
                hits.stream().map(SearchHit::getHref).map(href -> {
                    try {
                        return helpSystem.resolve(href, false).toURI();
                    }
                    catch (Exception e) {
                        hrefErrors.add(new IllegalStateException("Error resolving '" + href + "': " + e.getMessage(), e));
                        return null;
                    }
                }).filter(Objects::nonNull).sorted().peek(System.err::println).forEach(indexedPagesURIs::add);
            }
        };
        BaseHelpSystem.getSearchManager().search((ISearchQuery)query, collector, (IProgressMonitor)new NullProgressMonitor());
        if (!hrefErrors.isEmpty()) {
            Exception first = (Exception)hrefErrors.iterator().next();
            throw new AssertionError(first.getMessage(), first);
        }
        Set linkFailures = Collections.synchronizedSet(new TreeSet());
        Set ex = Collections.synchronizedSet(new LinkedHashSet());
        Set allKnownPageURIs = Collections.synchronizedSet(new TreeSet(indexedPagesURIs));
        indexedPagesURIs.parallelStream().forEach(t -> {
            block13: {
                String path = t.getPath();
                if (path.lastIndexOf(47) > 0) {
                    path = path.substring(path.lastIndexOf(47));
                }
                boolean notFile = false;
                if (!path.contains(".")) {
                    notFile = true;
                    System.out.println("Not a file?: " + String.valueOf(t));
                }
                try {
                    Throwable throwable = null;
                    Object var8_10 = null;
                    try (InputStream stream = t.toURL().openStream();){
                        linkFailures.addAll(this.checkLinks(stream, (URI)t, allKnownPageURIs));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    if (notFile) break block13;
                    ex.add(e);
                }
            }
        });
        Assertions.assertThat(ex).isEmpty();
        Assertions.assertThat(linkFailures).isEmpty();
    }

    private Set<String> checkLinks(InputStream stream, URI currentDoc, Set<URI> knownPagesURIs) throws IOException {
        HashSet<String> res = new HashSet<String>();
        Throwable throwable = null;
        Object var6_7 = null;
        try (BufferedReader in = new BufferedReader(new InputStreamReader(stream));){
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                Matcher matcher = HREF.matcher(inputLine);
                while (matcher.find()) {
                    URI linkURI;
                    URI href = URI.create(matcher.group(1).replace(" ", "%20"));
                    if (href.isAbsolute() || knownPagesURIs.contains(linkURI = URI.create(currentDoc.toString() + "/../" + String.valueOf(href)).normalize())) continue;
                    HttpURLConnection connection = (HttpURLConnection)linkURI.toURL().openConnection();
                    connection.setRequestMethod("HEAD");
                    connection.connect();
                    if (connection.getResponseCode() != 200) {
                        res.add("Link from " + String.valueOf(currentDoc) + " to " + String.valueOf(href) + " is broken: target URI " + String.valueOf(linkURI) + " doens't exist.");
                        continue;
                    }
                    knownPagesURIs.add(linkURI);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return res;
    }
}

