/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.doc.internal.linkchecker;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.help.internal.webapp.servlet.FilterUtils;
import org.eclipse.help.webapp.IFilter;

public class OnLoadFilter
implements IFilter {
    private static long uniqueId = 0L;
    private final int testKind;
    private static Iterator<String> linkProvider;

    public OnLoadFilter(int testKind) {
        this.testKind = testKind;
    }

    protected String getCommentText() {
        return "comment";
    }

    public OutputStream filter(HttpServletRequest req, OutputStream out) {
        if (linkProvider == null) {
            return out;
        }
        String pathPrefix = FilterUtils.getRelativePathPrefix((HttpServletRequest)req);
        if (pathPrefix.length() >= 4) {
            return new OutFilter(out, pathPrefix.substring(0, pathPrefix.length() - 4));
        }
        return new OutFilter(out, "PLUGINS_ROOT");
    }

    public static void setLinkProvider(Iterator<String> provider) {
        linkProvider = provider;
    }

    private class OutFilter
    extends OutputStream {
        private final OutputStream out;
        private int state = 0;
        private final String pathPrefix;

        public void updateState(int b) throws IOException {
            if (this.state == 0 && b == 60) {
                this.state = 1;
            } else if (this.state == 1 && (b == 98 || b == 66)) {
                this.state = 2;
            } else if (this.state == 2 && (b == 111 || b == 79)) {
                this.state = 3;
            } else if (this.state == 3 && (b == 100 || b == 68)) {
                this.state = 4;
            } else if (this.state == 4 && (b == 121 || b == 89)) {
                this.state = 20;
                this.out.write(b);
                if (linkProvider.hasNext()) {
                    String location = linkProvider.next();
                    String onload = this.getOnloadText(this.pathPrefix + location, OnLoadFilter.this.testKind);
                    this.out.write(onload.getBytes());
                } else {
                    linkProvider = null;
                    String announceComplete = this.getCompletionText(OnLoadFilter.this.testKind);
                    this.out.write(announceComplete.getBytes());
                }
            } else if (this.state == 20 && b == 62) {
                this.state = 21;
            } else if (this.state == 1 && (b == 104 || b == 72)) {
                this.state = 11;
            } else if (this.state == 11 && (b == 101 || b == 69)) {
                this.state = 12;
            } else if (this.state == 12 && (b == 97 || b == 65)) {
                this.state = 13;
            } else if (this.state == 13 && (b == 109 || b == 77)) {
                this.state = 14;
            } else if (this.state == 14 && (b == 101 || b == 69)) {
                this.state = 15;
            } else if (this.state == 15 && (b == 115 || b == 83)) {
                this.state = 16;
            } else if (this.state == 16 && (b == 101 || b == 69)) {
                this.state = 17;
            } else if (this.state == 17 && (b == 116 || b == 84)) {
                this.state = 20;
            } else if (this.state > 0 && this.state < 20) {
                this.state = 0;
            }
        }

        private String getOnloadText(String location, int testKind) {
            Object onload = " onload = \"";
            if (testKind == 3) {
                onload = (String)onload + "ua_test_doc_record_links();";
            }
            onload = (String)onload + " window.location = '";
            String uniqParam = "?uniq=" + ++uniqueId;
            int anchor = location.indexOf(35);
            onload = anchor == -1 ? (String)onload + location + uniqParam + "'" : (String)onload + location.substring(0, anchor) + uniqParam + location.substring(anchor) + "'";
            onload = (String)onload + "\"";
            return onload;
        }

        private String getCompletionText(int testKind) {
            if (testKind == 3) {
                return " onload = \"ua_test_doc_check_links();\" ";
            }
            return " onload = \"ua_test_doc_complete();\" ";
        }

        public OutFilter(OutputStream out, String prefix) {
            this.out = out;
            this.pathPrefix = prefix;
        }

        @Override
        public void write(int b) throws IOException {
            this.updateState(b);
            if (this.state != 20) {
                this.out.write(b);
            }
        }

        @Override
        public void close() throws IOException {
            this.out.close();
            super.close();
        }
    }
}

