/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.doc.internal.linkchecker;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.eclipse.help.internal.validation.TocValidator;
import org.junit.jupiter.api.Test;

public class TocLinkChecker {
    private static final String[] PLATFORM_USER = new String[]{"/org.eclipse.platform.doc.user/toc.xml"};
    private static final String[] PLATFORM_ISV = new String[]{"/org.eclipse.platform.doc.isv/toc.xml"};
    private static final String[] PDE_USER = new String[]{"/org.eclipse.pde.doc.user/toc.xml"};
    private static final String[] JDT_USER = new String[]{"/org.eclipse.jdt.doc.user/toc.xml"};
    private static final String[] JDT_ISV = new String[]{"/org.eclipse.jdt.doc.isv/toc.xml"};

    @Test
    public void testPlatformUser() throws Exception {
        List failures = TocValidator.validate((String[])PLATFORM_USER);
        this.doAssert(failures);
    }

    @Test
    public void testPlatformIsvStatic() throws Exception {
        List failures = TocValidator.filteredValidate((String[])PLATFORM_ISV, (TocValidator.Filter)new NonReferenceNonSampleFilter());
        this.doAssert(failures);
    }

    @Test
    public void testPlatformIsvGenerated() throws Exception {
        List failures = TocValidator.filteredValidate((String[])PLATFORM_ISV, (TocValidator.Filter)new ReferenceOrSampleFilter());
        this.doAssert(failures);
    }

    @Test
    public void testPdeUserStatic() throws Exception {
        List failures = TocValidator.filteredValidate((String[])PDE_USER, (TocValidator.Filter)new NonReferenceFilter());
        this.doAssert(failures);
    }

    @Test
    public void testPdeUserGenerated() throws Exception {
        List failures = TocValidator.filteredValidate((String[])PDE_USER, (TocValidator.Filter)new ReferenceFilter());
        this.doAssert(failures);
    }

    @Test
    public void testJdtUser() throws Exception {
        List failures = TocValidator.validate((String[])JDT_USER);
        this.doAssert(failures);
    }

    @Test
    public void testJdtIsvStatic() throws Exception {
        List failures = TocValidator.filteredValidate((String[])JDT_ISV, (TocValidator.Filter)new NonReferenceFilter());
        this.doAssert(failures);
    }

    @Test
    public void testJdtIsvGenerated() throws Exception {
        List failures = TocValidator.filteredValidate((String[])JDT_ISV, (TocValidator.Filter)new ReferenceFilter());
        this.doAssert(failures);
    }

    private void doAssert(List<TocValidator.BrokenLink> failures) {
        StringBuilder message = new StringBuilder();
        for (TocValidator.BrokenLink link : failures) {
            message.append("Invalid link in \"" + link.getTocID() + "\": " + link.getHref() + "\n");
        }
        ((ListAssert)Assertions.assertThat(failures).withFailMessage(message.toString(), new Object[0])).isEmpty();
    }

    private static final class NonReferenceFilter
    extends TocValidator.Filter {
        private NonReferenceFilter() {
        }

        public boolean isIncluded(String href) {
            return !href.startsWith("reference");
        }
    }

    private static final class NonReferenceNonSampleFilter
    extends TocValidator.Filter {
        private NonReferenceNonSampleFilter() {
        }

        public boolean isIncluded(String href) {
            return !href.startsWith("reference") && !href.startsWith("samples");
        }
    }

    private static final class ReferenceFilter
    extends TocValidator.Filter {
        private ReferenceFilter() {
        }

        public boolean isIncluded(String href) {
            return href.startsWith("reference");
        }
    }

    private static final class ReferenceOrSampleFilter
    extends TocValidator.Filter {
        private ReferenceOrSampleFilter() {
        }

        public boolean isIncluded(String href) {
            return href.startsWith("reference") || href.startsWith("samples");
        }
    }
}

