/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.core.parser;

import java.io.IOException;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.dom.DocumentCSSImpl;
import org.eclipse.e4.ui.css.core.impl.dom.ViewCSSImpl;
import org.eclipse.e4.ui.css.swt.engine.CSSSWTEngineImpl;
import org.eclipse.e4.ui.tests.css.core.util.ParserTestUtil;
import org.eclipse.e4.ui.tests.css.core.util.TestElement;
import org.eclipse.swt.widgets.Display;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.stylesheets.StyleSheet;

public class CascadeTest {
    private Display display;
    private CSSSWTEngineImpl engine;

    @BeforeEach
    public void setUp() throws Exception {
        this.display = Display.getDefault();
        this.engine = new CSSSWTEngineImpl(this.display);
    }

    @Test
    void testPosition() throws Exception {
        String css = "Button { color: blue; font-weight: bold; }\nButton { color: black }\n";
        ViewCSS viewCSS = CascadeTest.createViewCss(css);
        TestElement button = new TestElement("Button", (CSSEngine)this.engine);
        CSSStyleDeclaration style = viewCSS.getComputedStyle((Element)((Object)button), null);
        Assertions.assertEquals((Object)"black", (Object)style.getPropertyCSSValue("color").getCssText());
        Assertions.assertEquals((Object)"bold", (Object)style.getPropertyCSSValue("font-weight").getCssText());
    }

    @Test
    void testSpecificity() throws Exception {
        String css = "Label, Button.special { color: black; }\nButton { color: blue; font-weight: bold; }\n";
        ViewCSS viewCSS = CascadeTest.createViewCss(css);
        TestElement button = new TestElement("Button", (CSSEngine)this.engine);
        CSSStyleDeclaration style = viewCSS.getComputedStyle((Element)((Object)button), null);
        Assertions.assertEquals((Object)"blue", (Object)style.getPropertyCSSValue("color").getCssText());
        button.setClass("special");
        style = viewCSS.getComputedStyle((Element)((Object)button), null);
        Assertions.assertEquals((Object)"black", (Object)style.getPropertyCSSValue("color").getCssText());
        Assertions.assertEquals((Object)"bold", (Object)style.getPropertyCSSValue("font-weight").getCssText());
    }

    @Test
    void ensureThatClassAndIdareConsideredIfOnTheSameLevel() throws Exception {
        String css = "CTabFolder > Composite > Toolbar { color: black; }\nCTabFolder > Composite > .special { color: blue; font-weight: bold; }\nCTabFolder > Composite > #special { color: red; font-weight: bold; }\n";
        ViewCSS viewCSS = CascadeTest.createViewCss(css);
        TestElement tabFolder = new TestElement("CTabFolder", (CSSEngine)this.engine);
        TestElement composite = new TestElement("Composite", tabFolder, (CSSEngine)this.engine);
        TestElement toolbar = new TestElement("Toolbar", composite, (CSSEngine)this.engine);
        CSSStyleDeclaration style = viewCSS.getComputedStyle((Element)((Object)toolbar), null);
        Assertions.assertEquals((Object)"black", (Object)style.getPropertyCSSValue("color").getCssText());
        toolbar.setClass("special");
        style = viewCSS.getComputedStyle((Element)((Object)toolbar), null);
        Assertions.assertEquals((Object)"blue", (Object)style.getPropertyCSSValue("color").getCssText());
        toolbar.setId("special");
        style = viewCSS.getComputedStyle((Element)((Object)toolbar), null);
        Assertions.assertEquals((Object)"red", (Object)style.getPropertyCSSValue("color").getCssText());
    }

    @Test
    void testSpecificities() throws Exception {
        String css = "* { color: black; }\nButton { color: blue; }\nButton[BORDER] { color: gray; }\nButton.special { color: green; }\nButton#myid { color: red; }\n";
        ViewCSS viewCSS = CascadeTest.createViewCss(css);
        TestElement label = new TestElement("Label", (CSSEngine)this.engine);
        CSSStyleDeclaration style = viewCSS.getComputedStyle((Element)((Object)label), null);
        Assertions.assertEquals((Object)"black", (Object)style.getPropertyCSSValue("color").getCssText());
        TestElement button = new TestElement("Button", (CSSEngine)this.engine);
        style = viewCSS.getComputedStyle((Element)((Object)button), null);
        Assertions.assertEquals((Object)"blue", (Object)style.getPropertyCSSValue("color").getCssText());
        button.setAttribute("BORDER", "true");
        style = viewCSS.getComputedStyle((Element)((Object)button), null);
        Assertions.assertEquals((Object)"gray", (Object)style.getPropertyCSSValue("color").getCssText());
        button.setClass("special");
        style = viewCSS.getComputedStyle((Element)((Object)button), null);
        Assertions.assertEquals((Object)"green", (Object)style.getPropertyCSSValue("color").getCssText());
        button.setId("myid");
        style = viewCSS.getComputedStyle((Element)((Object)button), null);
        Assertions.assertEquals((Object)"red", (Object)style.getPropertyCSSValue("color").getCssText());
    }

    private static ViewCSS createViewCss(String ... css) throws IOException {
        DocumentCSSImpl docCss = new DocumentCSSImpl();
        String[] stringArray = css;
        int n = css.length;
        int n2 = 0;
        while (n2 < n) {
            String cssString = stringArray[n2];
            CSSStyleSheet styleSheet = ParserTestUtil.parseCss(cssString);
            docCss.addStyleSheet((StyleSheet)styleSheet);
            ++n2;
        }
        return new ViewCSSImpl((DocumentCSS)docCss);
    }

    @Test
    void testBug261081() throws Exception {
        String css = "Button, Label { color: blue; font-weight: bold; }\nButton { color: black }\n";
        ViewCSS viewCSS = CascadeTest.createViewCss(css);
        TestElement button = new TestElement("Button", (CSSEngine)this.engine);
        CSSStyleDeclaration style = viewCSS.getComputedStyle((Element)((Object)button), null);
        Assertions.assertEquals((Object)"black", (Object)style.getPropertyCSSValue("color").getCssText());
        Assertions.assertEquals((Object)"bold", (Object)style.getPropertyCSSValue("font-weight").getCssText());
    }

    @Test
    void testBug458342_combine() throws Exception {
        String css1 = "Button { color: blue; }";
        String css2 = "Button { font-weight: bold; }";
        ViewCSS viewCSS = CascadeTest.createViewCss(css1, css2);
        TestElement button = new TestElement("Button", (CSSEngine)this.engine);
        CSSStyleDeclaration style = viewCSS.getComputedStyle((Element)((Object)button), null);
        Assertions.assertEquals((Object)"blue", (Object)style.getPropertyCSSValue("color").getCssText());
        Assertions.assertEquals((Object)"bold", (Object)style.getPropertyCSSValue("font-weight").getCssText());
    }

    @Test
    void testBug458342_override() throws Exception {
        String css1 = "Button { color: blue; font-weight: bold; }";
        String css2 = "Button { color: black; }";
        ViewCSS viewCSS = CascadeTest.createViewCss(css1, css2);
        TestElement button = new TestElement("Button", (CSSEngine)this.engine);
        CSSStyleDeclaration style = viewCSS.getComputedStyle((Element)((Object)button), null);
        Assertions.assertEquals((Object)"black", (Object)style.getPropertyCSSValue("color").getCssText());
        Assertions.assertEquals((Object)"bold", (Object)style.getPropertyCSSValue("font-weight").getCssText());
    }
}

