/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.core.parser;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.dom.DocumentCSSImpl;
import org.eclipse.e4.ui.css.core.impl.dom.ViewCSSImpl;
import org.eclipse.e4.ui.tests.css.core.util.ParserTestUtil;
import org.eclipse.e4.ui.tests.css.core.util.TestElement;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;

public class ImportTest {
    private CSSEngine engine;

    @BeforeEach
    public void setUp() {
        this.engine = ParserTestUtil.createEngine();
    }

    @Test
    void testOverrideImportedRule() throws Exception {
        String importedCss = ".ClassAlpha {\n     property: value;\n  }\n  .ClassBeta {\n     property: value1;\n  }";
        File importedFile = this.createTempCssFile(importedCss);
        String importingCss = this.createImport(importedFile) + "  .ClassBeta {\n     property: value2;\n  }";
        String importedFolderPath = importedFile.getParent();
        String importingUrl = "file:///" + importedFolderPath + "/importing.css";
        ViewCSS viewCSS = this.createViewCss(importingUrl, importingCss);
        TestElement buttonAlpha = new TestElement("Button", this.engine);
        buttonAlpha.setClass("ClassAlpha");
        TestElement buttonBeta = new TestElement("Button", this.engine);
        buttonBeta.setClass("ClassBeta");
        CSSStyleDeclaration styleAlpha = viewCSS.getComputedStyle((Element)((Object)buttonAlpha), null);
        CSSStyleDeclaration styleBeta = viewCSS.getComputedStyle((Element)((Object)buttonBeta), null);
        Assertions.assertEquals((Object)"value", (Object)styleAlpha.getPropertyCSSValue("property").getCssText());
        Assertions.assertEquals((Object)"value2", (Object)styleBeta.getPropertyCSSValue("property").getCssText());
    }

    @Test
    void testNestedImports() throws IOException {
        String deepNestedCss = "ChildChild { property: value; }\n";
        File importedFile = this.createTempCssFile(deepNestedCss);
        String childStyle = "Child { property: value; }\n";
        String childCss = this.createImport(importedFile) + childStyle;
        importedFile = this.createTempCssFile(childCss);
        String rootStyle = "Root { property: value; }\n";
        String rootCss = this.createImport(importedFile) + rootStyle;
        String importedFolderPath = importedFile.getParent();
        String importingUrl = "file:///" + importedFolderPath + "/root.css";
        CSSStyleSheet result = this.parseStyleSheet(importingUrl, rootCss);
        Assertions.assertNotNull((Object)result);
        CSSRuleList cssRules = result.getCssRules();
        Assertions.assertEquals((int)3, (int)cssRules.getLength());
        this.assertStyle(deepNestedCss, cssRules, 0);
        this.assertStyle(childStyle, cssRules, 1);
        this.assertStyle(rootStyle, cssRules, 2);
        StyleSheetList documentStyleSheets = this.engine.getDocumentCSS().getStyleSheets();
        Assertions.assertEquals((int)1, (int)documentStyleSheets.getLength());
        StyleSheet documentStyleSheet = documentStyleSheets.item(0);
        Assertions.assertEquals((Object)result, (Object)documentStyleSheet);
    }

    private void assertStyle(String expectedStyleText, CSSRuleList cssRules, int index) {
        Assertions.assertEquals((short)1, (short)cssRules.item(index).getType());
        Assertions.assertEquals((Object)expectedStyleText.trim(), (Object)cssRules.item(index).getCssText());
    }

    private File createTempCssFile(String cssString) throws IOException {
        File result = File.createTempFile("e4.ui.tests-", ".css");
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileWriter fileWriter = new FileWriter(result);){
            fileWriter.write(cssString);
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String createImport(File importedFile) {
        String cssUrl = importedFile.getName();
        return "@import url('" + cssUrl + "');\n";
    }

    private CSSStyleSheet parseStyleSheet(String sourceUrl, String cssString) throws IOException {
        InputSource source = new InputSource();
        source.setURI(sourceUrl);
        source.setCharacterStream((Reader)new StringReader(cssString));
        return (CSSStyleSheet)this.engine.parseStyleSheet(source);
    }

    private ViewCSS createViewCss(String sourceUrl, String cssString) throws IOException {
        CSSStyleSheet styleSheet = this.parseStyleSheet(sourceUrl, cssString);
        DocumentCSSImpl docCss = new DocumentCSSImpl();
        docCss.addStyleSheet((StyleSheet)styleSheet);
        return new ViewCSSImpl((DocumentCSS)docCss);
    }
}

