/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.core.parser;

import java.io.IOException;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.tests.css.core.util.ParserTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.SelectorList;

public class SelectorTest {
    private CSSEngine engine;

    @BeforeEach
    public void setUp() throws Exception {
        this.engine = ParserTestUtil.createEngine();
    }

    @Test
    void testSimpleSelector() throws Exception {
        SelectorList list = this.engine.parseSelectors("Type1");
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)1, (int)list.getLength());
        Assertions.assertEquals((Object)"Type1", (Object)list.item(0).toString());
    }

    @Test
    void testMultipleSelectors() throws Exception {
        SelectorList list = this.engine.parseSelectors("Type1, Type2");
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)2, (int)list.getLength());
        Assertions.assertEquals((Object)"Type1", (Object)list.item(0).toString());
        Assertions.assertEquals((Object)"Type2", (Object)list.item(1).toString());
    }

    @Test
    void testClassSelector() throws Exception {
        SelectorList list = this.engine.parseSelectors(".Class1");
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)1, (int)list.getLength());
        Assertions.assertEquals((Object)"*[class=\"Class1\"]", (Object)list.item(0).toString());
    }

    @Test
    void testAttributeSelector() throws Exception {
        SelectorList list = this.engine.parseSelectors("*[class='Class1']");
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)1, (int)list.getLength());
        Assertions.assertEquals((Object)"*[class=\"Class1\"]", (Object)list.item(0).toString());
    }

    @Test
    void testErrorAttributeSelector() throws IOException {
        try {
            this.engine.parseSelectors("*[class='Class1'");
            Assertions.fail((String)"Parser should have errored on missing bracket");
        }
        catch (CSSParseException cSSParseException) {
            // empty catch block
        }
    }
}

