/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.core.parser;

import org.eclipse.e4.ui.tests.css.core.util.ParserTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.RGBColor;

public class StyleRuleTest {
    @Test
    void testSimpleStyleRule() throws Exception {
        String css = "Label { color: #FF0000 }";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        Assertions.assertNotNull((Object)styleSheet);
        CSSRuleList rules = styleSheet.getCssRules();
        Assertions.assertEquals((int)1, (int)rules.getLength());
        CSSRule rule = rules.item(0);
        Assertions.assertEquals((short)1, (short)rule.getType());
    }

    @Test
    void testHexColor() throws Exception {
        String css = "Label { color: #FF0220 }";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        CSSRuleList rules = styleSheet.getCssRules();
        CSSRule rule = rules.item(0);
        Assertions.assertEquals((short)1, (short)rule.getType());
        CSSStyleDeclaration style = ((CSSStyleRule)rule).getStyle();
        CSSValue value = style.getPropertyCSSValue("color");
        Assertions.assertTrue((boolean)(value instanceof CSSPrimitiveValue));
        RGBColor colorValue = ((CSSPrimitiveValue)value).getRGBColorValue();
        Assertions.assertEquals((float)255.0f, (float)colorValue.getRed().getFloatValue((short)1));
        Assertions.assertEquals((float)2.0f, (float)colorValue.getGreen().getFloatValue((short)1));
        Assertions.assertEquals((float)32.0f, (float)colorValue.getBlue().getFloatValue((short)1));
    }

    @Test
    void testNamedColor() throws Exception {
        String css = "Label { color: green }";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        CSSRuleList rules = styleSheet.getCssRules();
        CSSRule rule = rules.item(0);
        Assertions.assertEquals((short)1, (short)rule.getType());
        CSSStyleDeclaration style = ((CSSStyleRule)rule).getStyle();
        CSSValue value = style.getPropertyCSSValue("color");
        Assertions.assertTrue((boolean)(value instanceof CSSPrimitiveValue));
        String colorString = ((CSSPrimitiveValue)value).getStringValue();
        Assertions.assertEquals((Object)"green", (Object)colorString);
    }

    @Test
    void testFont() throws Exception {
        String css = "Label { font: Verdana }";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        CSSRuleList rules = styleSheet.getCssRules();
        CSSRule rule = rules.item(0);
        Assertions.assertEquals((short)1, (short)rule.getType());
        CSSStyleDeclaration style = ((CSSStyleRule)rule).getStyle();
        CSSValue value = style.getPropertyCSSValue("font");
        Assertions.assertTrue((boolean)(value instanceof CSSPrimitiveValue));
        String colorString = ((CSSPrimitiveValue)value).getStringValue();
        Assertions.assertEquals((Object)"Verdana", (Object)colorString);
    }

    @Test
    void testTestFontItalic() throws Exception {
        String css = "Label { font: Arial 12px; font-style: italic }";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        CSSRuleList rules = styleSheet.getCssRules();
        CSSRule rule = rules.item(0);
        Assertions.assertEquals((short)1, (short)rule.getType());
        CSSStyleDeclaration style = ((CSSStyleRule)rule).getStyle();
        CSSValue value = style.getPropertyCSSValue("font-style");
        Assertions.assertTrue((boolean)(value instanceof CSSPrimitiveValue));
        String colorString = ((CSSPrimitiveValue)value).getStringValue();
        Assertions.assertEquals((Object)"italic", (Object)colorString);
    }

    @Test
    void testTestFontBold() throws Exception {
        String css = "Label { font: Arial 12px; font-style: bold }";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        CSSRuleList rules = styleSheet.getCssRules();
        CSSRule rule = rules.item(0);
        Assertions.assertEquals((short)1, (short)rule.getType());
        CSSStyleDeclaration style = ((CSSStyleRule)rule).getStyle();
        CSSValue value = style.getPropertyCSSValue("font-style");
        Assertions.assertTrue((boolean)(value instanceof CSSPrimitiveValue));
        String colorString = ((CSSPrimitiveValue)value).getStringValue();
        Assertions.assertEquals((Object)"bold", (Object)colorString);
    }

    @Test
    void testBackgroundNameColor() throws Exception {
        String css = "Label { background-color: green }";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        CSSRuleList rules = styleSheet.getCssRules();
        CSSRule rule = rules.item(0);
        Assertions.assertEquals((short)1, (short)rule.getType());
        CSSStyleDeclaration style = ((CSSStyleRule)rule).getStyle();
        CSSValue value = style.getPropertyCSSValue("background-color");
        Assertions.assertTrue((boolean)(value instanceof CSSPrimitiveValue));
        String colorString = ((CSSPrimitiveValue)value).getStringValue();
        Assertions.assertEquals((Object)"green", (Object)colorString);
    }

    @Test
    void testBackgroundHexColor() throws Exception {
        String css = "Label { background-color: #FF0220 }";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        CSSRuleList rules = styleSheet.getCssRules();
        CSSRule rule = rules.item(0);
        Assertions.assertEquals((short)1, (short)rule.getType());
        CSSStyleDeclaration style = ((CSSStyleRule)rule).getStyle();
        CSSValue value = style.getPropertyCSSValue("background-color");
        Assertions.assertTrue((boolean)(value instanceof CSSPrimitiveValue));
        RGBColor colorValue = ((CSSPrimitiveValue)value).getRGBColorValue();
        Assertions.assertEquals((float)255.0f, (float)colorValue.getRed().getFloatValue((short)1));
        Assertions.assertEquals((float)2.0f, (float)colorValue.getGreen().getFloatValue((short)1));
        Assertions.assertEquals((float)32.0f, (float)colorValue.getBlue().getFloatValue((short)1));
    }

    @Test
    void testGetCSSText() throws Exception {
        String css = "Label, * > Label { background-color: rgb(255, 2, 32); }";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        CSSRuleList rules = styleSheet.getCssRules();
        CSSRule rule = rules.item(0);
        Assertions.assertEquals((Object)css, (Object)rule.getCssText());
    }
}

