/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.core.parser;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.dom.Measure;
import org.eclipse.e4.ui.tests.css.core.util.ParserTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class ValueTest {
    private CSSEngine engine;

    @BeforeEach
    public void setUp() {
        this.engine = ParserTestUtil.createEngine();
    }

    @Test
    void testFloat() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("2.0");
        Assertions.assertTrue((boolean)(value instanceof Measure));
        Assertions.assertEquals((Object)"2.0", (Object)value.getCssText());
    }

    @Test
    void testInt() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("34");
        Assertions.assertTrue((boolean)(value instanceof Measure));
        Assertions.assertEquals((short)1, (short)((Measure)value).getPrimitiveType());
        Assertions.assertEquals((Object)"34", (Object)value.getCssText());
    }

    @Test
    void testIdentifier() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("SomeWord");
        Assertions.assertTrue((boolean)(value instanceof Measure));
        Assertions.assertEquals((short)21, (short)((Measure)value).getPrimitiveType());
        Assertions.assertEquals((Object)"SomeWord", (Object)value.getCssText());
    }

    @Test
    void testPercent() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("30%");
        Assertions.assertTrue((boolean)(value instanceof Measure));
        Assertions.assertEquals((short)2, (short)((Measure)value).getPrimitiveType());
        Assertions.assertEquals((Object)"30.0%", (Object)value.getCssText());
    }

    @Test
    void testPixel() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("26px");
        Assertions.assertTrue((boolean)(value instanceof Measure));
        Assertions.assertEquals((short)5, (short)((Measure)value).getPrimitiveType());
        Assertions.assertEquals((Object)"26.0px", (Object)value.getCssText());
    }

    @Test
    void testInch() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("88in");
        Assertions.assertTrue((boolean)(value instanceof Measure));
        Assertions.assertEquals((short)8, (short)((Measure)value).getPrimitiveType());
        Assertions.assertEquals((Object)"88.0in", (Object)value.getCssText());
    }

    @Test
    void testEm() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("75em");
        Assertions.assertTrue((boolean)(value instanceof Measure));
        Assertions.assertEquals((short)3, (short)((Measure)value).getPrimitiveType());
        Assertions.assertEquals((Object)"75.0em", (Object)value.getCssText());
    }

    @Test
    void testURI() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("url(./somepath/picture.gif)");
        Assertions.assertTrue((boolean)(value instanceof Measure));
        Assertions.assertEquals((short)20, (short)((Measure)value).getPrimitiveType());
        Assertions.assertEquals((Object)"url(./somepath/picture.gif)", (Object)value.getCssText());
    }

    @Test
    void testList() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("34 34 34");
        Assertions.assertTrue((boolean)(value instanceof CSSValueList));
        Assertions.assertEquals((short)2, (short)((CSSValueList)value).getCssValueType());
        Assertions.assertEquals((int)3, (int)((CSSValueList)value).getLength());
        Assertions.assertTrue((boolean)(((CSSValueList)value).item(0) instanceof Measure));
        Assertions.assertEquals((short)1, (short)((Measure)((CSSValueList)value).item(0)).getPrimitiveType());
        Assertions.assertTrue((boolean)(((CSSValueList)value).item(1) instanceof Measure));
        Assertions.assertEquals((short)1, (short)((Measure)((CSSValueList)value).item(1)).getPrimitiveType());
        Assertions.assertTrue((boolean)(((CSSValueList)value).item(2) instanceof Measure));
        Assertions.assertEquals((short)1, (short)((Measure)((CSSValueList)value).item(2)).getPrimitiveType());
        Assertions.assertEquals((Object)"34 34 34", (Object)value.getCssText());
    }

    @Test
    void testCommaSeparatedList() throws Exception {
        CSSValue value = this.engine.parsePropertyValue("34, 34, 34");
        Assertions.assertTrue((boolean)(value instanceof CSSValueList));
        CSSValueList list = (CSSValueList)value;
        Assertions.assertEquals((short)2, (short)list.getCssValueType());
        Assertions.assertEquals((int)5, (int)list.getLength());
        int i = 0;
        while (i < list.getLength()) {
            Assertions.assertTrue((boolean)(list.item(i) instanceof Measure));
            ++i;
        }
        Assertions.assertEquals((short)1, (short)((Measure)list.item(0)).getPrimitiveType());
        Assertions.assertEquals((short)3, (short)((Measure)list.item(1)).getPrimitiveType());
        Assertions.assertEquals((short)1, (short)((Measure)list.item(2)).getPrimitiveType());
        Assertions.assertEquals((short)3, (short)((Measure)list.item(3)).getPrimitiveType());
        Assertions.assertEquals((short)1, (short)((Measure)list.item(4)).getPrimitiveType());
        Assertions.assertTrue((boolean)value.getCssText().matches("34\\s*,\\s*34\\s*,\\s*34"));
    }
}

