/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.genericeditor.extension.tests;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.TargetDefinitionContentAssist;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.osgi.framework.FrameworkUtil;

public abstract class AbstractTargetEditorTest {
    static TargetDefinitionContentAssist contentAssist = new TargetDefinitionContentAssist();
    private IProject project;
    protected File tempFile;

    protected void checkProposals(String[] expectedProposals, ICompletionProposal[] actualProposals, int offset) {
        Assert.assertEquals(Arrays.asList(expectedProposals), AbstractTargetEditorTest.toProposalStrings(actualProposals));
    }

    @Before
    public void setUp() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getClass().getName() + "_" + System.currentTimeMillis());
        this.project.create((IProgressMonitor)new NullProgressMonitor());
        this.project.open((IProgressMonitor)new NullProgressMonitor());
    }

    /*
     * Loose catch block
     */
    protected ITextViewer getTextViewerForTarget(String name) throws Exception {
        IFile targetFile = this.project.getFile(name + ".target");
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            ITextViewer iTextViewer;
            BufferedReader reader;
            InputStream testStream;
            block16: {
                block15: {
                    testStream = FrameworkUtil.getBundle(this.getClass()).getEntry("testing-files/target-files/" + name + ".txt").openStream();
                    reader = new BufferedReader(new InputStreamReader(testStream));
                    String normalizedLineFeeds = reader.lines().collect(Collectors.joining("\n"));
                    ByteArrayInputStream normalizedStream = new ByteArrayInputStream(normalizedLineFeeds.getBytes(StandardCharsets.UTF_8));
                    targetFile.create((InputStream)normalizedStream, true, (IProgressMonitor)new NullProgressMonitor());
                    IEditorPart editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)targetFile, (String)"org.eclipse.ui.genericeditor.GenericEditor");
                    iTextViewer = (ITextViewer)editor.getAdapter(ITextOperationTarget.class);
                    if (reader == null) break block15;
                    reader.close();
                }
                if (testStream == null) break block16;
                testStream.close();
            }
            return iTextViewer;
            {
                catch (Throwable throwable2) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (testStream != null) {
                            testStream.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    protected String getLocationForSite(String name) {
        return FrameworkUtil.getBundle(this.getClass()).getEntry("testing-files/testing-sites/" + name + "/").toString();
    }

    @After
    public void tearDown() throws Exception {
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
        if (this.project != null) {
            this.project.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected String proposalListToString(ICompletionProposal[] proposals) {
        if (proposals == null) {
            return "null";
        }
        return "[" + String.join((CharSequence)",", AbstractTargetEditorTest.toProposalStrings(proposals)) + "]";
    }

    private static List<String> toProposalStrings(ICompletionProposal[] proposals) {
        return Arrays.stream(proposals).map(ICompletionProposal::getDisplayString).toList();
    }

    public static ITextFileBuffer getTextFileBufferFromFile(File file) {
        try {
            IPath path = IPath.fromOSString((String)file.getAbsolutePath());
            ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
            manager.connect(path, LocationKind.LOCATION, null);
            return manager.getTextFileBuffer(path, LocationKind.LOCATION);
        }
        catch (CoreException e) {
            Assert.fail((String)"Unable to retrive target definition file");
            return null;
        }
    }
}

