/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log.test;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.log.ExtendedLogEntry;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.equinox.log.SynchronousLogListener;
import org.eclipse.equinox.log.test.TestListener;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.admin.LoggerAdmin;
import org.osgi.service.log.admin.LoggerContext;

public class ExtendedLogReaderServiceTest {
    private ExtendedLogService log;
    private ServiceReference logReference;
    private ExtendedLogReaderService reader;
    private ServiceReference readerReference;
    private ServiceReference<LoggerAdmin> loggerAdminReference;
    private LoggerAdmin loggerAdmin;
    LoggerContext rootLoggerContext;
    Map<String, LogLevel> rootLogLevels;
    boolean called;

    @Before
    public void setUp() throws Exception {
        this.logReference = OSGiTestsActivator.getContext().getServiceReference(ExtendedLogService.class.getName());
        this.readerReference = OSGiTestsActivator.getContext().getServiceReference(ExtendedLogReaderService.class.getName());
        this.loggerAdminReference = OSGiTestsActivator.getContext().getServiceReference(LoggerAdmin.class);
        this.log = (ExtendedLogService)OSGiTestsActivator.getContext().getService(this.logReference);
        this.reader = (ExtendedLogReaderService)OSGiTestsActivator.getContext().getService(this.readerReference);
        this.loggerAdmin = (LoggerAdmin)OSGiTestsActivator.getContext().getService(this.loggerAdminReference);
        this.rootLoggerContext = this.loggerAdmin.getLoggerContext(null);
        this.rootLogLevels = this.rootLoggerContext.getLogLevels();
        HashMap<String, LogLevel> copyLogLevels = new HashMap<String, LogLevel>(this.rootLogLevels);
        copyLogLevels.put("ROOT", LogLevel.TRACE);
        this.rootLoggerContext.setLogLevels(copyLogLevels);
    }

    @After
    public void tearDown() throws Exception {
        this.rootLoggerContext.setLogLevels(this.rootLogLevels);
        OSGiTestsActivator.getContext().ungetService(this.loggerAdminReference);
        OSGiTestsActivator.getContext().ungetService(this.logReference);
        OSGiTestsActivator.getContext().ungetService(this.readerReference);
    }

    @Test
    public void testaddFilteredListener() throws Exception {
        TestListener listener = new TestListener();
        this.reader.addLogListener((LogListener)listener, (b, loggerName, logLevel) -> true);
        this.log.log(3, "info");
        Assert.assertTrue((listener.getEntryX().getLevel() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testaddNullFilterr() throws Exception {
        TestListener listener = new TestListener();
        try {
            this.reader.addLogListener((LogListener)listener, null);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        Assert.fail();
    }

    @Test
    public void testaddFilteredListenerTwice() throws Exception {
        TestListener listener = new TestListener();
        this.reader.addLogListener((LogListener)listener, (b, loggerName, logLevel) -> false);
        if (this.log.isLoggable(3)) {
            Assert.fail();
        }
        this.reader.addLogListener((LogListener)listener, (b, loggerName, logLevel) -> true);
        this.log.log(3, "info");
        Assert.assertTrue((listener.getEntryX().getLevel() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testaddNullListener() throws Exception {
        try {
            this.reader.addLogListener(null);
        }
        catch (IllegalArgumentException t) {
            return;
        }
        Assert.fail();
    }

    @Test
    public void testBadFilter() throws Exception {
        TestListener listener = new TestListener();
        this.reader.addLogListener((LogListener)listener, (b, loggerName, logLevel) -> {
            throw new RuntimeException("Expected error for testBadFilter.");
        });
        if (this.log.isLoggable(3)) {
            Assert.fail();
        }
    }

    @Test
    public void testSynchronousLogListener() throws Exception {
        Thread loggerThread = Thread.currentThread();
        this.called = false;
        SynchronousLogListener listener = entry -> {
            Assert.assertTrue((Thread.currentThread() == loggerThread ? 1 : 0) != 0);
            this.called = true;
        };
        this.reader.addLogListener((LogListener)listener);
        this.log.log(3, "info");
        Assert.assertTrue((boolean)this.called);
    }

    @Test
    public void testExtendedLogEntry() throws Exception {
        TestListener listener = new TestListener();
        this.reader.addLogListener((LogListener)listener);
        long timeBeforeLog = System.currentTimeMillis();
        String threadName = Thread.currentThread().getName();
        long threadId = this.getCurrentThreadId();
        this.log.getLogger("test").log(this.logReference, 3, "info", new Throwable("test"));
        ExtendedLogEntry entry = listener.getEntryX();
        long sequenceNumberBefore = entry.getSequenceNumber();
        this.log.getLogger("test").log(this.logReference, 3, "info", new Throwable("test"));
        entry = listener.getEntryX();
        Assert.assertTrue((entry.getBundle() == OSGiTestsActivator.getBundle() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)entry.getMessage().equals("info"));
        Assert.assertTrue((boolean)entry.getException().getMessage().equals("test"));
        Assert.assertTrue((entry.getServiceReference() == this.logReference ? 1 : 0) != 0);
        Assert.assertTrue((entry.getTime() >= timeBeforeLog ? 1 : 0) != 0);
        Assert.assertTrue((entry.getLevel() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)entry.getLoggerName().equals("test"));
        Assert.assertTrue((boolean)entry.getThreadName().equals(threadName));
        if (threadId >= 0L) {
            Assert.assertTrue((entry.getThreadId() == threadId ? 1 : 0) != 0);
        }
        Assert.assertTrue((entry.getContext() == this.logReference ? 1 : 0) != 0);
        Assert.assertTrue((entry.getSequenceNumber() > sequenceNumberBefore ? 1 : 0) != 0);
    }

    private long getCurrentThreadId() {
        Thread current = Thread.currentThread();
        try {
            Method getId = Thread.class.getMethod("getId", new Class[0]);
            Long id = (Long)getId.invoke((Object)current, new Object[0]);
            return id;
        }
        catch (Throwable t) {
            return -1L;
        }
    }
}

