/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log.test;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.log.ExtendedLogEntry;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.equinox.log.test.TestListener;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.admin.LoggerAdmin;
import org.osgi.service.log.admin.LoggerContext;

public class ExtendedLogServiceTest {
    private Bundle bundle;
    private ExtendedLogService log;
    private ServiceReference logReference;
    private ExtendedLogReaderService reader;
    private ServiceReference readerReference;
    private ServiceReference<LoggerAdmin> loggerAdminReference;
    private LoggerAdmin loggerAdmin;
    LoggerContext rootLoggerContext;
    Map<String, LogLevel> rootLogLevels;
    private TestListener listener;

    @Before
    public void setUp() throws Exception {
        this.bundle = OSGiTestsActivator.getBundle();
        this.logReference = OSGiTestsActivator.getContext().getServiceReference(ExtendedLogService.class.getName());
        this.readerReference = OSGiTestsActivator.getContext().getServiceReference(ExtendedLogReaderService.class.getName());
        this.loggerAdminReference = OSGiTestsActivator.getContext().getServiceReference(LoggerAdmin.class);
        this.log = (ExtendedLogService)OSGiTestsActivator.getContext().getService(this.logReference);
        this.reader = (ExtendedLogReaderService)OSGiTestsActivator.getContext().getService(this.readerReference);
        this.loggerAdmin = (LoggerAdmin)OSGiTestsActivator.getContext().getService(this.loggerAdminReference);
        this.listener = new TestListener();
        this.reader.addLogListener((LogListener)this.listener);
        this.rootLoggerContext = this.loggerAdmin.getLoggerContext(null);
        this.rootLogLevels = this.rootLoggerContext.getLogLevels();
        HashMap<String, LogLevel> copyLogLevels = new HashMap<String, LogLevel>(this.rootLogLevels);
        copyLogLevels.put("ROOT", LogLevel.TRACE);
        this.rootLoggerContext.setLogLevels(copyLogLevels);
    }

    @After
    public void tearDown() throws Exception {
        this.rootLoggerContext.setLogLevels(this.rootLogLevels);
        this.reader.removeLogListener((LogListener)this.listener);
        OSGiTestsActivator.getContext().ungetService(this.loggerAdminReference);
        OSGiTestsActivator.getContext().ungetService(this.logReference);
        OSGiTestsActivator.getContext().ungetService(this.readerReference);
    }

    @Test
    public void testLogContext() throws Exception {
        this.log.log((Object)this, 3, null);
        Assert.assertTrue((this.listener.getEntryX().getContext() == this ? 1 : 0) != 0);
    }

    @Test
    public void testNullLogContext() throws Exception {
        this.log.log(null, 3, null);
        Assert.assertTrue((this.listener.getEntryX().getContext() == null ? 1 : 0) != 0);
    }

    @Test
    public void testLogContextWithNullThrowable() throws Exception {
        this.log.log((Object)this, 3, null, null);
        Assert.assertTrue((this.listener.getEntryX().getContext() == this ? 1 : 0) != 0);
    }

    @Test
    public void testIsLoggableTrue() throws Exception {
        if (!this.log.isLoggable(3)) {
            Assert.fail();
        }
    }

    @Test
    public void testNotIsLoggableWithNoListener() throws Exception {
        this.reader.removeLogListener((LogListener)this.listener);
        if (this.log.isLoggable(3)) {
            Assert.fail();
        }
    }

    @Test
    public void testNotIsLoggableWithListener() throws Exception {
        this.reader.addLogListener((LogListener)this.listener, (b, loggerName, logLevel) -> false);
        if (this.log.isLoggable(3)) {
            Assert.fail();
        }
    }

    @Test
    public void testNamedLoggerLogNull() throws Exception {
        this.log.getLogger("test").log(null, 0, null, null);
        ExtendedLogEntry entry = this.listener.getEntryX();
        Assert.assertTrue((entry.getLoggerName() == "test" ? 1 : 0) != 0);
        Assert.assertTrue((entry.getLevel() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((entry.getMessage() == null ? 1 : 0) != 0);
        Assert.assertTrue((entry.getException() == null ? 1 : 0) != 0);
        Assert.assertTrue((entry.getServiceReference() == null ? 1 : 0) != 0);
    }

    @Test
    public void testNullLoggerLogNull() throws Exception {
        this.log.getLogger(null).log(null, 0, null, null);
        ExtendedLogEntry entry = this.listener.getEntryX();
        Assert.assertEquals((String)"Wrong logger name.", (Object)("LogService." + this.bundle.getSymbolicName()), (Object)entry.getLoggerName());
        Assert.assertTrue((entry.getLevel() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((entry.getMessage() == null ? 1 : 0) != 0);
        Assert.assertTrue((entry.getException() == null ? 1 : 0) != 0);
        Assert.assertTrue((entry.getServiceReference() == null ? 1 : 0) != 0);
    }

    @Test
    public void testNamedLoggerLogFull() throws Exception {
        String message = "test";
        Throwable t = new Throwable("test");
        this.log.getLogger("test").log(this.logReference, 3, message, t);
        ExtendedLogEntry entry = this.listener.getEntryX();
        Assert.assertTrue((entry.getLoggerName() == "test" ? 1 : 0) != 0);
        Assert.assertTrue((entry.getBundle() == this.bundle ? 1 : 0) != 0);
        Assert.assertTrue((entry.getLevel() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)entry.getMessage().equals(message));
        Assert.assertTrue((boolean)entry.getException().getMessage().equals(t.getMessage()));
        Assert.assertTrue((entry.getServiceReference() == this.logReference ? 1 : 0) != 0);
    }

    @Test
    public void testNamedLoggerLogFullWithNullBundle() throws Exception {
        String message = "test";
        Throwable t = new Throwable("test");
        this.log.getLogger(null, "test").log(this.logReference, 3, message, t);
        ExtendedLogEntry entry = this.listener.getEntryX();
        Assert.assertTrue((entry.getLoggerName() == "test" ? 1 : 0) != 0);
        Assert.assertTrue((entry.getBundle() == this.bundle ? 1 : 0) != 0);
        Assert.assertTrue((entry.getLevel() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)entry.getMessage().equals(message));
        Assert.assertTrue((boolean)entry.getException().getMessage().equals(t.getMessage()));
        Assert.assertTrue((entry.getServiceReference() == this.logReference ? 1 : 0) != 0);
    }

    @Test
    public void testNamedLoggerLogFullWithBundle() throws Exception {
        String message = "test";
        Throwable t = new Throwable("test");
        this.log.getLogger(this.bundle, "test").log(this.logReference, 3, message, t);
        ExtendedLogEntry entry = this.listener.getEntryX();
        Assert.assertTrue((entry.getLoggerName() == "test" ? 1 : 0) != 0);
        Assert.assertTrue((entry.getBundle() == this.bundle ? 1 : 0) != 0);
        Assert.assertTrue((entry.getLevel() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)entry.getMessage().equals(message));
        Assert.assertTrue((boolean)entry.getException().getMessage().equals(t.getMessage()));
        Assert.assertTrue((entry.getServiceReference() == this.logReference ? 1 : 0) != 0);
    }

    @Test
    public void testLoggerIsLoggableTrue() throws Exception {
        this.reader.addLogListener((LogListener)this.listener, (b, loggerName, logLevel) -> loggerName.equals("test"));
        if (!this.log.getLogger("test").isLoggable(3)) {
            Assert.fail();
        }
    }

    @Test
    public void testLoggerNotIsLoggableWithListener() throws Exception {
        this.reader.addLogListener((LogListener)this.listener, (b, loggerName, logLevel) -> !loggerName.equals("test"));
        if (this.log.getLogger("test").isLoggable(3)) {
            Assert.fail();
        }
    }
}

