/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log.test;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.log.SynchronousLogListener;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.bundles.SystemBundleTests;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.condition.Condition;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.admin.LoggerAdmin;
import org.osgi.service.log.admin.LoggerContext;
import org.osgi.service.startlevel.StartLevel;

public class LogEquinoxTraceTest
extends AbstractBundleTests {
    private LoggerAdmin loggerAdmin = null;
    private TestListener testListener = null;
    private Equinox equinox = null;
    private DebugOptions debugOptions = null;

    @Override
    public void setUp() throws Exception {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        this.equinox = new Equinox(configuration);
        this.equinox.start();
        this.loggerAdmin = (LoggerAdmin)this.equinox.getBundleContext().getService(this.equinox.getBundleContext().getServiceReference(LoggerAdmin.class));
        LogReaderService logReader = (LogReaderService)this.equinox.getBundleContext().getService(this.equinox.getBundleContext().getServiceReference(LogReaderService.class));
        this.testListener = new TestListener();
        logReader.addLogListener((LogListener)this.testListener);
        BundleContext systemContext = this.equinox.getBundleContext();
        this.debugOptions = (DebugOptions)systemContext.getService(systemContext.getServiceReference(DebugOptions.class));
    }

    @Override
    public void tearDown() {
        if (this.equinox != null) {
            try {
                this.equinox.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    public void testEnableRootLoggerContextTrace() {
        this.doTestEnableTrace(null);
    }

    @Test
    public void testEnableFrameworkLoggerContextTrace() {
        this.doTestEnableTrace(this.equinox.getBundleContext().getBundle().getSymbolicName());
    }

    private void doTestEnableTrace(String loggerContextName) {
        Assert.assertFalse((String)"Expected debug options to be disabled.", (boolean)this.debugOptions.isDebugEnabled());
        Assert.assertEquals((String)"Expected no debug Options.", (long)0L, (long)this.debugOptions.getOptions().size());
        LoggerContext rootContext = this.loggerAdmin.getLoggerContext(loggerContextName);
        Map rootLogLevels = rootContext.getLogLevels();
        rootLogLevels.put("EQUINOX.TRACE", LogLevel.TRACE);
        rootLogLevels.put("org.eclipse.osgi/debug/services", LogLevel.TRACE);
        rootContext.setLogLevels(rootLogLevels);
        Assert.assertTrue((String)"Expected debug to be enabled.", (boolean)this.debugOptions.isDebugEnabled());
        Assert.assertEquals((String)"Expected 1 debug Option.", (long)1L, (long)this.debugOptions.getOptions().size());
        Assert.assertTrue((String)"Expected trace option to be enabled.", (boolean)this.debugOptions.getBooleanOption("org.eclipse.osgi/debug/services", false));
        Assert.assertFalse((String)"Expected trace option to be disabled.", (boolean)this.debugOptions.getBooleanOption("org.eclipse.osgi/debug/startlevel", false));
        ServiceReference ref = this.equinox.getBundleContext().getServiceReference(StartLevel.class);
        List<LogEntry> traceLogs = this.testListener.getLogs();
        Assert.assertNotEquals((String)"Expected to have some trace logs.", (long)0L, (long)traceLogs.size());
        for (LogEntry logEntry : traceLogs) {
            Assert.assertEquals((String)"Wrong logger name", (Object)"org.eclipse.osgi/debug/services", (Object)logEntry.getLoggerName());
        }
        rootLogLevels.remove("org.eclipse.osgi/debug/services");
        rootLogLevels.put("org.eclipse.osgi/debug/startlevel", LogLevel.TRACE);
        rootContext.setLogLevels(rootLogLevels);
        Assert.assertTrue((String)"Expected debug to be enabled.", (boolean)this.debugOptions.isDebugEnabled());
        Assert.assertEquals((String)"Expected 1 debug Option.", (long)1L, (long)this.debugOptions.getOptions().size());
        Assert.assertTrue((String)"Expected trace option to be enabled.", (boolean)this.debugOptions.getBooleanOption("org.eclipse.osgi/debug/startlevel", false));
        Assert.assertFalse((String)"Expected trace option to be disabled.", (boolean)this.debugOptions.getBooleanOption("org.eclipse.osgi/debug/services", false));
        StartLevel startLevel = (StartLevel)this.equinox.getBundleContext().getService(ref);
        startLevel.setStartLevel(20);
        traceLogs = this.testListener.getLogs();
        Assert.assertNotEquals((String)"Expected to have some trace logs.", (long)0L, (long)traceLogs.size());
        for (LogEntry logEntry : traceLogs) {
            Assert.assertEquals((String)"Wrong logger name", (Object)"org.eclipse.osgi/debug/startlevel", (Object)logEntry.getLoggerName());
        }
        rootLogLevels.put("EQUINOX.TRACE", LogLevel.AUDIT);
        rootContext.setLogLevels(rootLogLevels);
        Assert.assertFalse((String)"Expected debug to be disabled.", (boolean)this.debugOptions.isDebugEnabled());
        Assert.assertEquals((String)"Expected no debug Options.", (long)0L, (long)this.debugOptions.getOptions().size());
    }

    @Test
    public void testRootLoggerNameTrace() {
        LoggerContext rootContext = this.loggerAdmin.getLoggerContext(null);
        Map rootLogLevels = rootContext.getLogLevels();
        rootLogLevels.put("ROOT", LogLevel.TRACE);
        rootLogLevels.put("EQUINOX.TRACE", LogLevel.TRACE);
        rootLogLevels.put("org.eclipse.osgi/debug/startlevel", LogLevel.TRACE);
        rootContext.setLogLevels(rootLogLevels);
        this.equinox.getBundleContext().getServiceReference(Condition.class);
        List<LogEntry> traceLogs = this.testListener.getLogs();
        Assert.assertEquals((String)"Expected to have no trace logs.", (long)0L, (long)traceLogs.size());
    }

    @Test
    public void testSeparateLoggerContext() throws IOException, BundleException {
        File baseBundlesDir = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-ManifestVersion", "2");
        headers.put("Bundle-SymbolicName", this.getName());
        baseBundlesDir.mkdirs();
        File bundleFile = SystemBundleTests.createBundle(baseBundlesDir, this.getName(), headers, new Map[0]);
        Bundle b = this.equinox.getBundleContext().installBundle(bundleFile.toURI().toASCIIString());
        LoggerContext testBundleLoggerContext = this.loggerAdmin.getLoggerContext(b.getSymbolicName());
        Map testBundleLogLevels = testBundleLoggerContext.getLogLevels();
        testBundleLogLevels.put("EQUINOX.TRACE", LogLevel.TRACE);
        testBundleLogLevels.put("org.eclipse.osgi/debug/services", LogLevel.TRACE);
        testBundleLoggerContext.setLogLevels(testBundleLogLevels);
        Assert.assertFalse((String)"Expected debug to be disabled.", (boolean)this.debugOptions.isDebugEnabled());
        Assert.assertEquals((String)"Expected no debug Options.", (long)0L, (long)this.debugOptions.getOptions().size());
        ServiceReference ref = this.equinox.getBundleContext().getServiceReference(StartLevel.class);
        List<LogEntry> traceLogs = this.testListener.getLogs();
        Assert.assertEquals((String)"Expected to have no trace logs.", (long)0L, (long)traceLogs.size());
    }

    static class TestListener
    implements SynchronousLogListener {
        List<LogEntry> logs = new ArrayList<LogEntry>();

        TestListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void logged(LogEntry entry) {
            List<LogEntry> list = this.logs;
            synchronized (list) {
                Bundle b = entry.getBundle();
                if (b != null && b.getBundleId() == 0L) {
                    this.logs.add(entry);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<LogEntry> getLogs() {
            List<LogEntry> list = this.logs;
            synchronized (list) {
                ArrayList<LogEntry> results = new ArrayList<LogEntry>(this.logs);
                this.logs.clear();
                System.out.println("DEBUG TEST LOGS: count=" + results.size());
                results.stream().forEach(l -> System.out.println("   DEBUG TEST LOG: " + l.getMessage()));
                return results;
            }
        }
    }
}

