/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log.test;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.equinox.log.ExtendedLogEntry;
import org.eclipse.equinox.log.SynchronousLogListener;
import org.eclipse.equinox.log.test.TestListener;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;
import org.osgi.service.log.admin.LoggerAdmin;
import org.osgi.service.log.admin.LoggerContext;

public class LogReaderServiceTest
extends AbstractBundleTests {
    private LogService log;
    private ServiceReference logReference;
    private LogReaderService reader;
    private ServiceReference readerReference;
    private ServiceReference<LoggerAdmin> loggerAdminReference;
    private LoggerAdmin loggerAdmin;
    LoggerContext rootLoggerContext;
    Map<String, LogLevel> rootLogLevels;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.logReference = OSGiTestsActivator.getContext().getServiceReference(LogService.class.getName());
        this.readerReference = OSGiTestsActivator.getContext().getServiceReference(LogReaderService.class.getName());
        this.loggerAdminReference = OSGiTestsActivator.getContext().getServiceReference(LoggerAdmin.class);
        this.log = (LogService)OSGiTestsActivator.getContext().getService(this.logReference);
        this.reader = (LogReaderService)OSGiTestsActivator.getContext().getService(this.readerReference);
        this.loggerAdmin = (LoggerAdmin)OSGiTestsActivator.getContext().getService(this.loggerAdminReference);
        this.rootLoggerContext = this.loggerAdmin.getLoggerContext(null);
        this.rootLogLevels = this.rootLoggerContext.getLogLevels();
        HashMap<String, LogLevel> copyLogLevels = new HashMap<String, LogLevel>(this.rootLogLevels);
        copyLogLevels.put("ROOT", LogLevel.TRACE);
        this.rootLoggerContext.setLogLevels(copyLogLevels);
    }

    @Override
    public void tearDown() throws Exception {
        this.rootLoggerContext.setLogLevels(this.rootLogLevels);
        OSGiTestsActivator.getContext().ungetService(this.loggerAdminReference);
        OSGiTestsActivator.getContext().ungetService(this.logReference);
        OSGiTestsActivator.getContext().ungetService(this.readerReference);
        super.tearDown();
    }

    @Test
    public void testaddListener() throws Exception {
        TestListener listener = new TestListener();
        this.reader.addLogListener((LogListener)listener);
        this.log.log(3, "info");
        Assert.assertTrue((listener.getEntryX().getLevel() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testaddListenerTwice() throws Exception {
        TestListener listener = new TestListener();
        this.reader.addLogListener((LogListener)listener);
        this.reader.addLogListener((LogListener)listener);
        this.log.log(3, "info");
        Assert.assertTrue((listener.getEntryX().getLevel() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testaddNullListener() throws Exception {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.reader.addLogListener(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBadListener() throws Exception {
        LogListener listener = new LogListener(){

            public synchronized void logged(LogEntry entry) {
                this.notifyAll();
                throw new RuntimeException("Expected error for testBadListener.");
            }
        };
        this.reader.addLogListener(listener);
        LogListener logListener = listener;
        synchronized (logListener) {
            this.log.log(3, "info");
            listener.wait();
        }
    }

    @Test
    public void testLogEntry() throws Exception {
        TestListener listener = new TestListener();
        this.reader.addLogListener((LogListener)listener);
        long timeBeforeLog = System.currentTimeMillis();
        this.log.log(this.logReference, 3, "info", new Throwable("test"));
        ExtendedLogEntry entry = listener.getEntryX();
        Assert.assertTrue((entry.getBundle() == OSGiTestsActivator.getBundle() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)entry.getMessage().equals("info"));
        Assert.assertTrue((boolean)entry.getException().getMessage().equals("test"));
        Assert.assertTrue((entry.getServiceReference() == this.logReference ? 1 : 0) != 0);
        Assert.assertTrue((entry.getTime() >= timeBeforeLog ? 1 : 0) != 0);
        Assert.assertTrue((entry.getLevel() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testLogBundleEventInfo() throws Exception {
        Bundle testBundle = installer.installBundle("test.logging.a");
        TestListener listener = new TestListener(testBundle.getLocation());
        this.reader.addLogListener((LogListener)listener);
        testBundle.start();
        ExtendedLogEntry entry = listener.getEntryX();
        Assert.assertTrue((entry.getLevel() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Wrong level.", (Object)LogLevel.INFO, (Object)entry.getLogLevel());
        Assert.assertTrue((String)("Wrong context: " + String.valueOf(entry.getContext())), (boolean)(entry.getContext() instanceof BundleEvent));
    }

    @Test
    public void testLogBundleEventSynchronous() throws Exception {
        Bundle testBundle = installer.installBundle("test.logging.a");
        AtomicReference logThread = new AtomicReference();
        SynchronousLogListener listener = entry -> {
            if (entry.getBundle() == testBundle) {
                logThread.compareAndSet(null, Thread.currentThread());
            }
        };
        this.reader.addLogListener((LogListener)listener);
        testBundle.start();
        Assert.assertEquals((String)"Wrong thread for synchronous bundle event logs.", (Object)Thread.currentThread(), logThread.get());
    }

    @Test
    public void testLogServiceEventInfo() throws Exception {
        TestListener listener = new TestListener();
        this.reader.addLogListener((LogListener)listener);
        OSGiTestsActivator.getContext().registerService(Object.class.getName(), new Object(), null);
        ExtendedLogEntry entry = listener.getEntryX();
        Assert.assertTrue((entry.getLevel() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Wrong level.", (Object)LogLevel.INFO, (Object)entry.getLogLevel());
        Assert.assertTrue((String)("Wrong context: " + String.valueOf(entry.getContext())), (boolean)(entry.getContext() instanceof ServiceEvent));
    }

    @Test
    public void testLogServiceEventDebug() throws Exception {
        ServiceRegistration registration = OSGiTestsActivator.getContext().registerService(Object.class.getName(), new Object(), null);
        TestListener listener = new TestListener();
        this.reader.addLogListener((LogListener)listener);
        registration.setProperties(new Hashtable());
        ExtendedLogEntry entry = listener.getEntryX();
        Assert.assertTrue((entry.getLevel() == 4 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Wrong level.", (Object)LogLevel.DEBUG, (Object)entry.getLogLevel());
        Assert.assertTrue((String)("Wrong context: " + String.valueOf(entry.getContext())), (boolean)(entry.getContext() instanceof ServiceEvent));
    }

    @Test
    public void testLogFrameworkEvent() throws Exception {
        Bundle testBundle = installer.installBundle("test.logging.a");
        AtomicReference logEntry = new AtomicReference();
        CountDownLatch countDown = new CountDownLatch(1);
        LogListener listener = entry -> {
            if (entry.getLoggerName().startsWith("Events.Framework.")) {
                logEntry.set(entry);
                countDown.countDown();
            }
        };
        this.reader.addLogListener(listener);
        installer.refreshPackages(new Bundle[]{testBundle});
        countDown.await(5L, TimeUnit.SECONDS);
        ExtendedLogEntry entry2 = (ExtendedLogEntry)logEntry.get();
        Assert.assertNotNull((String)"Framework event not logged", (Object)entry2);
        Assert.assertTrue((entry2.getLevel() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Wrong level.", (Object)LogLevel.INFO, (Object)entry2.getLogLevel());
        Assert.assertTrue((String)("Wrong context: " + String.valueOf(entry2.getContext())), (boolean)(entry2.getContext() instanceof FrameworkEvent));
        Assert.assertEquals((String)"Wrong bundle.", (Object)this.getContext().getBundle("System Bundle"), (Object)entry2.getBundle());
        Assert.assertEquals((String)"Wrong logger name.", (Object)("Events.Framework." + entry2.getBundle().getSymbolicName()), (Object)entry2.getLoggerName());
    }

    @Test
    public void testLogFrameworkEventType() throws Exception {
        CopyOnWriteArrayList events = new CopyOnWriteArrayList();
        CountDownLatch countDown = new CountDownLatch(3);
        Bundle b = this.getContext().getBundle();
        LogListener listener = entry -> {
            if (b.equals(entry.getBundle())) {
                events.add(entry);
                countDown.countDown();
            }
        };
        this.reader.addLogListener(listener);
        ((Module)b.adapt(Module.class)).getContainer().getAdaptor().publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.ERROR, (Module)b.adapt(Module.class), (Throwable)new Exception(), new FrameworkListener[0]);
        ((Module)b.adapt(Module.class)).getContainer().getAdaptor().publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.WARNING, (Module)b.adapt(Module.class), (Throwable)new Exception(), new FrameworkListener[0]);
        ((Module)b.adapt(Module.class)).getContainer().getAdaptor().publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.INFO, (Module)b.adapt(Module.class), (Throwable)new Exception(), new FrameworkListener[0]);
        countDown.await(2L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"Wrong number of events", (long)3L, (long)events.size());
        Assert.assertEquals((String)"Wrong type.", (Object)LogLevel.ERROR, (Object)((LogEntry)events.get(0)).getLogLevel());
        Assert.assertEquals((String)"Wrong type.", (Object)LogLevel.WARN, (Object)((LogEntry)events.get(1)).getLogLevel());
        Assert.assertEquals((String)"Wrong type.", (Object)LogLevel.INFO, (Object)((LogEntry)events.get(2)).getLogLevel());
    }

    @Test
    public void testLogHistory1() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("equinox.log.history.max", "10");
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        try {
            LogService testLog = (LogService)equinox.getBundleContext().getService(equinox.getBundleContext().getServiceReference(LogService.class));
            LogReaderService testReader = (LogReaderService)equinox.getBundleContext().getService(equinox.getBundleContext().getServiceReference(LogReaderService.class));
            Assert.assertEquals((String)"Expecting no logs.", (long)0L, (long)this.countLogEntries(testReader.getLog(), 0));
            int i = 0;
            while (i < 9) {
                testLog.log(2, String.valueOf(i));
                ++i;
            }
            Assert.assertEquals((String)"Wrong number of logs.", (long)9L, (long)this.countLogEntries(testReader.getLog(), 8));
            i = 9;
            while (i < 18) {
                testLog.log(2, String.valueOf(i));
                ++i;
            }
            Assert.assertEquals((String)"Wrong number of logs.", (long)10L, (long)this.countLogEntries(testReader.getLog(), 17));
        }
        finally {
            try {
                equinox.stop();
            }
            catch (BundleException bundleException) {}
        }
    }

    @Test
    public void testLogHistory2() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        try {
            LogService testLog = (LogService)equinox.getBundleContext().getService(equinox.getBundleContext().getServiceReference(LogService.class));
            LogReaderService testReader = (LogReaderService)equinox.getBundleContext().getService(equinox.getBundleContext().getServiceReference(LogReaderService.class));
            Assert.assertEquals((String)"Expecting no logs.", (long)0L, (long)this.countLogEntries(testReader.getLog(), 0));
            int i = 0;
            while (i < 9) {
                testLog.log(2, String.valueOf(i));
                ++i;
            }
            Assert.assertEquals((String)"Wrong number of logs.", (long)0L, (long)this.countLogEntries(testReader.getLog(), 0));
        }
        finally {
            try {
                equinox.stop();
            }
            catch (BundleException bundleException) {}
        }
    }

    private int countLogEntries(Enumeration logEntries, int startingMessage) {
        int count = 0;
        while (logEntries.hasMoreElements()) {
            LogEntry entry = (LogEntry)logEntries.nextElement();
            Assert.assertEquals((String)"Wrong log message.", (Object)String.valueOf(startingMessage), (Object)entry.getMessage());
            --startingMessage;
            ++count;
        }
        return count;
    }

    @Test
    public void testLoggerContextSetLogLevelsWithBundleInstalledAndLogger() throws Exception {
        Bundle bundle = null;
        String loggerName = "test.logger";
        try {
            bundle = installer.installBundle("test.logging.a");
            bundle.start();
            Logger logger = this.log.getLogger(bundle, loggerName, Logger.class);
            Assert.assertNotNull((String)"Logger cannot be null", (Object)logger);
            this.setAndAssertLogLevel(bundle.getSymbolicName(), loggerName);
            TestListener listener = new TestListener(bundle.getLocation());
            this.reader.addLogListener((LogListener)listener);
            LogLevel[] logLevelArray = LogLevel.values();
            int n = logLevelArray.length;
            int n2 = 0;
            while (n2 < n) {
                LogLevel logLevel = logLevelArray[n2];
                String message = logLevel.name() + " MESSAGE";
                this.doLogging(bundle, logger, listener, logLevel, message);
                ++n2;
            }
        }
        finally {
            if (bundle != null) {
                bundle.stop();
                bundle.uninstall();
            }
        }
    }

    @Test
    public void testLoggerContextSetLogLevelsWithBundleInstalledAndNoLogger() throws Exception {
        Bundle bundle = null;
        String loggerName = "test.logger";
        try {
            bundle = installer.installBundle("test.logging.a");
            bundle.start();
            this.setAndAssertLogLevel(bundle.getSymbolicName(), loggerName);
            Logger logger = this.log.getLogger(bundle, loggerName, Logger.class);
            Assert.assertNotNull((String)"Logger cannot be null", (Object)logger);
            TestListener listener = new TestListener(bundle.getLocation());
            this.reader.addLogListener((LogListener)listener);
            LogLevel[] logLevelArray = LogLevel.values();
            int n = logLevelArray.length;
            int n2 = 0;
            while (n2 < n) {
                LogLevel logLevel = logLevelArray[n2];
                String message = logLevel.name() + " MESSAGE";
                this.doLogging(bundle, logger, listener, logLevel, message);
                ++n2;
            }
        }
        finally {
            if (bundle != null) {
                bundle.stop();
                bundle.uninstall();
            }
        }
    }

    @Test
    public void testLoggerContextSetLogLevelsWithoutBundleAndLogger() throws Exception {
        Bundle bundle = null;
        String loggerName = "test.logger";
        this.setAndAssertLogLevel("test.logging.a", loggerName);
        try {
            bundle = installer.installBundle("test.logging.a");
            bundle.start();
            Logger logger = this.log.getLogger(bundle, loggerName, Logger.class);
            Assert.assertNotNull((String)"Logger cannot be null", (Object)logger);
            TestListener listener = new TestListener(bundle.getLocation());
            this.reader.addLogListener((LogListener)listener);
            LogLevel[] logLevelArray = LogLevel.values();
            int n = logLevelArray.length;
            int n2 = 0;
            while (n2 < n) {
                LogLevel logLevel = logLevelArray[n2];
                String message = logLevel.name() + " MESSAGE";
                this.doLogging(bundle, logger, listener, logLevel, message);
                ++n2;
            }
        }
        finally {
            if (bundle != null) {
                bundle.stop();
                bundle.uninstall();
            }
        }
    }

    private void setAndAssertLogLevel(String loggerContextName, String loggerName) {
        LoggerContext loggerContext = this.loggerAdmin.getLoggerContext(loggerContextName);
        Map logLevels = loggerContext.getLogLevels();
        logLevels.put(loggerName, LogLevel.TRACE);
        loggerContext.setLogLevels(logLevels);
        Assert.assertEquals((String)("Log levels not set for " + loggerContext.getName()), (Object)logLevels, (Object)loggerContext.getLogLevels());
        Assert.assertEquals((String)"Wrong effective level", (Object)LogLevel.TRACE, (Object)loggerContext.getEffectiveLogLevel(loggerName));
    }

    private void doLogging(Bundle bundle, Logger logger, TestListener listener, LogLevel logLevel, String message) throws Exception {
        this.logToLogger(logger, message, logLevel);
        ExtendedLogEntry logEntry = listener.getEntryX();
        Assert.assertEquals((String)"Wrong message logged", (Object)message, (Object)logEntry.getMessage());
        Assert.assertEquals((String)"Wrong Log level", (Object)logLevel, (Object)logEntry.getLogLevel());
        Assert.assertEquals((String)"Wrong Logger name", (Object)logger.getName(), (Object)logEntry.getLoggerName());
        Assert.assertEquals((String)"Wrong bundle", (Object)bundle.getSymbolicName(), (Object)logEntry.getBundle().getSymbolicName());
    }

    private void logToLogger(Logger logger, String message, LogLevel logLevel) {
        switch (logLevel) {
            case AUDIT: {
                logger.audit(message);
                break;
            }
            case ERROR: {
                logger.error(message);
                break;
            }
            case WARN: {
                logger.warn(message);
                break;
            }
            case INFO: {
                logger.info(message);
                break;
            }
            case DEBUG: {
                logger.debug(message);
                break;
            }
            case TRACE: {
                logger.trace(message);
                break;
            }
            default: {
                Assert.fail((String)"Unknown Log level");
            }
        }
    }

    @Test
    public void testBundleEventsLogged() throws Exception {
        String testBundleLoc = installer.getBundleLocation("test.logging.a");
        TestListener listener = new TestListener(testBundleLoc);
        this.reader.addLogListener((LogListener)listener);
        Bundle bundle = installer.installBundle("test.logging.a");
        bundle.start();
        bundle.stop();
        bundle.update();
        bundle.start();
        bundle.stop();
        bundle.uninstall();
        this.assertBundleEventLog("BundleEvent INSTALLED", bundle, listener);
        this.assertBundleEventLog("BundleEvent RESOLVED", bundle, listener);
        this.assertBundleEventLog("BundleEvent STARTING", bundle, listener);
        this.assertBundleEventLog("BundleEvent STARTED", bundle, listener);
        this.assertBundleEventLog("BundleEvent STOPPING", bundle, listener);
        this.assertBundleEventLog("BundleEvent STOPPED", bundle, listener);
        this.assertBundleEventLog("BundleEvent UNRESOLVED", bundle, listener);
        this.assertBundleEventLog("BundleEvent UPDATED", bundle, listener);
        this.assertBundleEventLog("BundleEvent RESOLVED", bundle, listener);
        this.assertBundleEventLog("BundleEvent STARTING", bundle, listener);
        this.assertBundleEventLog("BundleEvent STARTED", bundle, listener);
        this.assertBundleEventLog("BundleEvent STOPPING", bundle, listener);
        this.assertBundleEventLog("BundleEvent STOPPED", bundle, listener);
        this.assertBundleEventLog("BundleEvent UNRESOLVED", bundle, listener);
        this.assertBundleEventLog("BundleEvent UNINSTALLED", bundle, listener);
    }

    private void assertBundleEventLog(String message, Bundle bundle, TestListener listener) throws InterruptedException {
        ExtendedLogEntry logEntry = listener.getEntryX();
        Assert.assertEquals((String)"Wrong message.", (Object)message, (Object)logEntry.getMessage());
        Assert.assertEquals((String)"Wrong bundle.", (Object)bundle, (Object)logEntry.getBundle());
        Assert.assertEquals((String)"Wrong logger name.", (Object)("Events.Bundle." + bundle.getSymbolicName()), (Object)logEntry.getLoggerName());
    }
}

