/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log.test;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.equinox.log.ExtendedLogEntry;
import org.eclipse.equinox.log.test.TestListener;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.LogService;
import org.osgi.service.log.admin.LoggerAdmin;
import org.osgi.service.log.admin.LoggerContext;

public class LogServiceTest {
    private LogService log;
    private ServiceReference logReference;
    private LogReaderService reader;
    private ServiceReference readerReference;
    private TestListener listener;
    private ServiceReference<LoggerAdmin> loggerAdminReference;
    private LoggerAdmin loggerAdmin;
    LoggerContext rootLoggerContext;
    Map<String, LogLevel> rootLogLevels;

    @Before
    public void setUp() throws Exception {
        this.logReference = OSGiTestsActivator.getContext().getServiceReference(LogService.class.getName());
        this.readerReference = OSGiTestsActivator.getContext().getServiceReference(LogReaderService.class.getName());
        this.loggerAdminReference = OSGiTestsActivator.getContext().getServiceReference(LoggerAdmin.class);
        this.log = (LogService)OSGiTestsActivator.getContext().getService(this.logReference);
        this.reader = (LogReaderService)OSGiTestsActivator.getContext().getService(this.readerReference);
        this.loggerAdmin = (LoggerAdmin)OSGiTestsActivator.getContext().getService(this.loggerAdminReference);
        this.listener = new TestListener();
        this.reader.addLogListener((LogListener)this.listener);
        this.rootLoggerContext = this.loggerAdmin.getLoggerContext(null);
        this.rootLogLevels = this.rootLoggerContext.getLogLevels();
        HashMap<String, LogLevel> copyLogLevels = new HashMap<String, LogLevel>(this.rootLogLevels);
        copyLogLevels.put("ROOT", LogLevel.TRACE);
        this.rootLoggerContext.setLogLevels(copyLogLevels);
    }

    @After
    public void tearDown() throws Exception {
        this.rootLoggerContext.setLogLevels(this.rootLogLevels);
        this.reader.removeLogListener((LogListener)this.listener);
        OSGiTestsActivator.getContext().ungetService(this.loggerAdminReference);
        OSGiTestsActivator.getContext().ungetService(this.logReference);
        OSGiTestsActivator.getContext().ungetService(this.readerReference);
    }

    @Test
    public void testLogDebug() throws Exception {
        this.log.log(4, "debug");
        Assert.assertTrue((this.listener.getEntryX().getLevel() == 4 ? 1 : 0) != 0);
    }

    @Test
    public void testLogError() throws Exception {
        this.log.log(1, "error");
        Assert.assertTrue((this.listener.getEntryX().getLevel() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testLogInfo() throws Exception {
        this.log.log(3, "info");
        Assert.assertTrue((this.listener.getEntryX().getLevel() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testLogWarning() throws Exception {
        this.log.log(2, "warning");
        Assert.assertTrue((this.listener.getEntryX().getLevel() == 2 ? 1 : 0) != 0);
    }

    public void testLogZeroLevel() throws Exception {
        this.log.log(0, "zero");
        Assert.assertTrue((this.listener.getEntryX().getLevel() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLogNegativeLevel() throws Exception {
        this.log.log(-1, "negative");
        Assert.assertTrue((this.listener.getEntryX().getLevel() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLogMessage() throws Exception {
        this.log.log(3, "message");
        Assert.assertTrue((boolean)this.listener.getEntryX().getMessage().equals("message"));
    }

    @Test
    public void testLogNullMessage() throws Exception {
        this.log.log(3, null);
        Assert.assertTrue((this.listener.getEntryX().getMessage() == null ? 1 : 0) != 0);
    }

    @Test
    public void testLogThrowable() throws Exception {
        Throwable t = new Throwable("throwable");
        this.log.log(3, null, t);
        Assert.assertTrue((boolean)this.listener.getEntryX().getException().getMessage().equals(t.getMessage()));
    }

    @Test
    public void testLogNullThrowable() throws Exception {
        this.log.log(3, null, null);
        Assert.assertTrue((this.listener.getEntryX().getException() == null ? 1 : 0) != 0);
    }

    @Test
    public void testLogServiceReference() throws Exception {
        this.log.log(this.logReference, 3, null);
        Assert.assertTrue((boolean)this.listener.getEntryX().getServiceReference().equals(this.logReference));
    }

    @Test
    public void testNullLogServiceReference() throws Exception {
        this.log.log(null, 3, null);
        Assert.assertTrue((this.listener.getEntryX().getServiceReference() == null ? 1 : 0) != 0);
    }

    @Test
    public void testLogServiceReferenceWithNullThrowable() throws Exception {
        this.log.log(this.logReference, 3, null, null);
        Assert.assertTrue((boolean)this.listener.getEntryX().getServiceReference().equals(this.logReference));
    }

    @Test
    public void testLogNull1() throws Exception {
        this.log.log(0, null);
        ExtendedLogEntry entry = this.listener.getEntryX();
        Assert.assertTrue((entry.getLevel() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((entry.getMessage() == null ? 1 : 0) != 0);
        Assert.assertTrue((entry.getException() == null ? 1 : 0) != 0);
        Assert.assertTrue((entry.getServiceReference() == null ? 1 : 0) != 0);
    }

    @Test
    public void testLogNull2() throws Exception {
        this.log.log(0, null, null);
        ExtendedLogEntry entry = this.listener.getEntryX();
        Assert.assertTrue((entry.getLevel() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((entry.getMessage() == null ? 1 : 0) != 0);
        Assert.assertTrue((entry.getException() == null ? 1 : 0) != 0);
        Assert.assertTrue((entry.getServiceReference() == null ? 1 : 0) != 0);
    }

    @Test
    public void testLogNull3() throws Exception {
        this.log.log(null, 0, null);
        ExtendedLogEntry entry = this.listener.getEntryX();
        Assert.assertTrue((entry.getLevel() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((entry.getMessage() == null ? 1 : 0) != 0);
        Assert.assertTrue((entry.getException() == null ? 1 : 0) != 0);
        Assert.assertTrue((entry.getServiceReference() == null ? 1 : 0) != 0);
    }

    @Test
    public void testLogNull4() throws Exception {
        this.log.log(null, 0, null, null);
        ExtendedLogEntry entry = this.listener.getEntryX();
        Assert.assertTrue((entry.getLevel() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((entry.getMessage() == null ? 1 : 0) != 0);
        Assert.assertTrue((entry.getException() == null ? 1 : 0) != 0);
        Assert.assertTrue((entry.getServiceReference() == null ? 1 : 0) != 0);
    }

    @Test
    public void testLogFull1() throws Exception {
        String message = "test";
        this.log.log(3, message);
        ExtendedLogEntry entry = this.listener.getEntryX();
        Assert.assertTrue((entry.getLevel() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)entry.getMessage().equals(message));
        Assert.assertTrue((entry.getException() == null ? 1 : 0) != 0);
        Assert.assertTrue((entry.getServiceReference() == null ? 1 : 0) != 0);
    }

    @Test
    public void testLogFull2() throws Exception {
        String message = "test";
        Throwable t = new Throwable("test");
        this.log.log(3, message, t);
        ExtendedLogEntry entry = this.listener.getEntryX();
        Assert.assertTrue((entry.getLevel() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)entry.getMessage().equals(message));
        Assert.assertTrue((boolean)entry.getException().getMessage().equals(t.getMessage()));
        Assert.assertTrue((entry.getServiceReference() == null ? 1 : 0) != 0);
    }

    @Test
    public void testLogFull3() throws Exception {
        String message = "test";
        this.log.log(this.logReference, 3, message);
        ExtendedLogEntry entry = this.listener.getEntryX();
        Assert.assertTrue((entry.getLevel() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)entry.getMessage().equals(message));
        Assert.assertTrue((entry.getException() == null ? 1 : 0) != 0);
        Assert.assertTrue((entry.getServiceReference() == this.logReference ? 1 : 0) != 0);
    }

    @Test
    public void testLogFull4() throws Exception {
        String message = "test";
        Throwable t = new Throwable("test");
        this.log.log(this.logReference, 3, message, t);
        ExtendedLogEntry entry = this.listener.getEntryX();
        Assert.assertTrue((entry.getLevel() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)entry.getMessage().equals(message));
        Assert.assertTrue((boolean)entry.getException().getMessage().equals(t.getMessage()));
        Assert.assertTrue((entry.getServiceReference() == this.logReference ? 1 : 0) != 0);
    }

    @Test
    public void testServiceEventLog() throws InterruptedException {
        BundleContext context = OSGiTestsActivator.getContext();
        ServiceRegistration reg = context.registerService(Object.class, new Object(), null);
        ServiceReference ref = reg.getReference();
        String expectedLoggerName = "Events.Service." + context.getBundle().getSymbolicName();
        ExtendedLogEntry entry = this.listener.getEntryX();
        Assert.assertEquals((String)"Wrong logger name.", (Object)expectedLoggerName, (Object)entry.getLoggerName());
        Assert.assertEquals((String)"Wrong event log level.", (Object)LogLevel.INFO, (Object)entry.getLogLevel());
        Assert.assertEquals((String)"Wrong bundle.", (Object)context.getBundle(), (Object)entry.getBundle());
        Assert.assertNull((String)"Wrong exception.", (Object)entry.getException());
        Assert.assertEquals((String)"Wrong service reference.", (Object)ref, (Object)entry.getServiceReference());
        Assert.assertEquals((String)"Wrong message.", (Object)"ServiceEvent REGISTERED", (Object)entry.getMessage());
        reg.setProperties(new Hashtable<String, String>(Collections.singletonMap("key1", "value1")));
        entry = this.listener.getEntryX();
        Assert.assertEquals((String)"Wrong logger name.", (Object)expectedLoggerName, (Object)entry.getLoggerName());
        Assert.assertEquals((String)"Wrong event log level.", (Object)LogLevel.DEBUG, (Object)entry.getLogLevel());
        Assert.assertEquals((String)"Wrong bundle.", (Object)context.getBundle(), (Object)entry.getBundle());
        Assert.assertNull((String)"Wrong exception.", (Object)entry.getException());
        Assert.assertEquals((String)"Wrong service reference.", (Object)ref, (Object)entry.getServiceReference());
        Assert.assertEquals((String)"Wrong message.", (Object)"ServiceEvent MODIFIED", (Object)entry.getMessage());
        reg.unregister();
        entry = this.listener.getEntryX();
        Assert.assertEquals((String)"Wrong logger name.", (Object)expectedLoggerName, (Object)entry.getLoggerName());
        Assert.assertEquals((String)"Wrong event log level.", (Object)LogLevel.INFO, (Object)entry.getLogLevel());
        Assert.assertEquals((String)"Wrong bundle.", (Object)context.getBundle(), (Object)entry.getBundle());
        Assert.assertNull((String)"Wrong exception.", (Object)entry.getException());
        Assert.assertEquals((String)"Wrong service reference.", (Object)ref, (Object)entry.getServiceReference());
        Assert.assertEquals((String)"Wrong message.", (Object)"ServiceEvent UNREGISTERING", (Object)entry.getMessage());
    }
}

