/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log.test;

import java.util.LinkedList;
import org.eclipse.equinox.log.ExtendedLogEntry;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.junit.Assert;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;

public class TestListener
implements LogListener {
    private final String testBundleLoc;
    private final LinkedList<LogEntry> logs = new LinkedList();

    public TestListener() {
        this(null);
    }

    public TestListener(String testBundleLoc) {
        this.testBundleLoc = testBundleLoc == null ? OSGiTestsActivator.getBundle().getLocation() : testBundleLoc;
    }

    public synchronized void logged(LogEntry e) {
        if (!this.testBundleLoc.equals(e.getBundle().getLocation())) {
            return;
        }
        this.logs.add(e);
        this.notifyAll();
    }

    public synchronized ExtendedLogEntry getEntryX() throws InterruptedException {
        return this.getEntryX(20000L);
    }

    public synchronized ExtendedLogEntry getEntryX(long timeToWait) throws InterruptedException {
        LogEntry logEntry;
        long startTime = System.currentTimeMillis();
        if (this.logs.isEmpty() && timeToWait > 0L) {
            this.wait(timeToWait);
            timeToWait -= System.currentTimeMillis() - startTime;
        }
        LogEntry logEntry2 = logEntry = this.logs.isEmpty() ? null : this.logs.removeFirst();
        if (logEntry == null) {
            Assert.fail((String)"No log entry logged.");
        }
        return (ExtendedLogEntry)logEntry;
    }
}

