/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.appadmin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.tests.session.ConfigurationSessionTestSuite;
import org.eclipse.core.tests.session.SetupManager;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.BundleInstaller;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.application.ApplicationDescriptor;
import org.osgi.service.application.ApplicationException;
import org.osgi.service.application.ApplicationHandle;
import org.osgi.service.application.ScheduledApplication;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ApplicationAdminTest
extends TestCase {
    public static final String testRunnerApp = "org.eclipse.pde.junit.runtime.coretestapplicationnonmain";
    public static final String testResults = "test.results";
    public static final String SUCCESS = "success";
    public static final String ADDED = "added";
    public static final String MODIFIED = "modified";
    public static final String REMOVED = "removed";
    public static final String simpleResults = "test.simpleResults";
    public static final String[] tests = new String[]{"testSimpleApp", "testInvalidArgs", "testAsyncValue01", "testAsyncValue02", "testAsyncValue03", "testAsyncValue04", "testAsyncValue05", "testAsyncValue06", "testExitValue01", "testExitValue02", "testExitValue03", "testExitValue04", "testExitValue05", "testExitValue06", "testExitValue07", "testExitValue08", "testExitValue09", "testExitValue10", "testGlobalSingleton", "testCardinality01", "testCardinality02", "testMainThreaded01", "testMainThreaded02", "testHandleEvents01", "testDescriptorEvents01", "testPersistentLock01", "testPersistentLock02", "testPersistentLock03", "testPersistentSchedule01", "testPersistentSchedule02", "testPersistentSchedule03", "testPersistentSchedule04", "testPersistentSchedule05", "testPersistentSchedule06", "testPersistentSchedule07", "testPersistentSchedule08", "testFailedApplication01", "testDestroyBeforeStart01", "testDestroyBeforeStart02"};

    public static Test suite() {
        TestSuite suite = new TestSuite(ApplicationAdminTest.class.getName());
        ConfigurationSessionTestSuite appAdminSessionTest = new ConfigurationSessionTestSuite("org.eclipse.osgi.tests", ApplicationAdminTest.class.getName());
        OSGiTestsActivator.addRequiredOSGiTestsBundles(appAdminSessionTest);
        appAdminSessionTest.setApplicationId(testRunnerApp);
        try {
            appAdminSessionTest.getSetup().setSystemProperty("eclipse.application.registerDescriptors", "true");
        }
        catch (SetupManager.SetupException e) {
            throw new RuntimeException(e);
        }
        String[] stringArray = tests;
        int n = tests.length;
        int n2 = 0;
        while (n2 < n) {
            String test = stringArray[n2];
            appAdminSessionTest.addTest((Test)new ApplicationAdminTest(test));
            ++n2;
        }
        suite.addTest((Test)appAdminSessionTest);
        return suite;
    }

    public ApplicationAdminTest(String name) {
        super(name);
    }

    private ApplicationDescriptor getApplication(String appName) {
        try {
            ApplicationDescriptor result;
            BundleContext context = OSGiTestsActivator.getContext();
            ApplicationAdminTest.assertNotNull((String)"BundleContext is null!!", (Object)context);
            Class<ApplicationDescriptor> appDescClass = ApplicationDescriptor.class;
            ApplicationAdminTest.assertNotNull((String)"ApplicationDescriptor.class is null!!", appDescClass);
            ServiceReference[] refs = context.getServiceReferences(appDescClass.getName(), "(service.pid=" + appName + ")");
            if (refs == null || refs.length == 0) {
                refs = OSGiTestsActivator.getContext().getServiceReferences(ApplicationDescriptor.class.getName(), null);
                Object availableApps = "";
                if (refs != null) {
                    int i = 0;
                    while (i < refs.length) {
                        availableApps = (String)availableApps + String.valueOf(refs[i].getProperty("service.pid"));
                        if (i < refs.length - 1) {
                            availableApps = (String)availableApps + ",";
                        }
                        ++i;
                    }
                }
                ApplicationAdminTest.fail((String)("Could not find app pid: " + appName + " available apps are: " + (String)availableApps));
            }
            if ((result = (ApplicationDescriptor)OSGiTestsActivator.getContext().getService(refs[0])) != null) {
                OSGiTestsActivator.getContext().ungetService(refs[0]);
            } else {
                ApplicationAdminTest.fail((String)("Could not get application descriptor service: " + appName));
            }
            return result;
        }
        catch (InvalidSyntaxException e) {
            this.fail("Could not create app filter", e);
            return null;
        }
    }

    private HashMap getArguments() {
        HashMap args = new HashMap();
        args.put(testResults, new HashMap());
        return args;
    }

    private void fail(String message, Throwable throwable) {
        AssertionFailedError error = new AssertionFailedError(message);
        error.initCause(throwable);
        throw error;
    }

    public void testSimpleApp() {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.simpleApp");
        HashMap args = this.getArguments();
        HashMap results = (HashMap)args.get(testResults);
        try {
            ApplicationHandle handle = app.launch((Map)args);
            handle.destroy();
        }
        catch (Throwable e) {
            this.fail("failed to launch simpleApp", e);
        }
        String result = (String)results.get(simpleResults);
        ApplicationAdminTest.assertEquals((String)"Check application result", (String)SUCCESS, (String)result);
    }

    private void doInvalidScheduleArgs(ApplicationDescriptor app, String id, Map invalidArgs, String topic, String eventFilter, boolean recurring, boolean invalidKeys, boolean invalidValues) {
        block9: {
            ScheduledApplication sched = null;
            try {
                sched = app.schedule(id, invalidArgs, topic, eventFilter, recurring);
                try {
                    sched.remove();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (invalidKeys || invalidValues) {
                    ApplicationAdminTest.fail((String)"Should have failed with invalid arguments");
                }
            }
            catch (InvalidSyntaxException e) {
                this.fail("Failed to schedule an application", e);
            }
            catch (IllegalArgumentException e) {
                if (!invalidKeys) {
                    this.fail("Failed to schedule an application", e);
                }
            }
            catch (ApplicationException e) {
                if (!invalidValues) {
                    this.fail("Failed to schedule an application", e);
                }
                if (e.getErrorCode() == 7) break block9;
                this.fail("Failed to schedule an application", e);
            }
        }
    }

    public void testInvalidArgs() {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.simpleApp");
        HashMap<Object, Object> args = new HashMap<Object, Object>();
        args.put("test.arg1", Boolean.TRUE);
        args.put("test.arg2", 34);
        args.put("test.arg3", 34L);
        this.doInvalidScheduleArgs(app, "schedule.testargs", args, "org/osgi/application/timer", "(minute=*)", true, false, false);
        args.put("test.arg4", (Object)this);
        this.doInvalidScheduleArgs(app, "schedule.testargs", args, "org/osgi/application/timer", "(minute=*)", true, false, true);
        ArrayList<Object> list = new ArrayList<Object>();
        args.put("test.arg4", list);
        this.doInvalidScheduleArgs(app, "schedule.testargs", args, "org/osgi/application/timer", "(minute=*)", true, false, false);
        list.add((Object)this);
        args.put("test.arg4", list);
        this.doInvalidScheduleArgs(app, "schedule.testargs", args, "org/osgi/application/timer", "(minute=*)", true, false, true);
        list.clear();
        list.add("test");
        list.add(0);
        list.add(0L);
        list.add(Float.valueOf(0.0f));
        list.add(0.0);
        list.add((byte)0);
        list.add((short)1);
        list.add(Character.valueOf('\u0000'));
        list.add(Boolean.TRUE);
        this.doInvalidScheduleArgs(app, "schedule.testargs", args, "org/osgi/application/timer", "(minute=*)", true, false, false);
        args.put("test.arg5", new String[0]);
        args.put("test.arg6", new int[0]);
        args.put("test.arg7", new long[0]);
        args.put("test.arg8", new float[0]);
        args.put("test.arg9", new double[0]);
        args.put("test.arg10", new byte[0]);
        args.put("test.arg11", new short[0]);
        args.put("test.arg12", new char[0]);
        args.put("test.arg12", new boolean[0]);
        this.doInvalidScheduleArgs(app, "schedule.testargs", args, "org/osgi/application/timer", "(minute=*)", true, false, false);
        args.put("test.arg13", "test");
        args.put("test.arg14", 0);
        args.put("test.arg15", 0L);
        args.put("test.arg16", Float.valueOf(0.0f));
        args.put("test.arg17", 0.0);
        args.put("test.arg18", (byte)0);
        args.put("test.arg19", (short)1);
        args.put("test.arg20", Character.valueOf('\u0000'));
        args.put("test.arg21", Boolean.TRUE);
        this.doInvalidScheduleArgs(app, "schedule.testargs", args, "org/osgi/application/timer", "(minute=*)", true, false, false);
        HashMap testMap = new HashMap();
        args.put("test.arg22", testMap);
        this.doInvalidScheduleArgs(app, "schedule.testargs", args, "org/osgi/application/timer", "(minute=*)", true, false, true);
        args.clear();
        args.put(0L, "test");
        this.doInvalidScheduleArgs(app, "schedule.testargs", args, "org/osgi/application/timer", "(minute=*)", true, true, false);
    }

    public void testExitValue01() {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.exitValueApp");
        ApplicationHandle handle = null;
        try {
            handle = app.launch(null);
        }
        catch (ApplicationException e) {
            this.fail("failed to launch simpleApp", e);
        }
        ApplicationAdminTest.assertNotNull((String)"app handle is null", (Object)handle);
        String value = null;
        try {
            value = (String)handle.getExitValue(10000L);
        }
        catch (Exception e) {
            this.fail("unexpected exception waiting for exit value", e);
        }
        ApplicationAdminTest.assertNotNull((String)"value is null", (Object)value);
        ApplicationAdminTest.assertEquals((String)"exit value is incorrect", (String)"Exit Value", (String)value);
    }

    public void testExitValue02() {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.exitValueApp");
        final Object[] result = new Object[1];
        ServiceTrackerCustomizer trackerCustomizer = new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                return OSGiTestsActivator.getContext().getService(reference);
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference reference, Object service) {
                try {
                    result[0] = ((ApplicationHandle)service).getExitValue(10000L);
                }
                catch (Exception e) {
                    result[0] = e;
                }
            }
        };
        ServiceTracker tracker = null;
        try {
            tracker = new ServiceTracker(OSGiTestsActivator.getContext(), FrameworkUtil.createFilter((String)("(&(objectClass=" + ApplicationHandle.class.getName() + ")(application.descriptor=" + app.getApplicationId() + "))")), trackerCustomizer);
        }
        catch (InvalidSyntaxException e) {
            this.fail("unexpected syntax exception for tracker", e);
        }
        tracker.open();
        ApplicationHandle handle = null;
        try {
            handle = app.launch(null);
        }
        catch (ApplicationException e) {
            this.fail("failed to launch simpleApp", e);
        }
        ApplicationAdminTest.assertNotNull((String)"app handle is null", (Object)handle);
        String value = null;
        try {
            value = (String)handle.getExitValue(10000L);
        }
        catch (Exception e) {
            this.fail("unexpected exception waiting for exit value", e);
        }
        ApplicationAdminTest.assertNotNull((String)"value is null", (Object)value);
        ApplicationAdminTest.assertEquals((String)"exit value is incorrect", (String)"Exit Value", (String)value);
        ApplicationAdminTest.assertEquals((String)"value from service unregister is different", (Object)value, (Object)result[0]);
    }

    public void testExitValue03() {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.exitValueApp");
        final Object[] result = new Object[1];
        ServiceTrackerCustomizer trackerCustomizer = new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                return OSGiTestsActivator.getContext().getService(reference);
            }

            public void modifiedService(ServiceReference reference, Object service) {
                if (!"org.eclipse.equinox.app.stopped".equals(reference.getProperty("application.state"))) {
                    return;
                }
                try {
                    result[0] = ((ApplicationHandle)service).getExitValue(10000L);
                }
                catch (Exception e) {
                    result[0] = e;
                }
            }

            public void removedService(ServiceReference reference, Object service) {
            }
        };
        ServiceTracker tracker = null;
        try {
            tracker = new ServiceTracker(OSGiTestsActivator.getContext(), FrameworkUtil.createFilter((String)("(&(objectClass=" + ApplicationHandle.class.getName() + ")(application.descriptor=" + app.getApplicationId() + "))")), trackerCustomizer);
        }
        catch (InvalidSyntaxException e) {
            this.fail("unexpected syntax exception for tracker", e);
        }
        tracker.open();
        ApplicationHandle handle = null;
        try {
            handle = app.launch(null);
        }
        catch (ApplicationException e) {
            this.fail("failed to launch simpleApp", e);
        }
        ApplicationAdminTest.assertNotNull((String)"app handle is null", (Object)handle);
        String value = null;
        try {
            value = (String)handle.getExitValue(10000L);
        }
        catch (Exception e) {
            this.fail("unexpected exception waiting for exit value", e);
        }
        ApplicationAdminTest.assertNotNull((String)"value is null", (Object)value);
        ApplicationAdminTest.assertEquals((String)"exit value is incorrect", (String)"Exit Value", (String)value);
        ApplicationAdminTest.assertEquals((String)"value from service unregister is different", (Object)value, (Object)result[0]);
    }

    public void testExitValue04() {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.exitValueApp");
        ApplicationHandle handle = null;
        try {
            handle = app.launch(null);
        }
        catch (ApplicationException e) {
            this.fail("failed to launch simpleApp", e);
        }
        ApplicationAdminTest.assertNotNull((String)"app handle is null", (Object)handle);
        ApplicationHandle destroyHandle = handle;
        new Thread(() -> {
            try {
                Thread.sleep(1000L);
                destroyHandle.destroy();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }).start();
        String value = null;
        try {
            value = (String)handle.getExitValue(10000L);
        }
        catch (Exception e) {
            this.fail("unexpected exception waiting for exit value", e);
        }
        ApplicationAdminTest.assertNotNull((String)"value is null", (Object)value);
        ApplicationAdminTest.assertEquals((String)"exit value is incorrect", (String)"Exit Value", (String)value);
    }

    public void testExitValue05() {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.exitValueApp");
        ApplicationHandle handle = null;
        try {
            handle = app.launch(null);
        }
        catch (ApplicationException e) {
            this.fail("failed to launch simpleApp", e);
        }
        ApplicationAdminTest.assertNotNull((String)"app handle is null", (Object)handle);
        handle.destroy();
        String value = null;
        try {
            value = (String)handle.getExitValue(10000L);
        }
        catch (Exception e) {
            this.fail("unexpected exception waiting for exit value", e);
        }
        ApplicationAdminTest.assertNotNull((String)"value is null", (Object)value);
        ApplicationAdminTest.assertEquals((String)"exit value is incorrect", (String)"Exit Value", (String)value);
    }

    public void testExitValue06() {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.exitValueApp");
        ApplicationHandle handle = null;
        try {
            handle = app.launch(null);
        }
        catch (ApplicationException e) {
            this.fail("failed to launch simpleApp", e);
        }
        ApplicationAdminTest.assertNotNull((String)"app handle is null", (Object)handle);
        try {
            handle.getExitValue(100L);
            ApplicationAdminTest.fail((String)"Expected an ApplicationException for exit value not available");
        }
        catch (ApplicationException e) {
            ApplicationAdminTest.assertEquals((String)"Unexpected error type", (int)6, (int)e.getErrorCode());
        }
        catch (InterruptedException e) {
            this.fail("Unexpected interrupted exception waiting for exit value", e);
        }
    }

    public void testExitValue07() {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.exitValueApp");
        ApplicationHandle handle = null;
        try {
            handle = app.launch(null);
        }
        catch (ApplicationException e) {
            this.fail("failed to launcher simpleApp", e);
        }
        ApplicationAdminTest.assertNotNull((String)"app handle is null", (Object)handle);
        String value = null;
        try {
            value = (String)handle.getExitValue(0L);
        }
        catch (Exception e) {
            this.fail("unexpected exception waiting for exit value", e);
        }
        ApplicationAdminTest.assertNotNull((String)"value is null", (Object)value);
        ApplicationAdminTest.assertEquals((String)"exit value is incorrect", (String)"Exit Value", (String)value);
    }

    public void testExitValue08() {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.exitValueApp");
        ApplicationHandle handle = null;
        try {
            handle = app.launch(null);
        }
        catch (ApplicationException e) {
            this.fail("failed to launcher simpleApp", e);
        }
        ApplicationAdminTest.assertNotNull((String)"app handle is null", (Object)handle);
        try {
            handle.getExitValue(-1L);
            ApplicationAdminTest.fail((String)"Expected an ApplicationException for exit value not available");
        }
        catch (ApplicationException e) {
            ApplicationAdminTest.assertEquals((String)"Unexpected error type", (int)6, (int)e.getErrorCode());
        }
        catch (InterruptedException e) {
            this.fail("Unexpected interrupted exception waiting for exit value", e);
        }
    }

    public void testExitValue09() {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.exitValueApp");
        ApplicationHandle handle = null;
        HashMap args = this.getArguments();
        args.put("return.null", Boolean.TRUE);
        try {
            handle = app.launch((Map)args);
        }
        catch (ApplicationException e) {
            this.fail("failed to launcher simpleApp", e);
        }
        ApplicationAdminTest.assertNotNull((String)"app handle is null", (Object)handle);
        try {
            ApplicationAdminTest.assertNull((String)"expected null return value", (Object)handle.getExitValue(0L));
        }
        catch (Exception e) {
            this.fail("unexpected exception waiting for exit value", e);
        }
    }

    public void testExitValue10() {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.exitValueApp");
        ApplicationHandle handle = null;
        try {
            handle = app.launch(null);
        }
        catch (ApplicationException e) {
            this.fail("failed to launch simpleApp", e);
        }
        ApplicationAdminTest.assertNotNull((String)"app handle is null", (Object)handle);
        String value = null;
        try {
            handle.getExitValue(10000L);
            value = (String)handle.getExitValue(0L);
        }
        catch (Exception e) {
            this.fail("unexpected exception waiting for exit value", e);
        }
        ApplicationAdminTest.assertNotNull((String)"value is null", (Object)value);
        ApplicationAdminTest.assertEquals((String)"exit value is incorrect", (String)"Exit Value", (String)value);
        try {
            value = (String)handle.getExitValue(-1L);
        }
        catch (Exception e) {
            this.fail("unexpected exception waiting for exit value", e);
        }
        ApplicationAdminTest.assertNotNull((String)"value is null", (Object)value);
        ApplicationAdminTest.assertEquals((String)"exit value is incorrect", (String)"Exit Value", (String)value);
    }

    public void testAsyncValue01() {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.exitValueApp");
        HashMap<String, Boolean> args = new HashMap<String, Boolean>();
        args.put("return.async", Boolean.TRUE);
        ApplicationHandle handle = null;
        try {
            handle = app.launch(args);
        }
        catch (ApplicationException e) {
            this.fail("failed to launch simpleApp", e);
        }
        ApplicationAdminTest.assertNotNull((String)"app handle is null", (Object)handle);
        String value = null;
        try {
            handle.getExitValue(10000L);
            value = (String)handle.getExitValue(0L);
        }
        catch (Exception e) {
            this.fail("unexpected exception waiting for exit value", e);
        }
        ApplicationAdminTest.assertNotNull((String)"value is null", (Object)value);
        ApplicationAdminTest.assertEquals((String)"exit value is incorrect", (String)"Exit Value", (String)value);
        try {
            value = (String)handle.getExitValue(-1L);
        }
        catch (Exception e) {
            this.fail("unexpected exception waiting for exit value", e);
        }
        ApplicationAdminTest.assertNotNull((String)"value is null", (Object)value);
        ApplicationAdminTest.assertEquals((String)"exit value is incorrect", (String)"Exit Value", (String)value);
    }

    public void testAsyncValue02() {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.exitValueApp");
        ApplicationHandle handle = null;
        HashMap<String, Boolean> args = new HashMap<String, Boolean>();
        args.put("return.async", Boolean.TRUE);
        try {
            handle = app.launch(args);
        }
        catch (ApplicationException e) {
            this.fail("failed to launcher simpleApp", e);
        }
        ApplicationAdminTest.assertNotNull((String)"app handle is null", (Object)handle);
        try {
            handle.getExitValue(-1L);
            ApplicationAdminTest.fail((String)"Expected an ApplicationException for exit value not available");
        }
        catch (ApplicationException e) {
            ApplicationAdminTest.assertEquals((String)"Unexpected error type", (int)6, (int)e.getErrorCode());
        }
        catch (InterruptedException e) {
            this.fail("Unexpected interrupted exception waiting for exit value", e);
        }
    }

    public void testAsyncValue03() {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.exitValueApp");
        ApplicationHandle handle = null;
        HashMap args = this.getArguments();
        args.put("return.null", Boolean.TRUE);
        args.put("return.async", Boolean.TRUE);
        try {
            handle = app.launch((Map)args);
        }
        catch (ApplicationException e) {
            this.fail("failed to launcher simpleApp", e);
        }
        ApplicationAdminTest.assertNotNull((String)"app handle is null", (Object)handle);
        try {
            ApplicationAdminTest.assertNull((String)"expected null return value", (Object)handle.getExitValue(0L));
        }
        catch (Exception e) {
            this.fail("unexpected exception waiting for exit value", e);
        }
    }

    public void testAsyncValue04() {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.exitValueApp");
        HashMap args = this.getArguments();
        args.put("return.async", Boolean.TRUE);
        ApplicationHandle handle = null;
        try {
            handle = app.launch(null);
        }
        catch (ApplicationException e) {
            this.fail("failed to launch simpleApp", e);
        }
        ApplicationAdminTest.assertNotNull((String)"app handle is null", (Object)handle);
        ApplicationHandle destroyHandle = handle;
        new Thread(() -> {
            try {
                Thread.sleep(1000L);
                destroyHandle.destroy();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }).start();
        String value = null;
        try {
            value = (String)handle.getExitValue(10000L);
        }
        catch (Exception e) {
            this.fail("unexpected exception waiting for exit value", e);
        }
        ApplicationAdminTest.assertNotNull((String)"value is null", (Object)value);
        ApplicationAdminTest.assertEquals((String)"exit value is incorrect", (String)"Exit Value", (String)value);
    }

    public void testAsyncValue05() {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.exitValueApp");
        HashMap<String, Boolean> args = new HashMap<String, Boolean>();
        args.put("set.async.early", Boolean.TRUE);
        ApplicationHandle handle = null;
        try {
            handle = app.launch(args);
        }
        catch (ApplicationException e) {
            this.fail("failed to launch simpleApp", e);
        }
        ApplicationAdminTest.assertNotNull((String)"app handle is null", (Object)handle);
        String value = null;
        try {
            value = (String)handle.getExitValue(10000L);
        }
        catch (Exception e) {
            this.fail("unexpected exception waiting for exit value", e);
        }
        ApplicationAdminTest.assertNotNull((String)"value is null", (Object)value);
        ApplicationAdminTest.assertEquals((String)"exit value is incorrect", (String)"Exit Value", (String)value);
    }

    public void testAsyncValue06() {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.exitValueApp");
        HashMap<String, Boolean> args = new HashMap<String, Boolean>();
        args.put("return.async", Boolean.TRUE);
        args.put("set.async.wrongApp", Boolean.TRUE);
        ApplicationHandle handle = null;
        try {
            handle = app.launch(args);
        }
        catch (ApplicationException e) {
            this.fail("failed to launch simpleApp", e);
        }
        ApplicationAdminTest.assertNotNull((String)"app handle is null", (Object)handle);
        String value = null;
        try {
            value = (String)handle.getExitValue(10000L);
        }
        catch (Exception e) {
            this.fail("unexpected exception waiting for exit value", e);
        }
        ApplicationAdminTest.assertNotNull((String)"value is null", (Object)value);
        ApplicationAdminTest.assertEquals((String)"exit value is incorrect", (String)"Exit Value", (String)value);
    }

    public void testGlobalSingleton() {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.globalSingletonApp");
        HashMap args = this.getArguments();
        try {
            ApplicationHandle handle = app.launch((Map)args);
            handle.destroy();
            ApplicationAdminTest.fail((String)("should not be able to launch a global singleton app: " + app.getApplicationId()));
        }
        catch (ApplicationException e) {
            ApplicationAdminTest.assertEquals((String)"check error code", (int)2, (int)e.getErrorCode());
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void doTestCardinality01(String appID, int cardinality, boolean hasMax) {
        block11: {
            block10: {
                app = this.getApplication(appID);
                instances = new ArrayList<ApplicationHandle>();
                i = 0;
                try {
                    try {
                        while (i <= cardinality) {
                            instances.add(app.launch(null));
                            if (i == cardinality && hasMax) {
                                ApplicationAdminTest.fail((String)"Expected an ApplicationException.");
                            }
                            ++i;
                        }
                        break block10;
                    }
                    catch (ApplicationException e) {
                        if (!hasMax || i != cardinality) {
                            this.fail("Unexpected ApplicationException", e);
                        }
                        ApplicationAdminTest.assertEquals((String)"check error code", (int)2, (int)e.getErrorCode());
                        ** for (element : instances)
                    }
                }
                catch (Throwable var8_14) {
                    ** for (element : instances)
                }
lbl-1000:
                // 1 sources

                {
                    ((ApplicationHandle)element).destroy();
                    continue;
lbl21:
                    // 1 sources

                    break block11;
                }
lbl-1000:
                // 1 sources

                {
                    ((ApplicationHandle)element).destroy();
                    continue;
                }
lbl26:
                // 1 sources

                throw var8_14;
            }
            for (E element : instances) {
                ((ApplicationHandle)element).destroy();
            }
        }
        ApplicationAdminTest.assertEquals((String)"Did not launch the correct # of concurrent instances", (int)instances.size(), (int)(cardinality + (hasMax != false ? 0 : 1)));
    }

    public void testCardinality01() {
        this.doTestCardinality01("org.eclipse.osgi.tests.testCardinality01", 5, true);
    }

    public void testCardinality02() {
        this.doTestCardinality01("org.eclipse.osgi.tests.testCardinality02", 20, false);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void doTestMainThreaded(String appID) {
        block9: {
            block8: {
                app = this.getApplication(appID);
                instances = new ArrayList<ApplicationHandle>();
                try {
                    try {
                        instances.add(app.launch(null));
                        instances.add(app.launch(null));
                        break block8;
                    }
                    catch (ApplicationException e) {
                        if (instances.size() == 0) {
                            this.fail("Unable to launch a main threaded application", e);
                        }
                        ApplicationAdminTest.assertEquals((String)"check error code", (int)2, (int)e.getErrorCode());
                        ** for (element : instances)
                    }
                }
                catch (Throwable var5_11) {
                    ** for (element : instances)
                }
lbl-1000:
                // 1 sources

                {
                    ((ApplicationHandle)element).destroy();
                    continue;
lbl17:
                    // 1 sources

                    break block9;
                }
lbl-1000:
                // 1 sources

                {
                    ((ApplicationHandle)element).destroy();
                    continue;
                }
lbl22:
                // 1 sources

                throw var5_11;
            }
            for (E element : instances) {
                ((ApplicationHandle)element).destroy();
            }
        }
        ApplicationAdminTest.assertEquals((String)"Did not launch the correct # of main app instances", (int)instances.size(), (int)1);
    }

    public void testMainThreaded01() {
        this.doTestMainThreaded("org.eclipse.osgi.tests.testMainThreaded01");
    }

    public void testMainThreaded02() {
        this.doTestMainThreaded("org.eclipse.osgi.tests.testMainThreaded02");
    }

    public void testHandleEvents01() throws InvalidSyntaxException {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.simpleApp");
        ApplicationHandleTracker handleTracker = new ApplicationHandleTracker(OSGiTestsActivator.getContext());
        tracker.open();
        try (ServiceTracker tracker = new ServiceTracker(OSGiTestsActivator.getContext(), FrameworkUtil.createFilter((String)("(&(objectClass=" + ApplicationHandle.class.getName() + ")(application.descriptor=" + app.getApplicationId() + "))")), (ServiceTrackerCustomizer)handleTracker);){
            try {
                ApplicationHandle handle = app.launch(null);
                handleTracker.waitForEvent(handle.getInstanceId(), "RUNNING");
                handle.destroy();
                handleTracker.waitForEvent(handle.getInstanceId(), REMOVED);
                String[][] events = handleTracker.getEvents();
                String[][] expected = new String[][]{{handle.getInstanceId(), "org.eclipse.equinox.app.starting"}, {handle.getInstanceId(), "RUNNING"}, {handle.getInstanceId(), "STOPPING"}, {handle.getInstanceId(), "org.eclipse.equinox.app.stopped"}, {handle.getInstanceId(), REMOVED}};
                ApplicationAdminTest.assertEquals((String)"Check expected # events", (int)expected.length, (int)events.length);
                int i = 0;
                while (i < events.length) {
                    ApplicationAdminTest.assertEquals((String)("Check expected event id for #" + i), (String)expected[i][0], (String)events[i][0]);
                    ApplicationAdminTest.assertEquals((String)("Check expected event state for #" + i), (String)expected[i][1], (String)events[i][1]);
                    ++i;
                }
            }
            catch (ApplicationException e) {
                this.fail("failed to launch application", e);
                tracker.close();
            }
        }
    }

    public void testDescriptorEvents01() throws InvalidSyntaxException, BundleException {
        BundleInstaller bundleInstaller = null;
        try {
            bundleInstaller = new BundleInstaller("test_files/internal/plugins/appAdminTests", OSGiTestsActivator.getContext());
        }
        catch (InvalidSyntaxException e) {
            this.fail("Failed to create bundle installer", e);
        }
        String testAppPID = "appadmin.test01.simpleApp";
        ApplicationDescriptorTracker descriptionTracker = new ApplicationDescriptorTracker(OSGiTestsActivator.getContext());
        ServiceTracker tracker = new ServiceTracker(OSGiTestsActivator.getContext(), FrameworkUtil.createFilter((String)("(&(objectClass=" + ApplicationDescriptor.class.getName() + ")(service.pid=" + testAppPID + "))")), (ServiceTrackerCustomizer)descriptionTracker);
        tracker.open();
        try {
            Bundle test01 = bundleInstaller.installBundle("appadmin.test01");
            ApplicationAdminTest.assertTrue((String)("Check if test bundle is resolved: " + test01.getSymbolicName()), (boolean)bundleInstaller.resolveBundles(new Bundle[]{test01}));
            descriptionTracker.waitForEvent(testAppPID, ADDED, Boolean.FALSE, Boolean.TRUE);
            ApplicationDescriptor app = this.getApplication(testAppPID);
            app.lock();
            Boolean locked = (Boolean)app.getProperties("").get("application.locked");
            ApplicationAdminTest.assertTrue((String)"Application should be locked", (boolean)locked);
            descriptionTracker.waitForEvent(testAppPID, MODIFIED, Boolean.TRUE, Boolean.TRUE);
            app.unlock();
            descriptionTracker.waitForEvent(testAppPID, MODIFIED, Boolean.FALSE, Boolean.TRUE);
            ApplicationHandle handle = null;
            try {
                handle = app.launch(null);
            }
            catch (ApplicationException e) {
                this.fail("failed to launch app: " + app.getApplicationId(), e);
            }
            descriptionTracker.waitForEvent(testAppPID, MODIFIED, Boolean.FALSE, Boolean.FALSE);
            handle.destroy();
            descriptionTracker.waitForEvent(testAppPID, MODIFIED, Boolean.FALSE, Boolean.TRUE);
            test01.uninstall();
            descriptionTracker.waitForEvent(testAppPID, REMOVED, Boolean.FALSE, Boolean.TRUE);
        }
        finally {
            bundleInstaller.shutdown();
            tracker.close();
        }
    }

    public void testPersistentLock01() {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.simpleApp");
        app.lock();
    }

    public void testPersistentLock02() {
        ApplicationHandle handle;
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.simpleApp");
        try {
            handle = app.launch(null);
            handle.destroy();
            ApplicationAdminTest.fail((String)("The application should be locked: " + app.getApplicationId()));
        }
        catch (ApplicationException e) {
            ApplicationAdminTest.assertEquals((String)"check error code", (int)1, (int)e.getErrorCode());
        }
        app.unlock();
        try {
            handle = app.launch(null);
            handle.destroy();
        }
        catch (Throwable e) {
            this.fail("failed to launch simpleApp", e);
        }
    }

    public void testPersistentLock03() {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.simpleApp");
        try {
            ApplicationHandle handle = app.launch(null);
            handle.destroy();
        }
        catch (Throwable e) {
            this.fail("failed to launch simpleApp", e);
        }
    }

    public void testPersistentSchedule01() {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.simpleApp");
        try {
            HashMap<String, Comparable<Boolean>> args = new HashMap<String, Comparable<Boolean>>();
            args.put("test.arg1", Boolean.TRUE);
            args.put("test.arg2", Integer.valueOf(34));
            args.put("test.arg3", Long.valueOf(34L));
            app.schedule("schedule.1", args, "org/osgi/application/timer", "(minute=*)", true);
        }
        catch (InvalidSyntaxException | ApplicationException e) {
            this.fail("Failed to schedule an application", e);
        }
    }

    public void testPersistentSchedule02() throws InvalidSyntaxException {
        ScheduledApplication scheduledApp = this.getScheduleApplication("schedule.1", true);
        ApplicationHandleTracker handleTracker = new ApplicationHandleTracker(OSGiTestsActivator.getContext());
        ServiceTracker tracker = new ServiceTracker(OSGiTestsActivator.getContext(), FrameworkUtil.createFilter((String)("(&(objectClass=" + ApplicationHandle.class.getName() + ")(application.descriptor=" + scheduledApp.getApplicationDescriptor().getApplicationId() + "))")), (ServiceTrackerCustomizer)handleTracker);
        tracker.open();
        try {
            try {
                ApplicationHandle handle = (ApplicationHandle)tracker.waitForService(61000L);
                ApplicationAdminTest.assertNotNull((String)"Should find an application handle", (Object)handle);
                handleTracker.waitForEvent(handle.getInstanceId(), "RUNNING");
                handle.destroy();
                handleTracker.waitForEvent(handle.getInstanceId(), REMOVED);
                HashMap results = null;
                try {
                    results = (HashMap)handle.getExitValue(1000L);
                }
                catch (ApplicationException e) {
                    this.fail("Unexpected application exception waiting for an exit value", e);
                }
                ApplicationAdminTest.assertNotNull((String)"Null results", (Object)results);
                HashMap<String, Comparable<Boolean>> args = new HashMap<String, Comparable<Boolean>>();
                args.put("test.arg1", Boolean.TRUE);
                args.put("test.arg2", Integer.valueOf(34));
                args.put("test.arg3", Long.valueOf(34L));
                Iterator iterator = args.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element;
                    Map.Entry entry = element = iterator.next();
                    ApplicationAdminTest.assertEquals((String)("key: " + String.valueOf(entry.getKey())), entry.getValue(), results.get(entry.getKey()));
                }
            }
            catch (InterruptedException e) {
                this.fail("got interupted", e);
                tracker.close();
                scheduledApp.remove();
            }
        }
        finally {
            tracker.close();
            scheduledApp.remove();
        }
    }

    public void testPersistentSchedule03() {
        ScheduledApplication scheduledApp = this.getScheduleApplication("schedule.1", false);
        if (scheduledApp != null) {
            scheduledApp.remove();
            ApplicationAdminTest.fail((String)("Scheduled application should not be found: " + scheduledApp.getScheduleId()));
        }
    }

    public void testPersistentSchedule04() {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.simpleApp");
        try {
            app.lock();
            HashMap<String, Comparable<Boolean>> args = new HashMap<String, Comparable<Boolean>>();
            args.put("test.arg1", Boolean.TRUE);
            args.put("test.arg2", Integer.valueOf(34));
            args.put("test.arg3", Long.valueOf(34L));
            app.schedule("schedule.2", args, "org/osgi/application/timer", "(minute=*)", false);
        }
        catch (InvalidSyntaxException | ApplicationException e) {
            this.fail("Failed to schedule an application", e);
        }
    }

    public void testPersistentSchedule05() throws InvalidSyntaxException {
        ScheduledApplication scheduledApp = this.getScheduleApplication("schedule.2", true);
        ApplicationHandleTracker handleTracker = new ApplicationHandleTracker(OSGiTestsActivator.getContext());
        ServiceTracker tracker = new ServiceTracker(OSGiTestsActivator.getContext(), FrameworkUtil.createFilter((String)("(&(objectClass=" + ApplicationHandle.class.getName() + ")(application.descriptor=" + scheduledApp.getApplicationDescriptor().getApplicationId() + "))")), (ServiceTrackerCustomizer)handleTracker);
        tracker.open();
        ApplicationHandle badHandle = null;
        try {
            try {
                badHandle = (ApplicationHandle)tracker.waitForService(61000L);
                ApplicationAdminTest.assertNull((String)"Should not find an application handle", (Object)badHandle);
                scheduledApp.getApplicationDescriptor().unlock();
                ApplicationHandle handle = (ApplicationHandle)tracker.waitForService(61000L);
                ApplicationAdminTest.assertNotNull((String)"Should find an application handle", (Object)handle);
                handleTracker.waitForEvent(handle.getInstanceId(), "RUNNING");
                handle.destroy();
                handleTracker.waitForEvent(handle.getInstanceId(), REMOVED);
                HashMap results = null;
                try {
                    results = (HashMap)handle.getExitValue(1000L);
                }
                catch (ApplicationException e) {
                    this.fail("Unexpected application exception waiting for an exit value", e);
                }
                ApplicationAdminTest.assertNotNull((String)"Null results", (Object)results);
                HashMap<String, Comparable<Boolean>> args = new HashMap<String, Comparable<Boolean>>();
                args.put("test.arg1", Boolean.TRUE);
                args.put("test.arg2", Integer.valueOf(34));
                args.put("test.arg3", Long.valueOf(34L));
                Iterator iterator = args.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element;
                    Map.Entry entry = element = iterator.next();
                    ApplicationAdminTest.assertEquals((String)("key: " + String.valueOf(entry.getKey())), entry.getValue(), results.get(entry.getKey()));
                }
                Thread.sleep(1000L);
                scheduledApp = this.getScheduleApplication("schedule.2", false);
                if (scheduledApp != null) {
                    System.out.println("Scheduled application should not be found: " + scheduledApp.getScheduleId());
                    Thread.sleep(5000L);
                    scheduledApp = this.getScheduleApplication("schedule.2", false);
                    if (scheduledApp != null) {
                        System.out.println("   -- Still found after waiting 5 seconds: " + scheduledApp.getScheduleId());
                    }
                }
            }
            catch (InterruptedException e) {
                this.fail("got interupted", e);
                if (badHandle != null) {
                    badHandle.destroy();
                }
                tracker.close();
                if (scheduledApp != null) {
                    scheduledApp.remove();
                }
            }
        }
        finally {
            if (badHandle != null) {
                badHandle.destroy();
            }
            tracker.close();
            if (scheduledApp != null) {
                scheduledApp.remove();
            }
        }
    }

    public void testPersistentSchedule06() {
        ScheduledApplication scheduledApp = this.getScheduleApplication("schedule.2", false);
        if (scheduledApp != null) {
            scheduledApp.remove();
            ApplicationAdminTest.fail((String)("Scheduled application should not be found: " + scheduledApp.getScheduleId()));
        }
    }

    public void testPersistentSchedule07() {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.simpleApp");
        try {
            app.schedule("schedule.duplicate1", null, "org/osgi/application/timer", "(minute=*)", true);
        }
        catch (InvalidSyntaxException | ApplicationException e) {
            this.fail("Failed to schedule an application", e);
        }
        try {
            app.schedule("schedule.duplicate1", null, "org/osgi/application/timer", "(minute=*)", true);
            ApplicationAdminTest.fail((String)"should not be able to create a duplicate scheduled application id");
        }
        catch (InvalidSyntaxException e) {
            this.fail("Failed to schedule an application", e);
        }
        catch (ApplicationException e) {
            ApplicationAdminTest.assertEquals((String)"check error code", (int)5, (int)e.getErrorCode());
        }
    }

    public void testPersistentSchedule08() {
        ScheduledApplication scheduledApp = this.getScheduleApplication("schedule.duplicate1", true);
        try {
            try {
                scheduledApp.getApplicationDescriptor().schedule("schedule.duplicate1", null, "org/osgi/application/timer", "(minute=*)", true);
                ApplicationAdminTest.fail((String)"should not be able to create a duplicate scheduled application id");
            }
            catch (InvalidSyntaxException e) {
                this.fail("Failed to schedule an application", e);
                scheduledApp.remove();
            }
            catch (ApplicationException e) {
                ApplicationAdminTest.assertEquals((String)"check error code", (int)5, (int)e.getErrorCode());
                scheduledApp.remove();
            }
        }
        finally {
            scheduledApp.remove();
        }
    }

    public void testFailedApplication01() throws InvalidSyntaxException {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.failedApp");
        ApplicationHandleTracker handleTracker = new ApplicationHandleTracker(OSGiTestsActivator.getContext());
        tracker.open();
        try (ServiceTracker tracker = new ServiceTracker(OSGiTestsActivator.getContext(), FrameworkUtil.createFilter((String)("(&(objectClass=" + ApplicationHandle.class.getName() + ")(application.descriptor=" + app.getApplicationId() + "))")), (ServiceTrackerCustomizer)handleTracker);){
            try {
                ApplicationHandle handle = app.launch(null);
                handleTracker.waitForEvent(handle.getInstanceId(), REMOVED);
                String[][] events = handleTracker.getEvents();
                String[][] expected = new String[][]{{handle.getInstanceId(), "org.eclipse.equinox.app.starting"}, {handle.getInstanceId(), "STOPPING"}, {handle.getInstanceId(), "org.eclipse.equinox.app.stopped"}, {handle.getInstanceId(), REMOVED}};
                ApplicationAdminTest.assertEquals((String)"Check expected # events", (int)expected.length, (int)events.length);
                int i = 0;
                while (i < events.length) {
                    ApplicationAdminTest.assertEquals((String)("Check expected event id for #" + i), (String)expected[i][0], (String)events[i][0]);
                    ApplicationAdminTest.assertEquals((String)("Check expected event state for #" + i), (String)expected[i][1], (String)events[i][1]);
                    ++i;
                }
            }
            catch (ApplicationException e) {
                this.fail("failed to launch application", e);
                tracker.close();
            }
        }
    }

    public void testDestroyBeforeStart01() throws InvalidSyntaxException {
        HashMap results;
        block5: {
            ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.simpleApp");
            HashMap args = this.getArguments();
            results = (HashMap)args.get(testResults);
            ServiceTrackerCustomizer trackerCustomizer = new ServiceTrackerCustomizer(){

                public Object addingService(ServiceReference reference) {
                    ApplicationHandle handle = (ApplicationHandle)OSGiTestsActivator.getContext().getService(reference);
                    handle.destroy();
                    return handle;
                }

                public void modifiedService(ServiceReference reference, Object service) {
                }

                public void removedService(ServiceReference reference, Object service) {
                }
            };
            ServiceTracker tracker = new ServiceTracker(OSGiTestsActivator.getContext(), FrameworkUtil.createFilter((String)("(&(objectClass=" + ApplicationHandle.class.getName() + ")(application.descriptor=" + app.getApplicationId() + "))")), trackerCustomizer);
            tracker.open();
            try {
                try {
                    ApplicationHandle handle = app.launch((Map)args);
                    handle.destroy();
                }
                catch (Throwable e) {
                    this.fail("failed to launch simpleApp", e);
                    tracker.close();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                tracker.close();
                throw throwable;
            }
            tracker.close();
        }
        String result = (String)results.get(simpleResults);
        ApplicationAdminTest.assertNull((String)"Check application result", (Object)result);
    }

    public void testDestroyBeforeStart02() throws InvalidSyntaxException {
        HashMap results;
        block5: {
            ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.testMainThreaded01");
            HashMap args = this.getArguments();
            results = (HashMap)args.get(testResults);
            ServiceTrackerCustomizer trackerCustomizer = new ServiceTrackerCustomizer(){

                public Object addingService(ServiceReference reference) {
                    ApplicationHandle handle = (ApplicationHandle)OSGiTestsActivator.getContext().getService(reference);
                    handle.destroy();
                    return handle;
                }

                public void modifiedService(ServiceReference reference, Object service) {
                }

                public void removedService(ServiceReference reference, Object service) {
                }
            };
            ServiceTracker tracker = new ServiceTracker(OSGiTestsActivator.getContext(), FrameworkUtil.createFilter((String)("(&(objectClass=" + ApplicationHandle.class.getName() + ")(application.descriptor=" + app.getApplicationId() + "))")), trackerCustomizer);
            tracker.open();
            try {
                try {
                    ApplicationHandle handle = app.launch((Map)args);
                    handle.destroy();
                }
                catch (Throwable e) {
                    this.fail("failed to launch simpleApp", e);
                    tracker.close();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                tracker.close();
                throw throwable;
            }
            tracker.close();
        }
        String result = (String)results.get(simpleResults);
        ApplicationAdminTest.assertNull((String)"Check application result", (Object)result);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ScheduledApplication getScheduleApplication(String scheduleID, boolean failOnMissing) {
        try {
            ScheduledApplication result;
            BundleContext context = OSGiTestsActivator.getContext();
            ApplicationAdminTest.assertNotNull((String)"BundleContext is null!!", (Object)context);
            Class<ScheduledApplication> schedAppClass = ScheduledApplication.class;
            ApplicationAdminTest.assertNotNull((String)"ScheduledApplication.class is null!!", schedAppClass);
            ServiceReference[] refs = OSGiTestsActivator.getContext().getServiceReferences(schedAppClass.getName(), "(schedule.id=" + scheduleID + ")");
            if (refs == null || refs.length == 0) {
                if (!failOnMissing) {
                    return null;
                }
                refs = OSGiTestsActivator.getContext().getServiceReferences(ScheduledApplication.class.getName(), null);
                Object availableScheds = "";
                if (refs != null) {
                    int i = 0;
                    while (i < refs.length) {
                        availableScheds = (String)availableScheds + String.valueOf(refs[i].getProperty("schedule.id"));
                        if (i < refs.length - 1) {
                            availableScheds = (String)availableScheds + ",";
                        }
                        ++i;
                    }
                }
                ApplicationAdminTest.fail((String)("Could not find schedule: " + scheduleID + " available apps are: " + (String)availableScheds));
            }
            if ((result = (ScheduledApplication)OSGiTestsActivator.getContext().getService(refs[0])) != null) {
                OSGiTestsActivator.getContext().ungetService(refs[0]);
                return result;
            }
            ApplicationAdminTest.fail((String)("Could not get scheduled application: " + scheduleID));
            return result;
        }
        catch (InvalidSyntaxException e) {
            this.fail("Could not create app filter", e);
            return null;
        }
    }

    public static class ApplicationDescriptorTracker
    implements ServiceTrackerCustomizer {
        private final BundleContext bc;
        private final ArrayList events = new ArrayList();

        public ApplicationDescriptorTracker(BundleContext bc) {
            this.bc = bc;
        }

        public synchronized Object addingService(ServiceReference reference) {
            String pid = (String)reference.getProperty("service.pid");
            Boolean locked = (Boolean)reference.getProperty("application.locked");
            Boolean launchable = (Boolean)reference.getProperty("application.launchable");
            this.events.add(new Object[]{pid, ApplicationAdminTest.ADDED, locked, launchable});
            Object result = this.bc.getService(reference);
            this.notifyAll();
            return result;
        }

        public synchronized void modifiedService(ServiceReference reference, Object service) {
            String pid = (String)reference.getProperty("service.pid");
            Boolean locked = (Boolean)reference.getProperty("application.locked");
            Boolean launchable = (Boolean)reference.getProperty("application.launchable");
            this.events.add(new Object[]{pid, ApplicationAdminTest.MODIFIED, locked, launchable});
            this.notifyAll();
        }

        public synchronized void removedService(ServiceReference reference, Object service) {
            String pid = (String)reference.getProperty("service.pid");
            Boolean locked = (Boolean)reference.getProperty("application.locked");
            Boolean launchable = (Boolean)reference.getProperty("application.launchable");
            this.events.add(new Object[]{pid, ApplicationAdminTest.REMOVED, locked, launchable});
            this.notifyAll();
        }

        public synchronized void waitForEvent(String pid, String type, Boolean locked, Boolean launchable) {
            long delay = 5000L;
            long startTime = System.currentTimeMillis();
            boolean found = this.eventFound(pid, type, locked, launchable);
            while (delay > 0L && !found) {
                try {
                    this.wait(5000L);
                    delay -= System.currentTimeMillis() - startTime;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                found = this.eventFound(pid, type, locked, launchable);
            }
            if (!found) {
                String foundEventsMsg;
                Object[][] foundEvents = this.getEvents();
                if (foundEvents.length > 0) {
                    StringBuilder eventsBuffer = new StringBuilder();
                    eventsBuffer.append("\nFound the following events: \n");
                    Object[][] objectArray = foundEvents;
                    int n = foundEvents.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object[] foundEvent = objectArray[n2];
                        eventsBuffer.append(" descriptor event: ").append(foundEvent[0]).append(" ").append(foundEvent[1]).append(" ").append(foundEvent[2]).append(" ").append(foundEvent[3]).append("\n");
                        ++n2;
                    }
                    foundEventsMsg = eventsBuffer.toString();
                } else {
                    foundEventsMsg = "\nNo events recorded";
                }
                ApplicationAdminTest.fail((String)("failed waiting for descriptor event: " + pid + " " + type + " " + String.valueOf(locked) + " " + String.valueOf(launchable) + foundEventsMsg));
            }
        }

        public synchronized Object[][] getEvents() {
            return (Object[][])this.events.toArray((T[])new Object[this.events.size()][]);
        }

        private boolean eventFound(String pid, String type, Boolean locked, Boolean launchable) {
            if (this.events.size() == 0) {
                return false;
            }
            Object[] event = (Object[])this.events.get(this.events.size() - 1);
            return pid.equals(event[0]) && type.equals(event[1]) && locked.equals(event[2]) && launchable.equals(event[3]);
        }
    }

    public static class ApplicationHandleTracker
    implements ServiceTrackerCustomizer {
        private final ArrayList events = new ArrayList();
        private final BundleContext bc;

        public ApplicationHandleTracker(BundleContext bc) {
            this.bc = bc;
        }

        public synchronized Object addingService(ServiceReference reference) {
            String instance = (String)reference.getProperty("service.pid");
            String state = (String)reference.getProperty("application.state");
            this.events.add(new String[]{instance, state});
            Object result = this.bc.getService(reference);
            this.notifyAll();
            return result;
        }

        public synchronized void modifiedService(ServiceReference reference, Object service) {
            String instance = (String)reference.getProperty("service.pid");
            String state = (String)reference.getProperty("application.state");
            this.events.add(new String[]{instance, state});
            this.notifyAll();
        }

        public synchronized void removedService(ServiceReference reference, Object service) {
            String instance = (String)reference.getProperty("service.pid");
            this.events.add(new String[]{instance, ApplicationAdminTest.REMOVED});
            this.notifyAll();
        }

        public synchronized void waitForEvent(String instance, String state) {
            long delay = 5000L;
            long startTime = System.currentTimeMillis();
            boolean found = this.eventFound(instance, state);
            while (delay > 0L && !found) {
                try {
                    this.wait(5000L);
                    delay -= System.currentTimeMillis() - startTime;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                found = this.eventFound(instance, state);
            }
            if (!found) {
                String foundEventsMsg;
                String[][] foundEvents = this.getEvents();
                if (foundEvents.length > 0) {
                    StringBuilder eventsBuffer = new StringBuilder();
                    eventsBuffer.append("\nFound the following events: \n");
                    String[][] stringArray = foundEvents;
                    int n = foundEvents.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String[] foundEvent = stringArray[n2];
                        eventsBuffer.append(" handle event: ").append((Object)foundEvent[0]).append(" ").append((Object)foundEvent[1]).append("\n");
                        ++n2;
                    }
                    foundEventsMsg = eventsBuffer.toString();
                } else {
                    foundEventsMsg = "\nNo events recorded";
                }
                ApplicationAdminTest.fail((String)("failed waiting for handle event: " + instance + " " + state + foundEventsMsg));
            }
        }

        public synchronized String[][] getEvents() {
            return (String[][])this.events.toArray((T[])new String[this.events.size()][]);
        }

        private boolean eventFound(String instance, String state) {
            if (this.events.size() == 0) {
                return false;
            }
            String[] event = (String[])this.events.get(this.events.size() - 1);
            return instance.equals(event[0]) && state.equals(event[1]);
        }
    }
}

