/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.appadmin;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.tests.session.ConfigurationSessionTestSuite;
import org.eclipse.core.tests.session.SetupManager;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.application.ApplicationDescriptor;
import org.osgi.service.application.ApplicationHandle;

public class ApplicationRelaunchTest
extends TestCase {
    public static final String testRunnerRelauncherApp = "org.eclipse.osgi.tests.relaunchApp";
    public static final String testResults = "test.results";
    public static final String SUCCESS = "success";
    public static final String simpleResults = "test.simpleResults";
    public static final String[] tests = new String[]{"testRelaunch"};

    public static Test suite() {
        TestSuite suite = new TestSuite(ApplicationRelaunchTest.class.getName());
        ConfigurationSessionTestSuite appAdminSessionTest = new ConfigurationSessionTestSuite("org.eclipse.osgi.tests", ApplicationRelaunchTest.class.getName());
        OSGiTestsActivator.addRequiredOSGiTestsBundles(appAdminSessionTest);
        appAdminSessionTest.setApplicationId(testRunnerRelauncherApp);
        try {
            appAdminSessionTest.getSetup().setSystemProperty("eclipse.application.registerDescriptors", "true");
        }
        catch (SetupManager.SetupException e) {
            throw new RuntimeException(e);
        }
        String[] stringArray = tests;
        int n = tests.length;
        int n2 = 0;
        while (n2 < n) {
            String test = stringArray[n2];
            appAdminSessionTest.addTest((Test)new ApplicationRelaunchTest(test));
            ++n2;
        }
        suite.addTest((Test)appAdminSessionTest);
        return suite;
    }

    public ApplicationRelaunchTest(String name) {
        super(name);
    }

    private ApplicationDescriptor getApplication(String appName) throws InvalidSyntaxException {
        ApplicationDescriptor result;
        BundleContext context = OSGiTestsActivator.getContext();
        ApplicationRelaunchTest.assertNotNull((String)"BundleContext is null!!", (Object)context);
        Class<ApplicationDescriptor> appDescClass = ApplicationDescriptor.class;
        ApplicationRelaunchTest.assertNotNull((String)"ApplicationDescriptor.class is null!!", appDescClass);
        ServiceReference[] refs = context.getServiceReferences(appDescClass.getName(), "(service.pid=" + appName + ")");
        if (refs == null || refs.length == 0) {
            refs = OSGiTestsActivator.getContext().getServiceReferences(ApplicationDescriptor.class.getName(), null);
            Object availableApps = "";
            if (refs != null) {
                int i = 0;
                while (i < refs.length) {
                    availableApps = (String)availableApps + String.valueOf(refs[i].getProperty("service.pid"));
                    if (i < refs.length - 1) {
                        availableApps = (String)availableApps + ",";
                    }
                    ++i;
                }
            }
            ApplicationRelaunchTest.fail((String)("Could not find app pid: " + appName + " available apps are: " + (String)availableApps));
        }
        if ((result = (ApplicationDescriptor)OSGiTestsActivator.getContext().getService(refs[0])) != null) {
            OSGiTestsActivator.getContext().ungetService(refs[0]);
        } else {
            ApplicationRelaunchTest.fail((String)("Could not get application descriptor service: " + appName));
        }
        return result;
    }

    private HashMap getArguments() {
        HashMap args = new HashMap();
        args.put(testResults, new HashMap());
        return args;
    }

    public void testRelaunch() throws Exception {
        ApplicationDescriptor app = this.getApplication("org.eclipse.osgi.tests.simpleApp");
        HashMap args = this.getArguments();
        HashMap results = (HashMap)args.get(testResults);
        ApplicationHandle handle = app.launch((Map)args);
        handle.destroy();
        String result = (String)results.get(simpleResults);
        ApplicationRelaunchTest.assertEquals((String)"Check application result", (String)SUCCESS, (String)result);
    }
}

