/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.eclipse.osgi.framework.util.ThreadInfoReport;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.BundleInstaller;
import org.eclipse.osgi.tests.bundles.EventListenerTestResults;
import org.eclipse.osgi.tests.bundles.SyncEventListenerTestResults;
import org.eclipse.osgi.tests.bundles.TestResults;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.launch.Framework;

public class AbstractBundleTests {
    public static int BUNDLE_LISTENER = 1;
    public static int SYNC_BUNDLE_LISTENER = 2;
    public static int SIMPLE_RESULTS = 4;
    public static final String BUNDLES_ROOT = "bundle_tests";
    public static TestResults simpleResults;
    public static EventListenerTestResults listenerResults;
    public static SyncEventListenerTestResults syncListenerResults;
    public static EventListenerTestResults frameworkListenerResults;
    public static BundleInstaller installer;
    @Rule
    public final TestName testName = new TestName();

    @Before
    public void setUp() throws Exception {
        installer = new BundleInstaller(BUNDLES_ROOT, this.getContext());
        installer.refreshPackages(null);
        listenerResults = new EventListenerTestResults();
        this.getContext().addBundleListener((BundleListener)listenerResults);
        syncListenerResults = new SyncEventListenerTestResults();
        this.getContext().addBundleListener((BundleListener)syncListenerResults);
        simpleResults = new TestResults();
        frameworkListenerResults = new EventListenerTestResults();
        this.getContext().addFrameworkListener((FrameworkListener)frameworkListenerResults);
    }

    @After
    public void tearDown() throws Exception {
        installer.shutdown();
        installer = null;
        this.getContext().removeBundleListener((BundleListener)listenerResults);
        this.getContext().removeBundleListener((BundleListener)syncListenerResults);
        this.getContext().removeFrameworkListener((FrameworkListener)frameworkListenerResults);
        listenerResults = null;
        syncListenerResults = null;
        simpleResults = null;
        frameworkListenerResults = null;
    }

    protected String getName() {
        return this.testName.getMethodName();
    }

    public BundleContext getContext() {
        return OSGiTestsActivator.getContext();
    }

    public static void compareResults(Object[] expectedEvents, Object[] actualEvents) {
        String expectedActual = " -- EXPECTED:" + AbstractBundleTests.toStringEventArray(expectedEvents) + " ACTUAL:" + AbstractBundleTests.toStringEventArray(actualEvents);
        Assert.assertEquals((String)("compareResults length" + expectedActual), (long)expectedEvents.length, (long)actualEvents.length);
        int i = 0;
        while (i < expectedEvents.length) {
            String assertMsg = "compareResults: " + i + expectedActual;
            AbstractBundleTests.assertEqualEvent(assertMsg, expectedEvents[i], actualEvents[i]);
            ++i;
        }
    }

    private static String toStringEventArray(Object[] events) {
        return Arrays.stream(events).map(AbstractBundleTests::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    protected static void assertEqualEvent(String message, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            Assert.assertEquals((String)message, (Object)AbstractBundleTests.toString(expected), (Object)AbstractBundleTests.toString(actual));
        }
        if (AbstractBundleTests.isEqual(expected, actual)) {
            return;
        }
        Assert.assertEquals((String)message, (Object)AbstractBundleTests.toString(expected), (Object)AbstractBundleTests.toString(actual));
    }

    private static boolean isEqual(Object expected, Object actual) {
        if (expected instanceof BundleEvent && actual instanceof BundleEvent) {
            return AbstractBundleTests.isEqual((BundleEvent)expected, (BundleEvent)actual);
        }
        if (expected instanceof FrameworkEvent && actual instanceof FrameworkEvent) {
            return AbstractBundleTests.isEqual((FrameworkEvent)expected, (FrameworkEvent)actual);
        }
        return expected.equals(actual);
    }

    private static boolean isEqual(BundleEvent expected, BundleEvent actual) {
        return expected.getSource() == actual.getSource() && expected.getType() == actual.getType();
    }

    private static boolean isEqual(FrameworkEvent expected, FrameworkEvent actual) {
        return expected.getSource() == actual.getSource() && expected.getType() == actual.getType();
    }

    private static String toString(Object object) {
        if (object instanceof BundleEvent) {
            return AbstractBundleTests.toString((BundleEvent)object);
        }
        if (object instanceof FrameworkEvent) {
            return AbstractBundleTests.toString((FrameworkEvent)object);
        }
        return object.toString();
    }

    private static String toString(FrameworkEvent event) {
        StringBuilder result = new StringBuilder("FrameworkEvent [");
        switch (event.getType()) {
            case 2: {
                result.append("ERROR");
                break;
            }
            case 32: {
                result.append("INFO");
                break;
            }
            case 4: {
                result.append("PACKAGES_REFRESHED");
                break;
            }
            case 1: {
                result.append("STARTED");
                break;
            }
            case 8: {
                result.append("STARTLEVEL_CHANGED");
                break;
            }
            case 16: {
                result.append("WARNING");
                break;
            }
        }
        result.append("] ").append(event.getSource());
        return result.toString();
    }

    private static String toString(BundleEvent event) {
        StringBuilder result = new StringBuilder("BundleEvent [");
        switch (event.getType()) {
            case 1: {
                result.append("INSTALLED");
                break;
            }
            case 512: {
                result.append("LAZY_ACTIVATION");
                break;
            }
            case 32: {
                result.append("RESOLVED");
                break;
            }
            case 2: {
                result.append("STARTED");
                break;
            }
            case 128: {
                result.append("STARTING");
                break;
            }
            case 4: {
                result.append("STOPPED");
                break;
            }
            case 256: {
                result.append("STOPPING");
                break;
            }
            case 16: {
                result.append("UNINSTALLED");
                break;
            }
            case 64: {
                result.append("UNRESOLVED");
                break;
            }
            case 8: {
                result.append("UPDATED");
                break;
            }
        }
        result.append("] ").append(event.getSource());
        return result.toString();
    }

    protected Map<String, Object> createConfiguration() {
        File file = this.getContext().getDataFile(this.getName());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("org.osgi.framework.storage", file.getAbsolutePath());
        return result;
    }

    protected void initAndStart(Equinox equinox) throws BundleException {
        equinox.init();
        equinox.start();
    }

    public static void stop(Framework equinox, int expected) {
        FrameworkEvent actual = AbstractBundleTests.stop(equinox);
        if (expected > 0) {
            Assert.assertNotNull((String)"No FrameworkEvent returned.", (Object)actual);
            Assert.assertEquals((String)"Wrong FrameworkEvent.", (Object)AbstractBundleTests.getFrameworkEventType(expected), (Object)AbstractBundleTests.getFrameworkEventType(actual.getType()));
        }
    }

    private static String getFrameworkEventType(int type) {
        switch (type) {
            case 2: {
                return "ERROR";
            }
            case 32: {
                return "INFO";
            }
            case 1: {
                return "STARTED";
            }
            case 64: {
                return "STOPPED";
            }
            case 256: {
                return "STOPPED_BOOTCLASSPATH_MODIFIED";
            }
            case 1024: {
                return "STOPPED_SYSTEM_REFRESHED";
            }
            case 128: {
                return "STOPPED_UPDATE";
            }
        }
        return "UNKNOWN:" + type;
    }

    public static FrameworkEvent stop(Framework equinox) {
        return AbstractBundleTests.stop(equinox, false, 10000L);
    }

    public static FrameworkEvent stopQuietly(Framework equinox) {
        return AbstractBundleTests.stop(equinox, true, 10000L);
    }

    protected static FrameworkEvent update(Framework equinox) throws BundleException, InterruptedException {
        FrameworkEvent[] success = new FrameworkEvent[1];
        String uuid = AbstractBundleTests.getUUID(equinox);
        Thread waitForUpdate = new Thread(() -> {
            FrameworkEvent frameworkEvent = AbstractBundleTests.waitForStop(equinox, uuid, false, 10000L);
        }, "test waitForStop thread");
        waitForUpdate.start();
        Thread.sleep(200L);
        equinox.update();
        waitForUpdate.join();
        return success[0];
    }

    public static FrameworkEvent stop(Framework equinox, boolean quietly, long timeout) {
        String uuid;
        block3: {
            if (equinox == null) {
                return null;
            }
            uuid = AbstractBundleTests.getUUID(equinox);
            try {
                equinox.stop();
            }
            catch (BundleException e) {
                if (quietly) break block3;
                Assert.fail((String)("Unexpected error stopping framework:" + e.getMessage()));
            }
        }
        return AbstractBundleTests.waitForStop(equinox, uuid, quietly, timeout);
    }

    protected static boolean delete(File file) {
        if (file.exists()) {
            String[] list;
            if (file.isDirectory() && (list = file.list()) != null) {
                int len = list.length;
                int i = 0;
                while (i < len) {
                    AbstractBundleTests.delete(new File(file, list[i]));
                    ++i;
                }
            }
            return file.delete();
        }
        return true;
    }

    public static FrameworkEvent waitForStop(Framework equinox, String uuid, boolean quietly, long timeout) {
        try {
            FrameworkEvent stopEvent = equinox.waitForStop(timeout);
            if (stopEvent.getType() == 512) {
                StringBuilder sb = new StringBuilder("Framework state is: ");
                sb.append(AbstractBundleTests.getState(equinox)).append(" - ").append(uuid).append('\n');
                sb.append(ThreadInfoReport.getThreadDump(null)).append('\n');
                if (!quietly) {
                    Assert.fail((String)sb.toString());
                } else {
                    System.out.println(sb.toString());
                }
            }
            return stopEvent;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            if (!quietly) {
                Assert.fail((String)"Unexpected interrupted exception");
            }
            return null;
        }
    }

    public static String getUUID(Framework equinox) {
        BundleContext bc = equinox.getBundleContext();
        return bc == null ? null : bc.getProperty("org.osgi.framework.uuid");
    }

    private static String getState(Framework framework) {
        int state = framework.getState();
        switch (state) {
            case 1: {
                return "UNINSTALLED";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 32: {
                return "ACTIVE";
            }
            case 16: {
                return "STOPPING";
            }
        }
        return "UNKNOWN:" + state;
    }

    static class BundleBuilder {
        private final BundleManifestBuilder manifestBuilder = new BundleManifestBuilder();

        BundleBuilder() {
        }

        public InputStream build() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JarOutputStream jos = new JarOutputStream((OutputStream)baos, this.manifestBuilder.build());
            jos.close();
            return new ByteArrayInputStream(baos.toByteArray());
        }

        public BundleBuilder symbolicName(String value) {
            this.manifestBuilder.symbolicName(value);
            return this;
        }

        static class BundleManifestBuilder {
            private final Manifest manifest = new Manifest();

            BundleManifestBuilder() {
            }

            public Manifest build() {
                this.manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
                return this.manifest;
            }

            public BundleManifestBuilder symbolicName(String value) {
                this.manifest.getMainAttributes().putValue("Bundle-SymbolicName", value);
                return this;
            }
        }
    }
}

